/*     */ package org.jboss.security.auth.login;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.AuthPermission;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.AppConfigurationEntry;
/*     */ 
/*     */ public class AuthenticationInfo extends BaseAuthenticationInfo
/*     */ {
/*  44 */   public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
/*  45 */   public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");
/*     */   private CallbackHandler callbackHandler;
/*     */ 
/*     */   public AuthenticationInfo()
/*     */   {
/*  50 */     this(null);
/*     */   }
/*     */ 
/*     */   public AuthenticationInfo(String name) {
/*  54 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public AppConfigurationEntry[] copyAppConfigurationEntry()
/*     */   {
/*  62 */     SecurityManager sm = System.getSecurityManager();
/*  63 */     if (sm != null)
/*  64 */       sm.checkPermission(GET_CONFIG_ENTRY_PERM);
/*  65 */     AppConfigurationEntry[] copy = new AppConfigurationEntry[this.moduleEntries.size()];
/*  66 */     for (int i = 0; i < copy.length; i++)
/*     */     {
/*  68 */       AppConfigurationEntry entry = (AppConfigurationEntry)this.moduleEntries.get(i);
/*  69 */       HashMap options = new HashMap(entry.getOptions());
/*  70 */       if (!disableSecurityDomainInOptions())
/*     */       {
/*  72 */         options.put("jboss.security.security_domain", getName());
/*     */       }
/*  74 */       copy[i] = new AppConfigurationEntry(entry.getLoginModuleName(), entry.getControlFlag(), options);
/*     */     }
/*     */ 
/*  77 */     return copy;
/*     */   }
/*     */ 
/*     */   public void addAppConfigurationEntry(AppConfigurationEntry entry)
/*     */   {
/*  82 */     this.moduleEntries.add(entry);
/*     */   }
/*     */ 
/*     */   public AppConfigurationEntry[] getAppConfigurationEntry()
/*     */   {
/*  90 */     SecurityManager sm = System.getSecurityManager();
/*  91 */     if (sm != null)
/*  92 */       sm.checkPermission(GET_CONFIG_ENTRY_PERM);
/*  93 */     AppConfigurationEntry[] entries = new AppConfigurationEntry[this.moduleEntries.size()];
/*  94 */     this.moduleEntries.toArray(entries);
/*  95 */     return entries;
/*     */   }
/*     */ 
/*     */   public void setAppConfigurationEntry(AppConfigurationEntry[] loginModules)
/*     */   {
/* 102 */     SecurityManager sm = System.getSecurityManager();
/* 103 */     if (sm != null) {
/* 104 */       sm.checkPermission(SET_CONFIG_ENTRY_PERM);
/*     */     }
/* 106 */     this.moduleEntries.addAll(Arrays.asList(loginModules));
/*     */   }
/*     */ 
/*     */   public CallbackHandler getAppCallbackHandler()
/*     */   {
/* 113 */     return this.callbackHandler;
/*     */   }
/*     */ 
/*     */   public void setAppCallbackHandler(CallbackHandler handler) {
/* 117 */     this.callbackHandler = handler;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 122 */     StringBuffer buffer = new StringBuffer("AppConfigurationEntry[]:\n");
/* 123 */     for (int i = 0; i < this.moduleEntries.size(); i++)
/*     */     {
/* 125 */       AppConfigurationEntry entry = (AppConfigurationEntry)this.moduleEntries.get(i);
/* 126 */       buffer.append("[" + i + "]");
/* 127 */       buffer.append("\nLoginModule Class: " + entry.getLoginModuleName());
/* 128 */       buffer.append("\nControlFlag: " + entry.getControlFlag());
/* 129 */       buffer.append("\nOptions:");
/* 130 */       Map options = entry.getOptions();
/* 131 */       Iterator iter = options.entrySet().iterator();
/* 132 */       while (iter.hasNext())
/*     */       {
/* 134 */         Map.Entry e = (Map.Entry)iter.next();
/* 135 */         buffer.append("name=" + e.getKey());
/* 136 */         buffer.append(", value=" + e.getValue());
/* 137 */         buffer.append("\n");
/*     */       }
/*     */     }
/* 140 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private boolean disableSecurityDomainInOptions()
/*     */   {
/* 145 */     String sysprop = (String)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 149 */         return System.getProperty("jboss.security.disable.secdomain.option");
/*     */       }
/*     */     });
/* 152 */     return "true".equalsIgnoreCase(sysprop);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.login.AuthenticationInfo
 * JD-Core Version:    0.6.0
 */