/*     */ package org.jboss.security.auth.login;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import javax.security.auth.login.AppConfigurationEntry;
/*     */ import javax.security.auth.login.AppConfigurationEntry.LoginModuleControlFlag;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.GenericValueContainer;
/*     */ 
/*     */ public class AppConfigurationEntryHolder
/*     */   implements GenericValueContainer
/*     */ {
/*     */   String code;
/*  42 */   AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
/*  43 */   HashMap options = new HashMap();
/*     */ 
/*     */   public AppConfigurationEntryHolder()
/*     */   {
/*     */   }
/*     */ 
/*     */   AppConfigurationEntryHolder(String code, String flag)
/*     */   {
/*  52 */     this.code = code;
/*  53 */     this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
/*  54 */     if (flag != null)
/*     */     {
/*  57 */       flag = flag.toLowerCase();
/*  58 */       if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.toString().indexOf(flag) > 0)
/*  59 */         this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
/*  60 */       else if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.toString().indexOf(flag) > 0)
/*  61 */         this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
/*  62 */       else if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.toString().indexOf(flag) > 0)
/*  63 */         this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
/*  64 */       else if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.toString().indexOf(flag) > 0)
/*  65 */         this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
/*     */     }
/*     */   }
/*     */ 
/*     */   public AppConfigurationEntry getEntry()
/*     */   {
/*  71 */     AppConfigurationEntry entry = new AppConfigurationEntry(this.code, this.controlFlag, this.options);
/*  72 */     return entry;
/*     */   }
/*     */ 
/*     */   public void addOption(ModuleOption option)
/*     */   {
/*  77 */     this.options.put(option.name, option.value);
/*     */   }
/*     */ 
/*     */   public void addChild(QName name, Object value)
/*     */   {
/*  84 */     if ("code".equals(name.getLocalPart()))
/*     */     {
/*  86 */       this.code = ((String)value);
/*     */     }
/*  88 */     else if ("flag".equals(name.getLocalPart()))
/*     */     {
/*  91 */       String flag = ((String)value).toLowerCase();
/*  92 */       if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.toString().indexOf(flag) > 0)
/*  93 */         this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
/*  94 */       else if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.toString().indexOf(flag) > 0)
/*  95 */         this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
/*  96 */       else if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.toString().indexOf(flag) > 0)
/*  97 */         this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
/*  98 */       else if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.toString().indexOf(flag) > 0)
/*  99 */         this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
/*     */     }
/* 101 */     else if ("module-option".equals(name.getLocalPart()))
/*     */     {
/* 103 */       addOption((ModuleOption)value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object instantiate()
/*     */   {
/* 109 */     return new AppConfigurationEntry(this.code, this.controlFlag, this.options);
/*     */   }
/*     */ 
/*     */   public Class getTargetClass()
/*     */   {
/* 114 */     return AppConfigurationEntry.class;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.login.AppConfigurationEntryHolder
 * JD-Core Version:    0.6.0
 */