/*    */ package org.jboss.security.auth.container.modules;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.Arrays;
/*    */ import java.util.Map;
/*    */ import javax.security.auth.Subject;
/*    */ import javax.security.auth.callback.Callback;
/*    */ import javax.security.auth.callback.CallbackHandler;
/*    */ import javax.security.auth.callback.NameCallback;
/*    */ import javax.security.auth.callback.PasswordCallback;
/*    */ import javax.security.auth.message.AuthException;
/*    */ import javax.security.auth.message.AuthStatus;
/*    */ import javax.security.auth.message.MessageInfo;
/*    */ 
/*    */ public class SimpleServerAuthModule extends AbstractServerAuthModule
/*    */ {
/*    */   public SimpleServerAuthModule()
/*    */   {
/* 48 */     this.supportedTypes.add(Object.class);
/* 49 */     this.supportedTypes.add(Object.class);
/*    */   }
/*    */ 
/*    */   public SimpleServerAuthModule(Class[] supTypes)
/*    */   {
/* 55 */     this.supportedTypes.addAll(Arrays.asList(supTypes));
/*    */   }
/*    */ 
/*    */   public AuthStatus secureResponse(MessageInfo param, Subject source)
/*    */     throws AuthException
/*    */   {
/* 64 */     return AuthStatus.SUCCESS;
/*    */   }
/*    */ 
/*    */   protected boolean validate(Subject clientSubject)
/*    */     throws AuthException
/*    */   {
/* 72 */     NameCallback nc = new NameCallback("Dummy");
/* 73 */     PasswordCallback pc = new PasswordCallback("B", true);
/*    */     try
/*    */     {
/* 76 */       this.callbackHandler.handle(new Callback[] { nc, pc });
/* 77 */       String userName = nc.getName();
/* 78 */       String pwd = new String(pc.getPassword());
/*    */ 
/* 81 */       if ((!userName.equals(this.options.get("principal"))) || (!pwd.equals(this.options.get("pass"))))
/*    */       {
/* 84 */         return false;
/*    */       }
/*    */ 
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 90 */       throw new AuthException(e.getLocalizedMessage());
/*    */     }
/* 92 */     return true;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.container.modules.SimpleServerAuthModule
 * JD-Core Version:    0.6.0
 */