/*    */ package org.jboss.security.auth.container.modules;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ import java.security.PrivilegedActionException;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ import javax.security.auth.Subject;
/*    */ import javax.security.auth.callback.CallbackHandler;
/*    */ import javax.security.auth.login.LoginContext;
/*    */ import javax.security.auth.login.LoginException;
/*    */ 
/*    */ class SecurityActions
/*    */ {
/*    */   static ClassLoader getContextClassloader()
/*    */   {
/* 46 */     return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction()
/*    */     {
/*    */       public Object run()
/*    */       {
/* 50 */         return Thread.currentThread().getContextClassLoader();
/*    */       }
/*    */     });
/*    */   }
/*    */ 
/*    */   static LoginContext createLoginContext(String configName, Subject subject, CallbackHandler cbh) throws PrivilegedActionException
/*    */   {
/* 58 */     return (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction(configName, subject, cbh)
/*    */     {
/*    */       public Object run() throws LoginException
/*    */       {
/* 62 */         return new LoginContext(this.val$configName, this.val$subject, this.val$cbh);
/*    */       }
/*    */     });
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.container.modules.SecurityActions
 * JD-Core Version:    0.6.0
 */