/*    */ package org.jboss.security.auth.container.modules;
/*    */ 
/*    */ import java.security.Principal;
/*    */ import java.util.ArrayList;
/*    */ import java.util.Map;
/*    */ import javax.security.auth.Subject;
/*    */ import javax.security.auth.message.AuthException;
/*    */ import javax.security.auth.message.AuthStatus;
/*    */ import javax.security.auth.message.MessageInfo;
/*    */ import javax.servlet.http.HttpServletRequest;
/*    */ import javax.servlet.http.HttpServletResponse;
/*    */ import org.jboss.security.SimplePrincipal;
/*    */ import org.jboss.security.auth.callback.SecurityAssociationHandler;
/*    */ 
/*    */ public class HttpServletServerAuthModule extends DelegatingServerAuthModule
/*    */ {
/*    */   public HttpServletServerAuthModule()
/*    */   {
/* 48 */     this("");
/*    */   }
/*    */ 
/*    */   public HttpServletServerAuthModule(String lmshName)
/*    */   {
/* 53 */     super(lmshName);
/* 54 */     this.supportedTypes.add(HttpServletRequest.class);
/* 55 */     this.supportedTypes.add(HttpServletResponse.class);
/*    */   }
/*    */ 
/*    */   protected boolean validate(Subject clientSubject)
/*    */     throws AuthException
/*    */   {
/* 61 */     this.callbackHandler = new SecurityAssociationHandler(getUserName(), getCredential());
/* 62 */     return super.validate(clientSubject);
/*    */   }
/*    */ 
/*    */   public AuthStatus secureResponse(MessageInfo arg0, Subject arg1) throws AuthException
/*    */   {
/* 67 */     return null;
/*    */   }
/*    */ 
/*    */   private Principal getUserName()
/*    */   {
/* 72 */     String userNameParam = (String)this.options.get("userNameParam");
/* 73 */     if (!(this.requestInfo instanceof HttpServletRequest))
/* 74 */       throw new IllegalStateException("Wrong Form of request:" + this.requestInfo);
/* 75 */     HttpServletRequest hsr = (HttpServletRequest)this.requestInfo;
/* 76 */     return new SimplePrincipal(hsr.getParameter(userNameParam));
/*    */   }
/*    */ 
/*    */   private Object getCredential()
/*    */   {
/* 81 */     String passwordParam = (String)this.options.get("passwordParam");
/* 82 */     if (!(this.requestInfo instanceof HttpServletRequest))
/* 83 */       throw new IllegalStateException("Wrong Form of request:" + this.requestInfo);
/* 84 */     HttpServletRequest hsr = (HttpServletRequest)this.requestInfo;
/* 85 */     return hsr.getParameter(passwordParam);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.container.modules.HttpServletServerAuthModule
 * JD-Core Version:    0.6.0
 */