/*     */ package org.jboss.security.auth.container.modules;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.message.AuthException;
/*     */ import javax.security.auth.message.AuthStatus;
/*     */ import javax.security.auth.message.MessageInfo;
/*     */ import javax.security.auth.message.MessagePolicy;
/*     */ import javax.security.auth.message.module.ServerAuthModule;
/*     */ import javax.security.auth.spi.LoginModule;
/*     */ 
/*     */ public abstract class AbstractServerAuthModule
/*     */   implements ServerAuthModule
/*     */ {
/*  55 */   protected CallbackHandler callbackHandler = null;
/*     */ 
/*  57 */   protected MessagePolicy requestPolicy = null;
/*     */ 
/*  59 */   protected MessagePolicy responsePolicy = null;
/*     */ 
/*  61 */   protected Object requestInfo = null;
/*     */ 
/*  63 */   protected Object responseInfo = null;
/*     */ 
/*  65 */   protected Map options = null;
/*     */ 
/*  67 */   protected ArrayList<Class> supportedTypes = new ArrayList();
/*     */ 
/*     */   public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options)
/*     */     throws AuthException
/*     */   {
/*  76 */     this.requestPolicy = requestPolicy;
/*  77 */     this.responsePolicy = responsePolicy;
/*  78 */     this.callbackHandler = handler;
/*  79 */     this.options = options;
/*     */   }
/*     */ 
/*     */   public void cleanSubject(MessageInfo messageInfo, Subject subject)
/*     */     throws AuthException
/*     */   {
/*  85 */     subject.getPrincipals().clear();
/*  86 */     subject.getPublicCredentials().clear();
/*  87 */     subject.getPrivateCredentials().clear();
/*     */   }
/*     */ 
/*     */   public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject)
/*     */     throws AuthException
/*     */   {
/*  98 */     this.requestInfo = messageInfo.getRequestMessage();
/*  99 */     this.responseInfo = messageInfo.getResponseMessage();
/*     */ 
/* 101 */     String loginModuleName = (String)this.options.get("login-module-delegate");
/* 102 */     if (loginModuleName != null)
/*     */     {
/* 104 */       ClassLoader tcl = SecurityActions.getContextClassloader();
/*     */       try
/*     */       {
/* 107 */         Class clazz = tcl.loadClass(loginModuleName);
/* 108 */         LoginModule lm = (LoginModule)clazz.newInstance();
/* 109 */         lm.initialize(clientSubject, this.callbackHandler, new HashMap(), this.options);
/* 110 */         lm.login();
/* 111 */         lm.commit();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 115 */         throw new AuthException(e.getLocalizedMessage());
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 120 */       return validate(clientSubject) ? AuthStatus.SUCCESS : AuthStatus.FAILURE;
/*     */     }
/*     */ 
/* 123 */     return AuthStatus.SUCCESS;
/*     */   }
/*     */ 
/*     */   public Class[] getSupportedMessageTypes()
/*     */   {
/* 131 */     Class[] clsarr = new Class[this.supportedTypes.size()];
/* 132 */     this.supportedTypes.toArray(clsarr);
/* 133 */     return clsarr;
/*     */   }
/*     */ 
/*     */   public CallbackHandler getCallbackHandler()
/*     */   {
/* 140 */     return this.callbackHandler;
/*     */   }
/*     */ 
/*     */   public void setCallbackHandler(CallbackHandler callbackHandler)
/*     */   {
/* 145 */     this.callbackHandler = callbackHandler;
/*     */   }
/*     */ 
/*     */   protected abstract boolean validate(Subject paramSubject)
/*     */     throws AuthException;
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.container.modules.AbstractServerAuthModule
 * JD-Core Version:    0.6.0
 */