/*     */ package org.jboss.security.auth.container.config;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.login.AppConfigurationEntry.LoginModuleControlFlag;
/*     */ import org.jboss.security.auth.login.LoginModuleStackHolder;
/*     */ import org.jboss.security.auth.login.ModuleOption;
/*     */ 
/*     */ public class AuthModuleEntry
/*     */ {
/*  43 */   private AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
/*     */ 
/*  45 */   private Map options = new HashMap();
/*  46 */   private String name = null;
/*  47 */   private LoginModuleStackHolder loginModuleStackHolder = null;
/*  48 */   private String loginModuleStackHolderName = null;
/*     */ 
/*     */   public AuthModuleEntry(String authModuleName, Map options, String loginModuleStackHolderName)
/*     */   {
/*  59 */     this.name = authModuleName;
/*  60 */     if (options != null)
/*  61 */       this.options = options;
/*  62 */     this.loginModuleStackHolderName = loginModuleStackHolderName;
/*     */   }
/*     */ 
/*     */   public String getAuthModuleName()
/*     */   {
/*  71 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void addOption(ModuleOption option)
/*     */   {
/*  76 */     if (option == null)
/*  77 */       throw new IllegalArgumentException("Option is null");
/*  78 */     if (this.options == null)
/*  79 */       throw new IllegalStateException("Options is null");
/*  80 */     this.options.put(option.getName(), option.getValue());
/*     */   }
/*     */ 
/*     */   public Map getOptions()
/*     */   {
/*  89 */     return Collections.unmodifiableMap(this.options);
/*     */   }
/*     */ 
/*     */   public void setOptions(Map options)
/*     */   {
/*  94 */     this.options = options;
/*     */   }
/*     */ 
/*     */   public LoginModuleStackHolder getLoginModuleStackHolder()
/*     */   {
/* 105 */     return this.loginModuleStackHolder;
/*     */   }
/*     */ 
/*     */   public void setLoginModuleStackHolder(LoginModuleStackHolder loginModuleStackHolder)
/*     */   {
/* 116 */     if (loginModuleStackHolder == null)
/* 117 */       throw new IllegalArgumentException("loginModuleStackHolder is null");
/* 118 */     this.loginModuleStackHolder = loginModuleStackHolder;
/* 119 */     this.loginModuleStackHolderName = this.loginModuleStackHolder.getName();
/*     */   }
/*     */ 
/*     */   public String getLoginModuleStackHolderName()
/*     */   {
/* 124 */     return this.loginModuleStackHolderName;
/*     */   }
/*     */ 
/*     */   public void setLoginModuleStackHolderName(String loginModuleStackHolderName)
/*     */   {
/* 129 */     if (loginModuleStackHolderName == null)
/* 130 */       throw new IllegalArgumentException("loginModuleStackHolderName is null");
/* 131 */     this.loginModuleStackHolderName = loginModuleStackHolderName;
/*     */   }
/*     */ 
/*     */   public AppConfigurationEntry.LoginModuleControlFlag getControlFlag()
/*     */   {
/* 136 */     return this.controlFlag;
/*     */   }
/*     */ 
/*     */   public void setControlFlag(AppConfigurationEntry.LoginModuleControlFlag flag)
/*     */   {
/* 141 */     this.controlFlag = flag;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.container.config.AuthModuleEntry
 * JD-Core Version:    0.6.0
 */