/*    */ package org.jboss.security.auth.callback;
/*    */ 
/*    */ import java.lang.reflect.UndeclaredThrowableException;
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedActionException;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ import javax.security.auth.callback.CallbackHandler;
/*    */ import javax.security.jacc.PolicyContext;
/*    */ import javax.security.jacc.PolicyContextException;
/*    */ 
/*    */ public class SecurityActions
/*    */ {
/*    */   static CallbackHandler getContextCallbackHandler()
/*    */     throws PolicyContextException
/*    */   {
/* 87 */     if (System.getSecurityManager() == null)
/*    */     {
/* 89 */       return PolicyContextActions.NON_PRIVILEGED.getContextCallbackHandler();
/*    */     }
/*    */ 
/* 93 */     return PolicyContextActions.PRIVILEGED.getContextCallbackHandler();
/*    */   }
/*    */ 
/*    */   static abstract interface PolicyContextActions
/*    */   {
/*    */     public static final String CALLBACK_HANDLER_KEY = "org.jboss.security.auth.spi.CallbackHandler";
/* 44 */     public static final PolicyContextActions PRIVILEGED = new PolicyContextActions()
/*    */     {
/* 46 */       private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction()
/*    */       {
/*    */         public Object run() throws Exception
/*    */         {
/* 50 */           return (CallbackHandler)PolicyContext.getContext("org.jboss.security.auth.spi.CallbackHandler");
/*    */         }
/* 46 */       };
/*    */ 
/*    */       public CallbackHandler getContextCallbackHandler()
/*    */         throws PolicyContextException
/*    */       {
/*    */         Exception ex;
/*    */         try
/*    */         {
/* 58 */           return (CallbackHandler)AccessController.doPrivileged(this.exAction);
/*    */         }
/*    */         catch (PrivilegedActionException e)
/*    */         {
/* 62 */           ex = e.getException();
/* 63 */           if ((ex instanceof PolicyContextException))
/* 64 */             throw ((PolicyContextException)ex);
/*    */         }
/* 66 */         throw new UndeclaredThrowableException(ex);
/*    */       }
/* 44 */     };
/*    */ 
/* 71 */     public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions()
/*    */     {
/*    */       public CallbackHandler getContextCallbackHandler()
/*    */         throws PolicyContextException
/*    */       {
/* 76 */         return (CallbackHandler)PolicyContext.getContext("org.jboss.security.auth.spi.CallbackHandler");
/*    */       }
/* 71 */     };
/*    */ 
/*    */     public abstract CallbackHandler getContextCallbackHandler()
/*    */       throws PolicyContextException;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.callback.SecurityActions
 * JD-Core Version:    0.6.0
 */