/*    */ package org.jboss.security.auth.callback;
/*    */ 
/*    */ import java.io.BufferedReader;
/*    */ import java.io.IOException;
/*    */ import java.io.InputStreamReader;
/*    */ import java.io.PrintStream;
/*    */ import javax.security.auth.callback.Callback;
/*    */ import javax.security.auth.callback.CallbackHandler;
/*    */ import javax.security.auth.callback.NameCallback;
/*    */ import javax.security.auth.callback.PasswordCallback;
/*    */ import javax.security.auth.callback.UnsupportedCallbackException;
/*    */ 
/*    */ public class ConsoleInputHandler
/*    */   implements CallbackHandler
/*    */ {
/*    */   public void handle(Callback[] callbacks)
/*    */     throws UnsupportedCallbackException
/*    */   {
/* 53 */     for (int i = 0; i < callbacks.length; i++)
/*    */     {
/* 55 */       Callback c = callbacks[i];
/* 56 */       if ((c instanceof NameCallback))
/*    */       {
/* 58 */         NameCallback nc = (NameCallback)c;
/* 59 */         String prompt = nc.getPrompt();
/* 60 */         if (prompt == null) {
/* 61 */           prompt = "Enter Username: ";
/*    */         }
/* 63 */         System.out.print(prompt);
/* 64 */         InputStreamReader isr = new InputStreamReader(System.in);
/* 65 */         BufferedReader br = new BufferedReader(isr);
/*    */         try
/*    */         {
/* 68 */           String username = br.readLine();
/* 69 */           nc.setName(username);
/*    */         }
/*    */         catch (IOException e)
/*    */         {
/* 73 */           throw new SecurityException("Failed to obtain username, ioe=" + e.getMessage());
/*    */         }
/*    */       }
/* 76 */       else if ((c instanceof PasswordCallback))
/*    */       {
/* 78 */         PasswordCallback pc = (PasswordCallback)c;
/* 79 */         String prompt = pc.getPrompt();
/* 80 */         if (prompt == null) {
/* 81 */           prompt = "Enter Password: ";
/*    */         }
/* 83 */         System.out.print(prompt);
/* 84 */         InputStreamReader isr = new InputStreamReader(System.in);
/* 85 */         BufferedReader br = new BufferedReader(isr);
/*    */         try
/*    */         {
/* 88 */           String password = br.readLine();
/* 89 */           pc.setPassword(password.toCharArray());
/*    */         }
/*    */         catch (IOException e)
/*    */         {
/* 93 */           throw new SecurityException("Failed to obtain password, ioe=" + e.getMessage());
/*    */         }
/*    */       }
/*    */       else
/*    */       {
/* 98 */         throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.callback.ConsoleInputHandler
 * JD-Core Version:    0.6.0
 */