/*     */ package org.jboss.security.auth.callback;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.PrintStream;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.callback.Callback;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.callback.NameCallback;
/*     */ import javax.security.auth.callback.PasswordCallback;
/*     */ import javax.security.auth.callback.TextInputCallback;
/*     */ import javax.security.auth.callback.UnsupportedCallbackException;
/*     */ 
/*     */ public class AppCallbackHandler
/*     */   implements CallbackHandler
/*     */ {
/*     */   private String username;
/*     */   private char[] password;
/*     */   private byte[] data;
/*     */   private String text;
/*     */   private transient String prompt;
/*     */   private transient Object credential;
/*     */   private Map keyValuePair;
/*  72 */   private boolean consoleHandler = false;
/*     */ 
/*     */   public AppCallbackHandler()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AppCallbackHandler(String username, char[] password)
/*     */   {
/*  80 */     this.username = username;
/*  81 */     this.password = password;
/*     */   }
/*     */ 
/*     */   public AppCallbackHandler(String username, char[] password, byte[] data) {
/*  85 */     this.username = username;
/*  86 */     this.password = password;
/*  87 */     this.data = data;
/*     */   }
/*     */ 
/*     */   public AppCallbackHandler(String username, char[] password, byte[] data, String text) {
/*  91 */     this.username = username;
/*  92 */     this.password = password;
/*  93 */     this.data = data;
/*  94 */     this.text = text;
/*     */   }
/*     */ 
/*     */   public AppCallbackHandler(boolean isConsoleHandler)
/*     */   {
/* 106 */     this.consoleHandler = isConsoleHandler;
/*     */   }
/*     */ 
/*     */   public AppCallbackHandler(String prompt)
/*     */   {
/* 117 */     this.prompt = prompt;
/*     */   }
/*     */ 
/*     */   public AppCallbackHandler(Map mapOfValues)
/*     */   {
/* 128 */     this.keyValuePair = mapOfValues;
/*     */   }
/*     */ 
/*     */   public void setSecurityInfo(Principal p, Object cred)
/*     */   {
/* 133 */     this.username = p.getName();
/* 134 */     this.credential = cred;
/*     */   }
/*     */ 
/*     */   public String getPrompt()
/*     */   {
/* 139 */     return this.prompt;
/*     */   }
/*     */ 
/*     */   public Object getCredential() {
/* 143 */     return this.credential;
/*     */   }
/*     */ 
/*     */   public void setCredential(Object credential) {
/* 147 */     this.credential = credential;
/*     */   }
/*     */ 
/*     */   public void clearCredential() {
/* 151 */     this.credential = null;
/*     */   }
/*     */ 
/*     */   public void handle(Callback[] callbacks)
/*     */     throws IOException, UnsupportedCallbackException
/*     */   {
/* 157 */     for (int i = 0; i < callbacks.length; i++)
/*     */     {
/* 159 */       Callback c = callbacks[i];
/* 160 */       if ((c instanceof NameCallback))
/*     */       {
/* 162 */         NameCallback nc = (NameCallback)c;
/* 163 */         String prompt = nc.getPrompt();
/* 164 */         if (prompt == null)
/* 165 */           prompt = "Enter Username: ";
/* 166 */         if (this.consoleHandler)
/* 167 */           nc.setName(getUserNameFromConsole(prompt));
/*     */         else
/* 169 */           nc.setName(this.username);
/*     */       }
/* 171 */       else if ((c instanceof PasswordCallback))
/*     */       {
/* 173 */         PasswordCallback pc = (PasswordCallback)c;
/* 174 */         String prompt = pc.getPrompt();
/* 175 */         if (prompt == null)
/* 176 */           prompt = "Enter Password: ";
/* 177 */         if (this.consoleHandler) {
/* 178 */           pc.setPassword(getPasswordFromConsole(prompt));
/*     */         }
/* 180 */         else if ((this.credential != null) && (this.password == null))
/* 181 */           pc.setPassword(getPassword());
/*     */         else
/* 183 */           pc.setPassword(this.password);
/*     */       }
/* 185 */       else if ((c instanceof TextInputCallback))
/*     */       {
/* 187 */         TextInputCallback tc = (TextInputCallback)c;
/* 188 */         tc.setText(this.text);
/*     */       }
/* 190 */       else if ((c instanceof ByteArrayCallback))
/*     */       {
/* 192 */         ByteArrayCallback bac = (ByteArrayCallback)c;
/* 193 */         bac.setByteArray(this.data);
/*     */       }
/* 195 */       else if ((c instanceof ObjectCallback))
/*     */       {
/* 197 */         ObjectCallback oc = (ObjectCallback)c;
/* 198 */         oc.setCredential(this.credential);
/*     */       }
/* 200 */       else if ((c instanceof MapCallback))
/*     */       {
/* 202 */         MapCallback mc = (MapCallback)c;
/* 203 */         if ((this.keyValuePair != null) && (!this.keyValuePair.isEmpty()))
/*     */         {
/* 205 */           Iterator iter = this.keyValuePair.keySet().iterator();
/* 206 */           while (iter.hasNext())
/*     */           {
/* 208 */             Object key = iter.next();
/* 209 */             if (!(key instanceof String))
/* 210 */               throw new SecurityException("key is not a String");
/* 211 */             mc.setInfo((String)key, this.keyValuePair.get(key));
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 217 */         throw new UnsupportedCallbackException(c, "Unrecognized Callback");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getUserNameFromConsole(String prompt)
/*     */   {
/* 224 */     String uName = "";
/* 225 */     System.out.print(prompt);
/* 226 */     InputStreamReader isr = new InputStreamReader(System.in);
/* 227 */     BufferedReader br = new BufferedReader(isr);
/*     */     try
/*     */     {
/* 230 */       uName = br.readLine();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 234 */       throw new SecurityException("Failed to obtain username, ioe=" + e.getMessage());
/*     */     }
/* 236 */     return uName;
/*     */   }
/*     */ 
/*     */   private char[] getPasswordFromConsole(String prompt)
/*     */   {
/* 241 */     String pwd = "";
/*     */ 
/* 243 */     System.out.print(prompt);
/* 244 */     InputStreamReader isr = new InputStreamReader(System.in);
/* 245 */     BufferedReader br = new BufferedReader(isr);
/*     */     try
/*     */     {
/* 248 */       pwd = br.readLine();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 252 */       throw new SecurityException("Failed to obtain password, ioe=" + e.getMessage());
/*     */     }
/* 254 */     return pwd.toCharArray();
/*     */   }
/*     */ 
/*     */   private char[] getPassword()
/*     */   {
/* 268 */     char[] password = null;
/* 269 */     if ((this.credential instanceof char[]))
/*     */     {
/* 271 */       password = (char[])(char[])this.credential;
/*     */     }
/* 273 */     else if ((this.credential instanceof String))
/*     */     {
/* 275 */       String s = (String)this.credential;
/* 276 */       password = s.toCharArray();
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 282 */         Class[] types = new Class[0];
/* 283 */         Method m = this.credential.getClass().getMethod("toCharArray", types);
/* 284 */         Object[] args = new Object[0];
/* 285 */         password = (char[])(char[])m.invoke(this.credential, args);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 289 */         if (this.credential != null)
/*     */         {
/* 291 */           String s = this.credential.toString();
/* 292 */           password = s.toCharArray();
/*     */         }
/*     */       }
/*     */     }
/* 296 */     return password;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.callback.AppCallbackHandler
 * JD-Core Version:    0.6.0
 */