/*    */ package org.jboss.security.audit;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ 
/*    */ public abstract class AuditContext
/*    */ {
/* 38 */   protected String securityDomain = null;
/*    */ 
/* 40 */   protected List<AuditProvider> providerList = new ArrayList();
/*    */ 
/*    */   public void audit(AuditEvent ae)
/*    */   {
/* 44 */     int len = this.providerList.size();
/*    */ 
/* 46 */     for (int i = 0; i < len; i++)
/*    */     {
/* 48 */       AuditProvider ap = (AuditProvider)this.providerList.get(i);
/* 49 */       ap.audit(ae);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void addProvider(AuditProvider ap)
/*    */   {
/* 55 */     this.providerList.add(ap);
/*    */   }
/*    */ 
/*    */   public void addProviders(List<AuditProvider> list)
/*    */   {
/* 60 */     this.providerList.addAll(list);
/*    */   }
/*    */ 
/*    */   public List<AuditProvider> getProviders()
/*    */   {
/* 65 */     return this.providerList;
/*    */   }
/*    */ 
/*    */   public void replaceProviders(List<AuditProvider> list)
/*    */   {
/* 70 */     this.providerList.clear();
/* 71 */     this.providerList = list;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.audit.AuditContext
 * JD-Core Version:    0.6.0
 */