/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.security.acl.Group;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.audit.AuditManager;
/*     */ import org.jboss.security.config.ApplicationPolicy;
/*     */ import org.jboss.security.config.SecurityConfiguration;
/*     */ import org.jboss.security.identitytrust.IdentityTrustManager;
/*     */ import org.jboss.security.mapping.MappingManager;
/*     */ 
/*     */ public class SecurityUtil
/*     */ {
/*  48 */   private static Logger log = Logger.getLogger(SecurityUtil.class);
/*     */ 
/*     */   public static String unprefixSecurityDomain(String securityDomain)
/*     */   {
/*  57 */     String result = null;
/*  58 */     if (securityDomain != null)
/*     */     {
/*  60 */       if (securityDomain.startsWith("java:/jaas")) {
/*  61 */         result = securityDomain.substring("java:/jaas".length() + 1);
/*     */       }
/*  63 */       else if (securityDomain.startsWith("java:/jbsx"))
/*  64 */         result = securityDomain.substring("java:/jbsx".length() + 1);
/*     */       else
/*  66 */         result = securityDomain;
/*     */     }
/*  68 */     return result;
/*     */   }
/*     */ 
/*     */   public static Group getSubjectRoles(Subject theSubject)
/*     */   {
/*  79 */     if (theSubject == null)
/*  80 */       throw new IllegalArgumentException("Subject is null");
/*  81 */     Set subjectGroups = theSubject.getPrincipals(Group.class);
/*  82 */     Iterator iter = subjectGroups.iterator();
/*  83 */     Group roles = null;
/*  84 */     while (iter.hasNext())
/*     */     {
/*  86 */       Group grp = (Group)iter.next();
/*  87 */       String name = grp.getName();
/*  88 */       if (name.equals("Roles"))
/*  89 */         roles = grp;
/*     */     }
/*  91 */     return roles;
/*     */   }
/*     */ 
/*     */   public static ApplicationPolicy getApplicationPolicy(String domainName)
/*     */   {
/* 102 */     return SecurityConfiguration.getApplicationPolicy(domainName);
/*     */   }
/*     */ 
/*     */   public static AuthenticationManager getAuthenticationManager(String securityDomain, String baseContext)
/*     */   {
/* 114 */     String securityMgrURL = "/securityMgr";
/* 115 */     String lookupURL = null;
/* 116 */     if (securityDomain.startsWith(baseContext))
/* 117 */       lookupURL = securityDomain + securityMgrURL;
/*     */     else
/* 119 */       lookupURL = baseContext + "/" + securityDomain + securityMgrURL;
/* 120 */     AuthenticationManager am = null;
/*     */     try
/*     */     {
/* 123 */       InitialContext ic = new InitialContext();
/* 124 */       am = (AuthenticationManager)ic.lookup(lookupURL);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 128 */       if (log.isTraceEnabled())
/* 129 */         log.trace("Error in obtaining AuthenticationManager", e);
/*     */     }
/* 131 */     return am;
/*     */   }
/*     */ 
/*     */   public static AuthorizationManager getAuthorizationManager(String securityDomain, String baseContext)
/*     */   {
/* 143 */     String authorizationMgrURL = "/authorizationMgr";
/* 144 */     String lookupURL = null;
/* 145 */     if (securityDomain.startsWith(baseContext))
/* 146 */       lookupURL = securityDomain + authorizationMgrURL;
/*     */     else
/* 148 */       lookupURL = baseContext + "/" + securityDomain + authorizationMgrURL;
/* 149 */     AuthorizationManager am = null;
/*     */     try
/*     */     {
/* 152 */       InitialContext ic = new InitialContext();
/* 153 */       am = (AuthorizationManager)ic.lookup(lookupURL);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 157 */       if (log.isTraceEnabled())
/* 158 */         log.trace("Error in obtaining AuthorizationMgr", e);
/*     */     }
/* 160 */     return am;
/*     */   }
/*     */ 
/*     */   public static AuditManager getAuditManager(String securityDomain, String baseContext)
/*     */   {
/* 171 */     String auditMgrURL = "/auditMgr";
/* 172 */     String lookupURL = null;
/* 173 */     if (securityDomain.startsWith(baseContext))
/* 174 */       lookupURL = securityDomain + auditMgrURL;
/*     */     else
/* 176 */       lookupURL = baseContext + "/" + securityDomain + auditMgrURL;
/* 177 */     AuditManager am = null;
/*     */     try
/*     */     {
/* 180 */       InitialContext ic = new InitialContext();
/* 181 */       am = (AuditManager)ic.lookup(lookupURL);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 185 */       if (log.isTraceEnabled())
/* 186 */         log.trace("Error in obtaining AuditMgr", e);
/*     */     }
/* 188 */     return am;
/*     */   }
/*     */ 
/*     */   public static IdentityTrustManager getIdentityTrustManager(String securityDomain, String baseContext)
/*     */   {
/* 200 */     String identityTrustMgrURL = "/identityTrustMgr";
/* 201 */     String lookupURL = null;
/* 202 */     if (securityDomain.startsWith(baseContext))
/* 203 */       lookupURL = securityDomain + identityTrustMgrURL;
/*     */     else
/* 205 */       lookupURL = baseContext + "/" + securityDomain + identityTrustMgrURL;
/* 206 */     IdentityTrustManager am = null;
/*     */     try
/*     */     {
/* 209 */       InitialContext ic = new InitialContext();
/* 210 */       am = (IdentityTrustManager)ic.lookup(lookupURL);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 214 */       if (log.isTraceEnabled())
/* 215 */         log.trace("Error in obtaining IdentityTrustMgr", e);
/*     */     }
/* 217 */     return am;
/*     */   }
/*     */ 
/*     */   public static MappingManager getMappingManager(String securityDomain, String baseContext)
/*     */   {
/* 229 */     String mappingManagerURL = "/mappingMgr";
/* 230 */     String lookupURL = null;
/* 231 */     if (securityDomain.startsWith(baseContext))
/* 232 */       lookupURL = securityDomain + mappingManagerURL;
/*     */     else
/* 234 */       lookupURL = baseContext + "/" + securityDomain + mappingManagerURL;
/* 235 */     MappingManager am = null;
/*     */     try
/*     */     {
/* 238 */       InitialContext ic = new InitialContext();
/* 239 */       am = (MappingManager)ic.lookup(lookupURL);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 243 */       if (log.isTraceEnabled())
/* 244 */         log.trace("Error in obtaining IdentityTrustMgr", e);
/*     */     }
/* 246 */     return am;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.SecurityUtil
 * JD-Core Version:    0.6.0
 */