/*    */ package org.jboss.security;
/*    */ 
/*    */ import java.security.Principal;
/*    */ import javax.security.auth.Subject;
/*    */ 
/*    */ public class SecurityIdentity
/*    */ {
/* 40 */   SubjectInfo theSubject = null;
/* 41 */   RunAs runAs = null;
/* 42 */   RunAs callerRunAs = null;
/*    */ 
/*    */   public SecurityIdentity(SubjectInfo subject, RunAs outgoingRunAs, RunAs incomingRunAs)
/*    */   {
/* 52 */     this.theSubject = subject;
/* 53 */     this.runAs = outgoingRunAs;
/* 54 */     this.callerRunAs = incomingRunAs;
/*    */   }
/*    */ 
/*    */   public Principal getPrincipal()
/*    */   {
/* 59 */     return this.theSubject != null ? this.theSubject.getAuthenticationPrincipal() : null;
/*    */   }
/*    */ 
/*    */   public Object getCredential()
/*    */   {
/* 64 */     return this.theSubject != null ? this.theSubject.getAuthenticationCredential() : null;
/*    */   }
/*    */ 
/*    */   public Subject getSubject()
/*    */   {
/* 69 */     return this.theSubject != null ? this.theSubject.getAuthenticatedSubject() : null;
/*    */   }
/*    */ 
/*    */   public RunAs getOutgoingRunAs()
/*    */   {
/* 74 */     return this.runAs;
/*    */   }
/*    */ 
/*    */   public RunAs getIncomingRunAs()
/*    */   {
/* 79 */     return this.callerRunAs;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.SecurityIdentity
 * JD-Core Version:    0.6.0
 */