/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import javax.security.auth.Subject;
/*     */ 
/*     */ public abstract class SecurityContextUtil
/*     */ {
/*  38 */   protected SecurityContext securityContext = null;
/*     */ 
/*     */   public void setSecurityContext(SecurityContext sc)
/*     */   {
/*  42 */     this.securityContext = sc;
/*     */   }
/*     */ 
/*     */   public abstract String getUserName();
/*     */ 
/*     */   public abstract Principal getUserPrincipal();
/*     */ 
/*     */   public abstract Object getCredential();
/*     */ 
/*     */   public abstract Subject getSubject();
/*     */ 
/*     */   public abstract SecurityIdentity getSecurityIdentity();
/*     */ 
/*     */   public abstract void setSecurityIdentity(SecurityIdentity paramSecurityIdentity);
/*     */ 
/*     */   public abstract <T> T getRoles();
/*     */ 
/*     */   public abstract <T> void setRoles(T paramT);
/*     */ 
/*     */   public void createSubjectInfo(Principal principal, Object credential, Subject subject)
/*     */   {
/* 106 */     SubjectInfo si = new SubjectInfo(principal, credential, subject);
/* 107 */     this.securityContext.setSubjectInfo(si);
/*     */   }
/*     */ 
/*     */   public abstract <T> void set(String paramString, T paramT);
/*     */ 
/*     */   public abstract <T> T get(String paramString);
/*     */ 
/*     */   public abstract <T> T remove(String paramString);
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.SecurityContextUtil
 * JD-Core Version:    0.6.0
 */