/*      */ package org.jboss.security;
/*      */ 
/*      */ import java.security.Principal;
/*      */ import java.util.ArrayList;
/*      */ import java.util.HashMap;
/*      */ import javax.security.auth.Subject;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.security.plugins.SecurityContextAssociation;
/*      */ 
/*      */ public final class SecurityAssociation
/*      */ {
/*   64 */   private static Logger log = Logger.getLogger(SecurityAssociation.class);
/*      */   private static boolean trace;
/*      */   private static boolean server;
/*      */   private static Principal principal;
/*      */   private static Object credential;
/*      */   private static ThreadLocal threadPrincipal;
/*      */   private static ThreadLocal threadCredential;
/*      */   private static ThreadLocal threadContextMap;
/*      */   private static RunAsThreadLocalStack threadRunAsStacks;
/*      */   private static SubjectThreadLocalStack threadSubjectStacks;
/*  109 */   private static final RuntimePermission getPrincipalInfoPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.getPrincipalInfo");
/*      */ 
/*  114 */   private static final RuntimePermission getSubjectPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.getSubject");
/*      */ 
/*  120 */   private static final RuntimePermission setPrincipalInfoPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.setPrincipalInfo");
/*      */ 
/*  125 */   private static final RuntimePermission setServerPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.setServer");
/*      */ 
/*  130 */   private static final RuntimePermission setRunAsIdentity = new RuntimePermission("org.jboss.security.SecurityAssociation.setRunAsRole");
/*      */ 
/*  135 */   private static final RuntimePermission getContextInfo = new RuntimePermission("org.jboss.security.SecurityAssociation.accessContextInfo", "get");
/*      */ 
/*  140 */   private static final RuntimePermission setContextInfo = new RuntimePermission("org.jboss.security.SecurityAssociation.accessContextInfo", "set");
/*      */ 
/*      */   public static Principal getPrincipal()
/*      */   {
/*  183 */     SecurityManager sm = System.getSecurityManager();
/*  184 */     if (sm != null) {
/*  185 */       sm.checkPermission(getPrincipalInfoPermission);
/*      */     }
/*  187 */     Principal thePrincipal = principal;
/*      */ 
/*  190 */     if (server) {
/*  191 */       thePrincipal = (Principal)threadPrincipal.get();
/*      */     }
/*  193 */     if (trace) {
/*  194 */       log.trace("getPrincipal, principal=" + thePrincipal);
/*      */     }
/*  196 */     SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  197 */     if (sc != null)
/*      */     {
/*  199 */       if (trace)
/*  200 */         log.warn("You are using deprecated api to getPrincipal. Use security context based approach");
/*  201 */       thePrincipal = sc.getUtil().getUserPrincipal();
/*      */     }
/*  203 */     return thePrincipal;
/*      */   }
/*      */ 
/*      */   public static Principal getCallerPrincipal()
/*      */   {
/*  217 */     SecurityManager sm = System.getSecurityManager();
/*  218 */     if (sm != null) {
/*  219 */       sm.checkPermission(getPrincipalInfoPermission);
/*      */     }
/*      */ 
/*  231 */     SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  232 */     Principal thePrincipal = null;
/*  233 */     if (sc != null)
/*      */     {
/*  236 */       RunAs ras = sc.getIncomingRunAs();
/*  237 */       if (ras != null)
/*  238 */         thePrincipal = new SimplePrincipal(ras.getName());
/*      */       else
/*  240 */         thePrincipal = sc.getUtil().getUserPrincipal();
/*      */     }
/*  242 */     if (trace)
/*  243 */       log.trace("getCallerPrincipal, principal=" + thePrincipal);
/*  244 */     return thePrincipal;
/*      */   }
/*      */ 
/*      */   public static Object getCredential()
/*      */   {
/*  258 */     SecurityManager sm = System.getSecurityManager();
/*  259 */     if (sm != null) {
/*  260 */       sm.checkPermission(getPrincipalInfoPermission);
/*      */     }
/*      */ 
/*  267 */     SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  268 */     if (sc != null)
/*      */     {
/*  270 */       if (trace)
/*  271 */         log.warn("You are using deprecated api to getCredential. Use security context based approach");
/*  272 */       credential = sc.getUtil().getCredential();
/*      */     }
/*  274 */     return credential;
/*      */   }
/*      */ 
/*      */   public static Subject getSubject()
/*      */   {
/*  291 */     SecurityManager sm = System.getSecurityManager();
/*  292 */     if (sm != null) {
/*  293 */       sm.checkPermission(getSubjectPermission);
/*      */     }
/*  295 */     SubjectContext sc = threadSubjectStacks.peek();
/*  296 */     if (trace)
/*  297 */       log.trace("getSubject, sc=" + sc);
/*  298 */     Subject subject = null;
/*      */ 
/*  303 */     SecurityContext secContext = SecurityContextAssociation.getSecurityContext();
/*  304 */     if (secContext != null)
/*      */     {
/*  306 */       if (trace)
/*  307 */         log.warn("You are using deprecated api to getSubject. Use security context based approach");
/*  308 */       subject = secContext.getUtil().getSubject();
/*      */     }
/*  310 */     return subject;
/*      */   }
/*      */ 
/*      */   public static void setPrincipal(Principal principal)
/*      */   {
/*  323 */     SecurityManager sm = System.getSecurityManager();
/*  324 */     if (sm != null) {
/*  325 */       sm.checkPermission(setPrincipalInfoPermission);
/*      */     }
/*  327 */     if (trace) {
/*  328 */       log.trace("setPrincipal, p=" + principal + ", server=" + server);
/*      */     }
/*      */ 
/*  352 */     SecurityContext securityContext = SecurityContextAssociation.getSecurityContext();
/*      */ 
/*  354 */     if ((!server) && (securityContext == null))
/*      */     {
/*      */       try
/*      */       {
/*  358 */         securityContext = SecurityContextFactory.createSecurityContext("CLIENT_SIDE");
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  362 */         throw new RuntimeException(e);
/*      */       }
/*  364 */       SecurityContextAssociation.setSecurityContext(securityContext);
/*      */     }
/*  366 */     if (securityContext != null)
/*      */     {
/*  368 */       if (trace)
/*  369 */         log.warn("Using deprecated API. Move to a security context based approach");
/*  370 */       Object cred = securityContext.getUtil().getCredential();
/*  371 */       Subject subj = securityContext.getUtil().getSubject();
/*  372 */       securityContext.getUtil().createSubjectInfo(principal, cred, subj);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static void setCredential(Object credential)
/*      */   {
/*  389 */     SecurityManager sm = System.getSecurityManager();
/*  390 */     if (sm != null) {
/*  391 */       sm.checkPermission(setPrincipalInfoPermission);
/*      */     }
/*      */ 
/*  414 */     SecurityContext securityContext = SecurityContextAssociation.getSecurityContext();
/*      */ 
/*  416 */     if ((!server) && (securityContext == null))
/*      */     {
/*      */       try
/*      */       {
/*  420 */         securityContext = SecurityContextFactory.createSecurityContext("CLIENT_SIDE");
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  424 */         throw new RuntimeException(e);
/*      */       }
/*  426 */       SecurityContextAssociation.setSecurityContext(securityContext);
/*      */     }
/*      */ 
/*  429 */     if (securityContext != null)
/*      */     {
/*  431 */       if (trace)
/*  432 */         log.warn("Using deprecated API. Move to a security context based approach");
/*  433 */       Principal principal = securityContext.getUtil().getUserPrincipal();
/*  434 */       Subject subj = securityContext.getUtil().getSubject();
/*  435 */       securityContext.getUtil().createSubjectInfo(principal, credential, subj);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static void setSubject(Subject subject)
/*      */   {
/*  449 */     SecurityManager sm = System.getSecurityManager();
/*  450 */     if (sm != null) {
/*  451 */       sm.checkPermission(setPrincipalInfoPermission);
/*      */     }
/*  453 */     if (trace) {
/*  454 */       log.trace("setSubject, s=" + subject + ", server=" + server);
/*      */     }
/*  456 */     SubjectContext sc = threadSubjectStacks.peek();
/*  457 */     if (sc == null)
/*      */     {
/*  460 */       sc = new SubjectContext();
/*  461 */       threadSubjectStacks.push(sc);
/*      */     }
/*  463 */     else if ((sc.getFlags() & 0x1) != 0)
/*      */     {
/*  466 */       sc = new SubjectContext();
/*  467 */       threadSubjectStacks.push(sc);
/*      */     }
/*  469 */     sc.setSubject(subject);
/*  470 */     if (trace) {
/*  471 */       log.trace("setSubject, sc=" + sc);
/*      */     }
/*  473 */     SecurityContext sctx = SecurityContextAssociation.getSecurityContext();
/*  474 */     if (sctx != null)
/*      */     {
/*  476 */       SubjectInfo si = sctx.getSubjectInfo();
/*  477 */       if (si != null)
/*      */       {
/*  479 */         si.setAuthenticatedSubject(subject);
/*      */       }
/*      */       else
/*  482 */         sctx.getUtil().createSubjectInfo(null, null, subject);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static Object getContextInfo(Object key)
/*      */   {
/*  497 */     SecurityManager sm = System.getSecurityManager();
/*  498 */     if (sm != null) {
/*  499 */       sm.checkPermission(getContextInfo);
/*      */     }
/*  501 */     if (key == null)
/*  502 */       throw new IllegalArgumentException("key is null");
/*  503 */     HashMap contextInfo = (HashMap)threadContextMap.get();
/*  504 */     return contextInfo != null ? contextInfo.get(key) : null;
/*      */   }
/*      */ 
/*      */   public static Object setContextInfo(Object key, Object value)
/*      */   {
/*  519 */     SecurityManager sm = System.getSecurityManager();
/*  520 */     if (sm != null) {
/*  521 */       sm.checkPermission(setContextInfo);
/*      */     }
/*  523 */     HashMap contextInfo = (HashMap)threadContextMap.get();
/*  524 */     return contextInfo.put(key, value);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static void pushSubjectContext(Subject subject, Principal principal, Object credential)
/*      */   {
/*  543 */     SecurityManager sm = System.getSecurityManager();
/*  544 */     if (sm != null) {
/*  545 */       sm.checkPermission(setPrincipalInfoPermission);
/*      */     }
/*      */ 
/*  548 */     if (server)
/*      */     {
/*  550 */       threadPrincipal.set(principal);
/*  551 */       threadCredential.set(credential);
/*      */     }
/*      */     else
/*      */     {
/*  555 */       principal = principal;
/*  556 */       credential = credential;
/*      */     }
/*      */ 
/*  559 */     SubjectContext sc = new SubjectContext(subject, principal, credential);
/*  560 */     threadSubjectStacks.push(sc);
/*  561 */     if (trace) {
/*  562 */       log.trace("pushSubjectContext, subject=" + subject + ", sc=" + sc);
/*      */     }
/*  564 */     SecurityContext sctx = SecurityContextAssociation.getSecurityContext();
/*  565 */     if (sctx == null)
/*      */     {
/*  567 */       if (trace)
/*  568 */         log.trace("WARN::Deprecated usage of SecurityAssociation. Use SecurityContext");
/*      */       try
/*      */       {
/*  571 */         sctx = SecurityContextFactory.createSecurityContext("FROM_SECURITY_ASSOCIATION");
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  575 */         throw new RuntimeException(e);
/*      */       }
/*      */     }
/*  578 */     sctx.getUtil().createSubjectInfo(principal, credential, subject);
/*  579 */     SecurityContextAssociation.setSecurityContext(sctx);
/*      */   }
/*      */ 
/*      */   public static void dupSubjectContext()
/*      */   {
/*  589 */     SecurityManager sm = System.getSecurityManager();
/*  590 */     if (sm != null) {
/*  591 */       sm.checkPermission(setPrincipalInfoPermission);
/*      */     }
/*  593 */     SubjectContext sc = threadSubjectStacks.dup();
/*  594 */     if (trace)
/*  595 */       log.trace("dupSubjectContext, sc=" + sc);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static SubjectContext popSubjectContext()
/*      */   {
/*  609 */     SecurityManager sm = System.getSecurityManager();
/*  610 */     if (sm != null) {
/*  611 */       sm.checkPermission(setPrincipalInfoPermission);
/*      */     }
/*  613 */     SubjectContext sc = threadSubjectStacks.pop();
/*  614 */     if (trace)
/*      */     {
/*  616 */       log.trace("popSubjectContext, sc=" + sc);
/*      */     }
/*      */ 
/*  619 */     Principal principal = null;
/*  620 */     Object credential = null;
/*      */ 
/*  622 */     SubjectContext top = threadSubjectStacks.peek();
/*      */ 
/*  624 */     if (top != null)
/*      */     {
/*  626 */       principal = top.getPrincipal();
/*  627 */       credential = top.getCredential();
/*      */     }
/*      */ 
/*  630 */     if (server)
/*      */     {
/*  632 */       threadPrincipal.set(principal);
/*  633 */       threadCredential.set(credential);
/*      */     }
/*      */     else
/*      */     {
/*  637 */       principal = principal;
/*  638 */       credential = credential;
/*      */     }
/*      */ 
/*  641 */     if (trace)
/*  642 */       log.trace("WARN::Deprecated usage of SecurityAssociation. Use SecurityContext");
/*  643 */     SecurityContext sctx = SecurityContextAssociation.getSecurityContext();
/*      */ 
/*  645 */     if (sc == null)
/*      */     {
/*  647 */       if (sctx != null)
/*      */       {
/*  649 */         SubjectInfo si = sctx.getSubjectInfo();
/*  650 */         sc = new SubjectContext(si.getAuthenticatedSubject(), si.getAuthenticationPrincipal(), si.getAuthenticationCredential());
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  655 */     if (sctx != null)
/*      */     {
/*  657 */       sctx.getSubjectInfo().setAuthenticatedSubject(null);
/*  658 */       sctx.getSubjectInfo().setAuthenticationPrincipal(null);
/*  659 */       sctx.getSubjectInfo().setAuthenticationCredential(null);
/*      */     }
/*  661 */     return sc;
/*      */   }
/*      */ 
/*      */   public static SubjectContext peekSubjectContext()
/*      */   {
/*  674 */     SecurityManager sm = System.getSecurityManager();
/*  675 */     if (sm != null) {
/*  676 */       sm.checkPermission(getPrincipalInfoPermission);
/*      */     }
/*      */ 
/*  679 */     SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  680 */     SubjectContext subjectCtx = null;
/*  681 */     if (sc != null)
/*      */     {
/*  683 */       SecurityContextUtil util = sc.getUtil();
/*  684 */       subjectCtx = new SubjectContext(util.getSubject(), util.getUserPrincipal(), util.getCredential());
/*      */     }
/*  686 */     return subjectCtx;
/*      */   }
/*      */ 
/*      */   public static void clear()
/*      */   {
/*  699 */     SecurityManager sm = System.getSecurityManager();
/*  700 */     if (sm != null) {
/*  701 */       sm.checkPermission(setPrincipalInfoPermission);
/*      */     }
/*  703 */     if (trace)
/*  704 */       log.trace("clear, server=" + server);
/*  705 */     if (server == true)
/*      */     {
/*  707 */       threadPrincipal.set(null);
/*  708 */       threadCredential.set(null);
/*      */     }
/*      */     else
/*      */     {
/*  712 */       principal = null;
/*  713 */       credential = null;
/*      */     }
/*      */ 
/*  716 */     threadSubjectStacks.clear();
/*      */ 
/*  719 */     SecurityContextAssociation.clearSecurityContext();
/*      */   }
/*      */ 
/*      */   public static void pushRunAsIdentity(RunAsIdentity runAs)
/*      */   {
/*  727 */     SecurityManager sm = System.getSecurityManager();
/*  728 */     if (sm != null)
/*  729 */       sm.checkPermission(setRunAsIdentity);
/*  730 */     if (trace) {
/*  731 */       log.trace("pushRunAsIdentity, runAs=" + runAs);
/*      */     }
/*  733 */     threadRunAsStacks.push(runAs);
/*  734 */     SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  735 */     if (sc != null)
/*      */     {
/*  737 */       sc.setOutgoingRunAs(runAs);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static RunAsIdentity popRunAsIdentity()
/*      */   {
/*  746 */     SecurityManager sm = System.getSecurityManager();
/*  747 */     if (sm != null) {
/*  748 */       sm.checkPermission(setRunAsIdentity);
/*      */     }
/*      */ 
/*  753 */     SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  754 */     RunAsIdentity ra = null;
/*  755 */     if (sc != null)
/*      */     {
/*  757 */       ra = (RunAsIdentity)sc.getOutgoingRunAs();
/*  758 */       sc.setOutgoingRunAs(null);
/*      */     }
/*  760 */     return ra;
/*      */   }
/*      */ 
/*      */   public static RunAsIdentity peekRunAsIdentity()
/*      */   {
/*  770 */     RunAsIdentity ra = null;
/*  771 */     SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  772 */     if (sc != null)
/*      */     {
/*  774 */       ra = (RunAsIdentity)sc.getOutgoingRunAs();
/*      */     }
/*  776 */     return ra;
/*      */   }
/*      */ 
/*      */   public static RunAsIdentity peekRunAsIdentity(int depth)
/*      */   {
/*  790 */     if (depth > 1)
/*  791 */       throw new IllegalArgumentException("Security Context approach needs to be used. Depth upto 1");
/*  792 */     if (depth == 0) {
/*  793 */       return peekRunAsIdentity();
/*      */     }
/*      */ 
/*  796 */     SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  797 */     RunAsIdentity ra = null;
/*  798 */     if (sc != null)
/*      */     {
/*  800 */       RunAs ras = sc.getIncomingRunAs();
/*  801 */       if ((ras instanceof RunAsIdentity))
/*  802 */         ra = (RunAsIdentity)ras;
/*      */     }
/*  804 */     return ra;
/*      */   }
/*      */ 
/*      */   public static boolean isServer()
/*      */   {
/*  814 */     return server;
/*      */   }
/*      */ 
/*      */   public static void setServer()
/*      */   {
/*  832 */     SecurityManager sm = System.getSecurityManager();
/*  833 */     if (sm != null) {
/*  834 */       sm.checkPermission(setServerPermission);
/*      */     }
/*  836 */     server = true;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  145 */     String flag = SecurityActions.getProperty("org.jboss.security.SecurityAssociation.ThreadLocal", "false");
/*  146 */     boolean useThreadLocal = Boolean.valueOf(flag).booleanValue();
/*  147 */     log.debug("Using ThreadLocal: " + useThreadLocal);
/*      */ 
/*  149 */     trace = log.isTraceEnabled();
/*  150 */     if (useThreadLocal)
/*      */     {
/*  152 */       threadPrincipal = new ThreadLocal();
/*  153 */       threadCredential = new ThreadLocal();
/*  154 */       threadContextMap = new ThreadLocal()
/*      */       {
/*      */         protected Object initialValue()
/*      */         {
/*  158 */           return new HashMap();
/*      */         }
/*      */       };
/*      */     }
/*      */     else {
/*  164 */       threadPrincipal = new InheritableThreadLocal();
/*  165 */       threadCredential = new InheritableThreadLocal();
/*  166 */       threadContextMap = new HashMapInheritableLocal(null);
/*      */     }
/*  168 */     threadRunAsStacks = new RunAsThreadLocalStack(useThreadLocal);
/*  169 */     threadSubjectStacks = new SubjectThreadLocalStack(useThreadLocal);
/*      */   }
/*      */ 
/*      */   private static class HashMapInheritableLocal extends InheritableThreadLocal
/*      */   {
/*      */     protected Object childValue(Object parentValue)
/*      */     {
/* 1099 */       HashMap map = (HashMap)parentValue;
/*      */ 
/* 1103 */       HashMap copy = null;
/*      */       try
/*      */       {
/* 1106 */         copy = new HashMap(map);
/*      */       }
/*      */       catch (Throwable t)
/*      */       {
/* 1110 */         SecurityAssociation.log.debug("Failed to copy parent map, using new map");
/* 1111 */         copy = new HashMap();
/*      */       }
/* 1113 */       return copy;
/*      */     }
/*      */ 
/*      */     protected Object initialValue()
/*      */     {
/* 1118 */       return new HashMap();
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class ArrayListInheritableLocal extends InheritableThreadLocal
/*      */   {
/*      */     protected Object childValue(Object parentValue)
/*      */     {
/* 1066 */       ArrayList list = (ArrayList)parentValue;
/*      */ 
/* 1070 */       ArrayList copy = null;
/*      */       try
/*      */       {
/* 1073 */         copy = new ArrayList(list);
/*      */       }
/*      */       catch (Throwable t)
/*      */       {
/* 1077 */         SecurityAssociation.log.debug("Failed to copy parent list, using new list");
/* 1078 */         copy = new ArrayList();
/*      */       }
/* 1080 */       return copy;
/*      */     }
/*      */ 
/*      */     protected Object initialValue()
/*      */     {
/* 1085 */       return new ArrayList();
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class ArrayListLocal extends ThreadLocal
/*      */   {
/*      */     protected Object initialValue()
/*      */     {
/* 1051 */       return new ArrayList();
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class SubjectThreadLocalStack
/*      */   {
/*      */     ThreadLocal local;
/*      */ 
/*      */     SubjectThreadLocalStack(boolean threadLocal)
/*      */     {
/*  982 */       if (threadLocal == true)
/*  983 */         this.local = new SecurityAssociation.ArrayListLocal(null);
/*      */       else
/*  985 */         this.local = new SecurityAssociation.ArrayListInheritableLocal(null);
/*      */     }
/*      */ 
/*      */     int size()
/*      */     {
/*  990 */       ArrayList stack = (ArrayList)this.local.get();
/*  991 */       return stack.size();
/*      */     }
/*      */ 
/*      */     void push(SecurityAssociation.SubjectContext context)
/*      */     {
/*  996 */       ArrayList stack = (ArrayList)this.local.get();
/*  997 */       stack.add(context);
/*      */     }
/*      */ 
/*      */     SecurityAssociation.SubjectContext dup()
/*      */     {
/* 1002 */       ArrayList stack = (ArrayList)this.local.get();
/* 1003 */       SecurityAssociation.SubjectContext context = null;
/* 1004 */       int lastIndex = stack.size() - 1;
/* 1005 */       if (lastIndex >= 0)
/*      */       {
/* 1007 */         context = (SecurityAssociation.SubjectContext)stack.get(lastIndex);
/* 1008 */         stack.add(context);
/*      */       }
/* 1010 */       return context;
/*      */     }
/*      */ 
/*      */     SecurityAssociation.SubjectContext pop()
/*      */     {
/* 1015 */       ArrayList stack = (ArrayList)this.local.get();
/* 1016 */       SecurityAssociation.SubjectContext context = null;
/* 1017 */       int lastIndex = stack.size() - 1;
/* 1018 */       if (lastIndex >= 0)
/* 1019 */         context = (SecurityAssociation.SubjectContext)stack.remove(lastIndex);
/* 1020 */       return context;
/*      */     }
/*      */ 
/*      */     SecurityAssociation.SubjectContext peek()
/*      */     {
/* 1030 */       ArrayList stack = (ArrayList)this.local.get();
/* 1031 */       SecurityAssociation.SubjectContext context = null;
/* 1032 */       int lastIndex = stack.size() - 1;
/* 1033 */       if (lastIndex >= 0)
/* 1034 */         context = (SecurityAssociation.SubjectContext)stack.get(lastIndex);
/* 1035 */       return context;
/*      */     }
/*      */ 
/*      */     void clear()
/*      */     {
/* 1042 */       ArrayList stack = (ArrayList)this.local.get();
/* 1043 */       stack.clear();
/*      */     }
/*      */   }
/*      */ 
/*      */   public static class SubjectContext
/*      */   {
/*      */     public static final int SUBJECT_WAS_SET = 1;
/*      */     public static final int PRINCIPAL_WAS_SET = 2;
/*      */     public static final int CREDENTIAL_WAS_SET = 4;
/*      */     private Subject subject;
/*      */     private Principal principal;
/*      */     private Object credential;
/*      */     private int flags;
/*      */ 
/*      */     public SubjectContext()
/*      */     {
/*  916 */       this.flags = 0;
/*      */     }
/*      */ 
/*      */     public SubjectContext(Subject s, Principal p, Object cred) {
/*  920 */       this.subject = s;
/*  921 */       this.principal = p;
/*  922 */       this.credential = cred;
/*  923 */       this.flags = 7;
/*      */     }
/*      */ 
/*      */     public Subject getSubject()
/*      */     {
/*  928 */       return this.subject;
/*      */     }
/*      */ 
/*      */     public void setSubject(Subject subject) {
/*  932 */       this.subject = subject;
/*  933 */       this.flags |= 1;
/*      */     }
/*      */ 
/*      */     public Principal getPrincipal()
/*      */     {
/*  938 */       return this.principal;
/*      */     }
/*      */ 
/*      */     public void setPrincipal(Principal principal) {
/*  942 */       this.principal = principal;
/*  943 */       this.flags |= 2;
/*      */     }
/*      */ 
/*      */     public Object getCredential()
/*      */     {
/*  948 */       return this.credential;
/*      */     }
/*      */ 
/*      */     public void setCredential(Object credential) {
/*  952 */       this.credential = credential;
/*  953 */       this.flags |= 4;
/*      */     }
/*      */ 
/*      */     public int getFlags()
/*      */     {
/*  958 */       return this.flags;
/*      */     }
/*      */ 
/*      */     public String toString()
/*      */     {
/*  963 */       StringBuffer tmp = new StringBuffer(super.toString());
/*  964 */       tmp.append("{principal=");
/*  965 */       tmp.append(this.principal);
/*  966 */       tmp.append(",subject=");
/*  967 */       if (this.subject != null)
/*  968 */         tmp.append(System.identityHashCode(this.subject));
/*      */       else
/*  970 */         tmp.append("null");
/*  971 */       tmp.append("}");
/*  972 */       return tmp.toString();
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class RunAsThreadLocalStack
/*      */   {
/*      */     ThreadLocal local;
/*      */ 
/*      */     RunAsThreadLocalStack(boolean threadLocal)
/*      */     {
/*  850 */       if (threadLocal == true)
/*  851 */         this.local = new SecurityAssociation.ArrayListLocal(null);
/*      */       else
/*  853 */         this.local = new SecurityAssociation.ArrayListInheritableLocal(null);
/*      */     }
/*      */ 
/*      */     int size()
/*      */     {
/*  858 */       ArrayList stack = (ArrayList)this.local.get();
/*  859 */       return stack.size();
/*      */     }
/*      */ 
/*      */     void push(RunAsIdentity runAs)
/*      */     {
/*  864 */       ArrayList stack = (ArrayList)this.local.get();
/*  865 */       stack.add(runAs);
/*      */     }
/*      */ 
/*      */     RunAsIdentity pop()
/*      */     {
/*  870 */       ArrayList stack = (ArrayList)this.local.get();
/*  871 */       RunAsIdentity runAs = null;
/*  872 */       int lastIndex = stack.size() - 1;
/*  873 */       if (lastIndex >= 0)
/*  874 */         runAs = (RunAsIdentity)stack.remove(lastIndex);
/*  875 */       return runAs;
/*      */     }
/*      */ 
/*      */     RunAsIdentity peek(int depth)
/*      */     {
/*  885 */       ArrayList stack = (ArrayList)this.local.get();
/*  886 */       RunAsIdentity runAs = null;
/*  887 */       int stackSize = stack.size();
/*      */       do
/*      */       {
/*  890 */         int index = stackSize - 1 - depth;
/*  891 */         if (index >= 0)
/*  892 */           runAs = (RunAsIdentity)stack.get(index);
/*  893 */         depth++;
/*      */       }
/*  895 */       while ((runAs == null) && (depth <= stackSize - 1));
/*  896 */       return runAs;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.SecurityAssociation
 * JD-Core Version:    0.6.0
 */