/*    */ package org.jboss.security;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ 
/*    */ class SecurityActions
/*    */ {
/*    */   static String getProperty(String name, String defaultValue)
/*    */   {
/* 69 */     SecurityManager sm = System.getSecurityManager();
/*    */     String prop;
/*    */     String prop;
/* 71 */     if (sm != null)
/*    */     {
/* 73 */       prop = SystemPropertyAction.PRIVILEGED.getProperty(name, defaultValue);
/*    */     }
/*    */     else
/*    */     {
/* 77 */       prop = SystemPropertyAction.NON_PRIVILEGED.getProperty(name, defaultValue);
/*    */     }
/* 79 */     return prop;
/*    */   }
/*    */ 
/*    */   static abstract interface SystemPropertyAction
/*    */   {
/* 37 */     public static final SystemPropertyAction PRIVILEGED = new SystemPropertyAction()
/*    */     {
/*    */       public String getProperty(String name, String defaultValue)
/*    */       {
/* 41 */         String prop = (String)AccessController.doPrivileged(new PrivilegedAction(name, defaultValue)
/*    */         {
/*    */           public Object run()
/*    */           {
/* 46 */             String p = System.getProperty(this.val$name, this.val$defaultValue);
/* 47 */             return p;
/*    */           }
/*    */         });
/* 51 */         return prop;
/*    */       }
/* 37 */     };
/*    */ 
/* 55 */     public static final SystemPropertyAction NON_PRIVILEGED = new SystemPropertyAction()
/*    */     {
/*    */       public String getProperty(String name, String defaultValue)
/*    */       {
/* 59 */         String prop = System.getProperty(name, defaultValue);
/* 60 */         return prop;
/*    */       }
/* 55 */     };
/*    */ 
/*    */     public abstract String getProperty(String paramString1, String paramString2);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.SecurityActions
 * JD-Core Version:    0.6.0
 */