/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.security.Principal;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.Callback;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.callback.NameCallback;
/*     */ import javax.security.auth.callback.PasswordCallback;
/*     */ import javax.security.auth.callback.UnsupportedCallbackException;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import javax.security.auth.spi.LoginModule;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClientLoginModule
/*     */   implements LoginModule
/*     */ {
/*  72 */   private static Logger log = Logger.getLogger(ClientLoginModule.class);
/*     */   private Subject subject;
/*     */   private CallbackHandler callbackHandler;
/*     */   private Principal loginPrincipal;
/*     */   private Object loginCredential;
/*     */   private Map sharedState;
/*     */   private boolean useFirstPass;
/*     */   private boolean restoreLoginIdentity;
/*     */   private boolean trace;
/*     */   private SecurityContext cachedSecurityContext;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
/*     */   {
/* 100 */     this.trace = log.isTraceEnabled();
/* 101 */     this.subject = subject;
/* 102 */     this.callbackHandler = callbackHandler;
/* 103 */     this.sharedState = sharedState;
/*     */ 
/* 106 */     if (this.trace) {
/* 107 */       log.trace("Security domain: " + (String)options.get("jboss.security.security_domain"));
/*     */     }
/*     */ 
/* 111 */     String flag = (String)options.get("multi-threaded");
/* 112 */     if (Boolean.valueOf(flag).booleanValue() == true)
/*     */     {
/* 117 */       if (this.trace)
/* 118 */         log.trace("Enabling multi-threaded mode");
/* 119 */       SecurityAssociationActions.setServer();
/*     */     }
/*     */ 
/* 122 */     flag = (String)options.get("restore-login-identity");
/* 123 */     this.restoreLoginIdentity = Boolean.valueOf(flag).booleanValue();
/* 124 */     if (this.trace) {
/* 125 */       log.trace("Enabling restore-login-identity mode");
/*     */     }
/*     */ 
/* 131 */     String passwordStacking = (String)options.get("password-stacking");
/* 132 */     this.useFirstPass = (passwordStacking != null);
/* 133 */     if ((this.trace) && (this.useFirstPass))
/* 134 */       log.trace("Enabling useFirstPass mode");
/*     */   }
/*     */ 
/*     */   public boolean login()
/*     */     throws LoginException
/*     */   {
/* 142 */     if (this.trace) {
/* 143 */       log.trace("Begin login");
/*     */     }
/* 145 */     if (this.useFirstPass == true)
/*     */     {
/*     */       try
/*     */       {
/* 149 */         Object name = this.sharedState.get("javax.security.auth.login.name");
/* 150 */         if (!(name instanceof Principal))
/*     */         {
/* 152 */           String username = name != null ? name.toString() : "";
/* 153 */           this.loginPrincipal = new SimplePrincipal(username);
/*     */         }
/*     */         else {
/* 156 */           this.loginPrincipal = ((Principal)name);
/*     */         }
/* 158 */         this.loginCredential = this.sharedState.get("javax.security.auth.login.password");
/* 159 */         return true;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 163 */         log.debug("Failed to obtain shared state", e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 170 */     if (this.callbackHandler == null) {
/* 171 */       throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
/*     */     }
/*     */ 
/* 174 */     PasswordCallback pc = new PasswordCallback("Password: ", false);
/* 175 */     NameCallback nc = new NameCallback("User name: ", "guest");
/* 176 */     Callback[] callbacks = { nc, pc };
/*     */     try
/*     */     {
/* 180 */       char[] password = null;
/*     */ 
/* 183 */       this.callbackHandler.handle(callbacks);
/* 184 */       String username = nc.getName();
/* 185 */       this.loginPrincipal = new SimplePrincipal(username);
/* 186 */       char[] tmpPassword = pc.getPassword();
/* 187 */       if (tmpPassword != null)
/*     */       {
/* 189 */         password = new char[tmpPassword.length];
/* 190 */         System.arraycopy(tmpPassword, 0, password, 0, tmpPassword.length);
/* 191 */         pc.clearPassword();
/*     */       }
/* 193 */       this.loginCredential = password;
/* 194 */       if (this.trace)
/*     */       {
/* 196 */         String credType = "null";
/* 197 */         if (this.loginCredential != null)
/* 198 */           credType = this.loginCredential.getClass().getName();
/* 199 */         log.trace("Obtained login: " + this.loginPrincipal + ", credential.class: " + credType);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IOException ioe)
/*     */     {
/* 205 */       LoginException ex = new LoginException(ioe.toString());
/* 206 */       ex.initCause(ioe);
/* 207 */       throw ex;
/*     */     }
/*     */     catch (UnsupportedCallbackException uce)
/*     */     {
/* 211 */       LoginException ex = new LoginException("Error: " + uce.getCallback().toString() + ", not able to use this callback for username/password");
/*     */ 
/* 213 */       ex.initCause(uce);
/* 214 */       throw ex;
/*     */     }
/* 216 */     if (this.trace)
/* 217 */       log.trace("End login");
/* 218 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean commit()
/*     */     throws LoginException
/*     */   {
/* 226 */     if (this.trace) {
/* 227 */       log.trace("commit, subject=" + this.subject);
/*     */     }
/* 229 */     this.cachedSecurityContext = SecurityAssociationActions.getSecurityContext();
/*     */ 
/* 231 */     SecurityAssociationActions.pushSecurityContext(this.loginPrincipal, this.loginCredential, this.subject, "CLIENT_LOGIN_MODULE");
/*     */ 
/* 237 */     Set principals = this.subject.getPrincipals();
/* 238 */     if (!principals.contains(this.loginPrincipal))
/* 239 */       principals.add(this.loginPrincipal);
/* 240 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean abort()
/*     */     throws LoginException
/*     */   {
/* 248 */     if (this.trace)
/* 249 */       log.trace("abort");
/* 250 */     if (this.restoreLoginIdentity == true)
/*     */     {
/* 253 */       SecurityAssociationActions.setSecurityContext(this.cachedSecurityContext);
/*     */     }
/*     */     else
/*     */     {
/* 259 */       SecurityAssociationActions.setSecurityContext(null);
/*     */     }
/*     */ 
/* 262 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean logout() throws LoginException
/*     */   {
/* 267 */     if (this.trace)
/* 268 */       log.trace("logout");
/* 269 */     if (this.restoreLoginIdentity == true)
/*     */     {
/* 272 */       SecurityAssociationActions.setSecurityContext(this.cachedSecurityContext);
/*     */     }
/*     */     else
/*     */     {
/* 278 */       SecurityAssociationActions.setSecurityContext(null);
/*     */     }
/* 280 */     Set principals = this.subject.getPrincipals();
/* 281 */     principals.remove(this.loginPrincipal);
/* 282 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.ClientLoginModule
 * JD-Core Version:    0.6.0
 */