/*     */ package org.jboss.security;
/*     */ 
/*     */ public class Base64Utils
/*     */ {
/*  31 */   private static final char[] base64Table = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz./".toCharArray();
/*     */   public static final String BASE64_ENCODING = "BASE64";
/*     */   public static final String BASE16_ENCODING = "HEX";
/*     */ 
/*     */   public static String tob64(byte[] buffer)
/*     */   {
/*  41 */     boolean notleading = false;
/*  42 */     int len = buffer.length; int pos = len % 3;
/*  43 */     byte b0 = 0; byte b1 = 0; byte b2 = 0;
/*  44 */     StringBuffer sb = new StringBuffer();
/*     */ 
/*  46 */     switch (pos)
/*     */     {
/*     */     case 1:
/*  49 */       b2 = buffer[0];
/*  50 */       break;
/*     */     case 2:
/*  52 */       b1 = buffer[0];
/*  53 */       b2 = buffer[1];
/*     */     }
/*     */ 
/*     */     while (true)
/*     */     {
/*  58 */       int c = (b0 & 0xFC) >>> 2;
/*  59 */       if ((notleading) || (c != 0))
/*     */       {
/*  61 */         sb.append(base64Table[c]);
/*  62 */         notleading = true;
/*     */       }
/*  64 */       c = (b0 & 0x3) << 4 | (b1 & 0xF0) >>> 4;
/*  65 */       if ((notleading) || (c != 0))
/*     */       {
/*  67 */         sb.append(base64Table[c]);
/*  68 */         notleading = true;
/*     */       }
/*  70 */       c = (b1 & 0xF) << 2 | (b2 & 0xC0) >>> 6;
/*  71 */       if ((notleading) || (c != 0))
/*     */       {
/*  73 */         sb.append(base64Table[c]);
/*  74 */         notleading = true;
/*     */       }
/*  76 */       c = b2 & 0x3F;
/*  77 */       if ((notleading) || (c != 0))
/*     */       {
/*  79 */         sb.append(base64Table[c]);
/*  80 */         notleading = true;
/*     */       }
/*  82 */       if (pos < len)
/*     */       {
/*     */         try
/*     */         {
/*  88 */           b0 = buffer[(pos++)];
/*  89 */           b1 = buffer[(pos++)];
/*  90 */           b2 = buffer[(pos++)];
/*     */         }
/*     */         catch (ArrayIndexOutOfBoundsException e)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  99 */     if (notleading) {
/* 100 */       return sb.toString();
/*     */     }
/* 102 */     return "0";
/*     */   }
/*     */ 
/*     */   public static byte[] fromb64(String str) throws NumberFormatException
/*     */   {
/* 107 */     int len = str.length();
/* 108 */     if (len == 0) {
/* 109 */       throw new NumberFormatException("Empty Base64 string");
/*     */     }
/* 111 */     byte[] a = new byte[len + 1];
/*     */ 
/* 115 */     for (int i = 0; i < len; i++) {
/* 117 */       char c = str.charAt(i);
/*     */       int j;
/*     */       try { for (j = 0; c != base64Table[j]; j++);
/*     */       } catch (Exception e)
/*     */       {
/* 124 */         throw new NumberFormatException("Illegal Base64 character");
/*     */       }
/* 126 */       a[i] = (byte)j;
/*     */     }
/*     */ 
/* 129 */     i = len - 1;
/* 130 */     int j = len;
/*     */     try
/*     */     {
/*     */       while (true)
/*     */       {
/* 135 */         a[j] = a[i];
/* 136 */         i--; if (i < 0)
/*     */           break;
/*     */         int tmp118_116 = j;
/*     */         byte[] tmp118_115 = a; tmp118_115[tmp118_116] = (byte)(tmp118_115[tmp118_116] | (a[i] & 0x3) << 6);
/* 139 */         j--;
/* 140 */         a[j] = (byte)((a[i] & 0x3C) >>> 2);
/* 141 */         i--; if (i < 0)
/*     */           break;
/*     */         int tmp163_161 = j;
/*     */         byte[] tmp163_160 = a; tmp163_160[tmp163_161] = (byte)(tmp163_160[tmp163_161] | (a[i] & 0xF) << 4);
/* 144 */         j--;
/* 145 */         a[j] = (byte)((a[i] & 0x30) >>> 4);
/* 146 */         i--; if (i < 0)
/*     */           break;
/*     */         int tmp208_206 = j;
/*     */         byte[] tmp208_205 = a; tmp208_205[tmp208_206] = (byte)(tmp208_205[tmp208_206] | a[i] << 2);
/*     */ 
/* 156 */         a[(j - 1)] = 0; j--;
/*     */ 
/* 160 */         i--; if (i < 0) {
/* 161 */           break;
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 171 */       while (a[j] == 0)
/* 172 */         j++;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 176 */       return new byte[1];
/*     */     }
/*     */ 
/* 179 */     byte[] result = new byte[len - j + 1];
/* 180 */     System.arraycopy(a, j, result, 0, len - j + 1);
/* 181 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.Base64Utils
 * JD-Core Version:    0.6.0
 */