/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.security.MessageDigest;
/*     */ 
/*     */ public final class Base64Encoder
/*     */ {
/*     */   private static final int BUFFER_SIZE = 1024;
/*  50 */   private static final byte[] encoding = { 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47, 61 };
/*     */ 
/*     */   public static void encode(InputStream in, OutputStream out)
/*     */     throws IOException
/*     */   {
/*  79 */     process(in, out);
/*     */   }
/*     */ 
/*     */   public static void encode(byte[] input, OutputStream out)
/*     */     throws IOException
/*     */   {
/*  88 */     ByteArrayInputStream in = new ByteArrayInputStream(input);
/*  89 */     process(in, out);
/*     */   }
/*     */ 
/*     */   public static String encode(String input)
/*     */     throws IOException
/*     */   {
/* 100 */     byte[] bytes = input.getBytes("ISO-8859-1");
/* 101 */     return encode(bytes);
/*     */   }
/*     */ 
/*     */   public static String encode(byte[] bytes)
/*     */     throws IOException
/*     */   {
/* 109 */     ByteArrayInputStream in = new ByteArrayInputStream(bytes);
/* 110 */     ByteArrayOutputStream out = new ByteArrayOutputStream();
/* 111 */     process(in, out);
/* 112 */     return out.toString("ISO-8859-1");
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/* 128 */     if (args.length == 1)
/*     */     {
/* 130 */       System.out.println("[" + encode(args[0]) + "]");
/*     */     }
/* 134 */     else if (args.length == 2)
/*     */     {
/* 136 */       byte[] hash = MessageDigest.getInstance(args[1]).digest(args[0].getBytes());
/* 137 */       System.out.println("[" + encode(hash) + "]");
/*     */     }
/*     */     else
/*     */     {
/* 141 */       System.out.println("Usage: Base64Encoder <string> <optional hash algorithm>");
/*     */     }
/*     */   }
/*     */ 
/*     */   private static int get1(byte[] buf, int off)
/*     */   {
/* 149 */     return (buf[off] & 0xFC) >> 2;
/*     */   }
/*     */ 
/*     */   private static int get2(byte[] buf, int off)
/*     */   {
/* 154 */     return (buf[off] & 0x3) << 4 | (buf[(off + 1)] & 0xF0) >>> 4;
/*     */   }
/*     */ 
/*     */   private static int get3(byte[] buf, int off)
/*     */   {
/* 159 */     return (buf[(off + 1)] & 0xF) << 2 | (buf[(off + 2)] & 0xC0) >>> 6;
/*     */   }
/*     */ 
/*     */   private static int get4(byte[] buf, int off)
/*     */   {
/* 164 */     return buf[(off + 2)] & 0x3F;
/*     */   }
/*     */ 
/*     */   private static void process(InputStream in, OutputStream out)
/*     */     throws IOException
/*     */   {
/* 176 */     byte[] buffer = new byte[1024];
/* 177 */     int got = -1;
/* 178 */     int off = 0;
/* 179 */     int count = 0;
/* 180 */     while ((got = in.read(buffer, off, 1024 - off)) > 0)
/*     */     {
/* 182 */       if (got >= 3)
/*     */       {
/* 184 */         got += off;
/* 185 */         off = 0;
/* 186 */         while (off + 3 <= got)
/*     */         {
/* 188 */           int c1 = get1(buffer, off);
/* 189 */           int c2 = get2(buffer, off);
/* 190 */           int c3 = get3(buffer, off);
/* 191 */           int c4 = get4(buffer, off);
/* 192 */           switch (count)
/*     */           {
/*     */           case 73:
/* 195 */             out.write(encoding[c1]);
/* 196 */             out.write(encoding[c2]);
/* 197 */             out.write(encoding[c3]);
/* 198 */             out.write(10);
/* 199 */             out.write(encoding[c4]);
/* 200 */             count = 1;
/* 201 */             break;
/*     */           case 74:
/* 203 */             out.write(encoding[c1]);
/* 204 */             out.write(encoding[c2]);
/* 205 */             out.write(10);
/* 206 */             out.write(encoding[c3]);
/* 207 */             out.write(encoding[c4]);
/* 208 */             count = 2;
/* 209 */             break;
/*     */           case 75:
/* 211 */             out.write(encoding[c1]);
/* 212 */             out.write(10);
/* 213 */             out.write(encoding[c2]);
/* 214 */             out.write(encoding[c3]);
/* 215 */             out.write(encoding[c4]);
/* 216 */             count = 3;
/* 217 */             break;
/*     */           case 76:
/* 219 */             out.write(10);
/* 220 */             out.write(encoding[c1]);
/* 221 */             out.write(encoding[c2]);
/* 222 */             out.write(encoding[c3]);
/* 223 */             out.write(encoding[c4]);
/* 224 */             count = 4;
/* 225 */             break;
/*     */           default:
/* 227 */             out.write(encoding[c1]);
/* 228 */             out.write(encoding[c2]);
/* 229 */             out.write(encoding[c3]);
/* 230 */             out.write(encoding[c4]);
/* 231 */             count += 4;
/*     */           }
/*     */ 
/* 234 */           off += 3;
/*     */         }
/*     */ 
/* 237 */         for (int i = 0; i < 3; i++)
/* 238 */           buffer[i] = (i < got - off ? buffer[(off + i)] : 0);
/* 239 */         off = got - off; continue;
/*     */       }
/*     */ 
/* 244 */       off += got;
/*     */     }
/*     */ 
/* 248 */     switch (off) {
/*     */     case 1:
/* 250 */       out.write(encoding[get1(buffer, 0)]);
/* 251 */       out.write(encoding[get2(buffer, 0)]);
/* 252 */       out.write(61);
/* 253 */       out.write(61);
/* 254 */       break;
/*     */     case 2:
/* 256 */       out.write(encoding[get1(buffer, 0)]);
/* 257 */       out.write(encoding[get2(buffer, 0)]);
/* 258 */       out.write(encoding[get3(buffer, 0)]);
/* 259 */       out.write(61);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.Base64Encoder
 * JD-Core Version:    0.6.0
 */