/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.security.Principal;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.Callback;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.callback.NameCallback;
/*     */ import javax.security.auth.callback.PasswordCallback;
/*     */ import javax.security.auth.callback.UnsupportedCallbackException;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import javax.security.auth.spi.LoginModule;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class AltClientLoginModule
/*     */   implements LoginModule
/*     */ {
/*  67 */   private static Logger log = Logger.getLogger(AltClientLoginModule.class);
/*     */   private Subject subject;
/*     */   private CallbackHandler callbackHandler;
/*     */   private Map sharedState;
/*     */   private boolean useFirstPass;
/*     */   private String username;
/*  75 */   private char[] password = null;
/*     */   private boolean trace;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
/*     */   {
/*  84 */     this.trace = log.isTraceEnabled();
/*  85 */     this.subject = subject;
/*  86 */     this.callbackHandler = callbackHandler;
/*  87 */     this.sharedState = sharedState;
/*     */ 
/*  90 */     if (this.trace) {
/*  91 */       log.trace("Security domain: " + (String)options.get("jboss.security.security_domain"));
/*     */     }
/*     */ 
/*  95 */     String mt = (String)options.get("multi-threaded");
/*  96 */     if (Boolean.valueOf(mt).booleanValue() == true)
/*     */     {
/* 101 */       if (this.trace)
/* 102 */         log.trace("Enabling multi-threaded mode");
/* 103 */       SecurityAssociationActions.setServer();
/*     */     }
/*     */ 
/* 110 */     String passwordStacking = (String)options.get("password-stacking");
/* 111 */     this.useFirstPass = (passwordStacking != null);
/* 112 */     if ((this.trace) && (this.useFirstPass))
/* 113 */       log.trace("Enabling useFirstPass mode");
/*     */   }
/*     */ 
/*     */   public boolean login()
/*     */     throws LoginException
/*     */   {
/* 122 */     if (this.useFirstPass == true)
/*     */     {
/* 124 */       return true;
/*     */     }
/*     */ 
/* 130 */     if (this.callbackHandler == null) {
/* 131 */       throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
/*     */     }
/*     */ 
/* 134 */     PasswordCallback pc = new PasswordCallback("Password: ", false);
/* 135 */     NameCallback nc = new NameCallback("User name: ", "guest");
/* 136 */     Callback[] callbacks = { nc, pc };
/*     */     try
/*     */     {
/* 141 */       this.callbackHandler.handle(callbacks);
/* 142 */       this.username = nc.getName();
/* 143 */       char[] tmpPassword = pc.getPassword();
/* 144 */       if (tmpPassword != null)
/*     */       {
/* 146 */         this.password = new char[tmpPassword.length];
/* 147 */         System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
/* 148 */         pc.clearPassword();
/*     */       }
/*     */     }
/*     */     catch (IOException ioe)
/*     */     {
/* 153 */       throw new LoginException(ioe.toString());
/*     */     }
/*     */     catch (UnsupportedCallbackException uce)
/*     */     {
/* 157 */       throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
/*     */     }
/*     */ 
/* 161 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean commit()
/*     */     throws LoginException
/*     */   {
/* 176 */     Set principals = this.subject.getPrincipals();
/* 177 */     Principal p = null;
/* 178 */     Object credential = this.password;
/* 179 */     if (this.useFirstPass == true)
/*     */     {
/* 181 */       Object user = this.sharedState.get("javax.security.auth.login.name");
/* 182 */       if (!(user instanceof Principal))
/*     */       {
/* 184 */         this.username = (user != null ? user.toString() : "");
/* 185 */         p = new SimplePrincipal(this.username);
/*     */       }
/*     */       else
/*     */       {
/* 189 */         p = (Principal)user;
/*     */       }
/* 191 */       credential = this.sharedState.get("javax.security.auth.login.password");
/*     */     }
/*     */     else
/*     */     {
/* 195 */       p = new SimplePrincipal(this.username);
/*     */     }
/*     */ 
/* 198 */     if (!principals.isEmpty())
/* 199 */       p = (Principal)principals.iterator().next();
/* 200 */     SecurityAssociationActions.setPrincipalInfo(p, credential, this.subject);
/* 201 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean abort()
/*     */     throws LoginException
/*     */   {
/* 209 */     int length = this.password != null ? this.password.length : 0;
/* 210 */     for (int n = 0; n < length; n++)
/* 211 */       this.password[n] = '\000';
/* 212 */     SecurityAssociationActions.clear();
/* 213 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean logout() throws LoginException
/*     */   {
/* 218 */     SecurityAssociationActions.clear();
/* 219 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.AltClientLoginModule
 * JD-Core Version:    0.6.0
 */