/*     */ package org.jboss.resource.work;
/*     */ 
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.resource.spi.work.ExecutionContext;
/*     */ import javax.resource.spi.work.Work;
/*     */ import javax.resource.spi.work.WorkException;
/*     */ import javax.resource.spi.work.WorkListener;
/*     */ import javax.resource.spi.work.WorkManager;
/*     */ import javax.transaction.xa.Xid;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.tm.JBossXATerminator;
/*     */ import org.jboss.util.threadpool.ThreadPool;
/*     */ 
/*     */ public class JBossWorkManager extends ServiceMBeanSupport
/*     */   implements WorkManager, JBossWorkManagerMBean
/*     */ {
/*  46 */   private boolean trace = this.log.isTraceEnabled();
/*     */   private ThreadPool threadPool;
/*     */   private ObjectName threadPoolName;
/*     */   private JBossXATerminator xaTerminator;
/*     */   private ObjectName xaTerminatorName;
/*     */ 
/*     */   public ThreadPool getThreadPool()
/*     */   {
/*  67 */     return this.threadPool;
/*     */   }
/*     */ 
/*     */   public void setThreadPool(ThreadPool threadPool)
/*     */   {
/*  77 */     this.threadPool = threadPool;
/*     */   }
/*     */ 
/*     */   public ObjectName getThreadPoolName()
/*     */   {
/*  82 */     return this.threadPoolName;
/*     */   }
/*     */ 
/*     */   public void setThreadPoolName(ObjectName threadPoolName)
/*     */   {
/*  87 */     this.threadPoolName = threadPoolName;
/*     */   }
/*     */ 
/*     */   public ObjectName getXATerminatorName()
/*     */   {
/*  92 */     return this.xaTerminatorName;
/*     */   }
/*     */ 
/*     */   public void setXATerminatorName(ObjectName xaTerminatorName)
/*     */   {
/*  97 */     this.xaTerminatorName = xaTerminatorName;
/*     */   }
/*     */ 
/*     */   public WorkManager getInstance()
/*     */   {
/* 102 */     return this;
/*     */   }
/*     */ 
/*     */   public void doWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener listener) throws WorkException
/*     */   {
/* 107 */     if (ctx == null)
/* 108 */       ctx = new ExecutionContext();
/* 109 */     WorkWrapper wrapper = new WorkWrapper(this, work, 2, startTimeout, ctx, listener);
/* 110 */     importWork(wrapper);
/* 111 */     executeWork(wrapper);
/* 112 */     if (wrapper.getWorkException() != null)
/* 113 */       throw wrapper.getWorkException();
/*     */   }
/*     */ 
/*     */   public void doWork(Work work) throws WorkException
/*     */   {
/* 118 */     doWork(work, 9223372036854775807L, null, null);
/*     */   }
/*     */ 
/*     */   public long startWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener listener) throws WorkException
/*     */   {
/* 123 */     if (ctx == null)
/* 124 */       ctx = new ExecutionContext();
/* 125 */     WorkWrapper wrapper = new WorkWrapper(this, work, 1, startTimeout, ctx, listener);
/* 126 */     importWork(wrapper);
/* 127 */     executeWork(wrapper);
/* 128 */     if (wrapper.getWorkException() != null)
/* 129 */       throw wrapper.getWorkException();
/* 130 */     return wrapper.getBlockedElapsed();
/*     */   }
/*     */ 
/*     */   public long startWork(Work work) throws WorkException
/*     */   {
/* 135 */     return startWork(work, 9223372036854775807L, null, null);
/*     */   }
/*     */ 
/*     */   public void scheduleWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener listener) throws WorkException
/*     */   {
/* 140 */     if (ctx == null)
/* 141 */       ctx = new ExecutionContext();
/* 142 */     WorkWrapper wrapper = new WorkWrapper(this, work, 0, startTimeout, ctx, listener);
/* 143 */     importWork(wrapper);
/* 144 */     executeWork(wrapper);
/* 145 */     if (wrapper.getWorkException() != null)
/* 146 */       throw wrapper.getWorkException();
/*     */   }
/*     */ 
/*     */   public void scheduleWork(Work work) throws WorkException
/*     */   {
/* 151 */     scheduleWork(work, 9223372036854775807L, null, null);
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/* 156 */     if (this.threadPoolName == null) {
/* 157 */       throw new IllegalStateException("No thread pool name");
/*     */     }
/* 159 */     this.threadPool = ((ThreadPool)this.server.getAttribute(this.threadPoolName, "Instance"));
/*     */ 
/* 161 */     if (this.xaTerminatorName == null) {
/* 162 */       throw new IllegalStateException("No xa terminator name");
/*     */     }
/* 164 */     this.xaTerminator = ((JBossXATerminator)this.server.getAttribute(this.xaTerminatorName, "XATerminator"));
/*     */   }
/*     */ 
/*     */   protected void importWork(WorkWrapper wrapper)
/*     */     throws WorkException
/*     */   {
/* 175 */     this.trace = this.log.isTraceEnabled();
/* 176 */     if (this.trace) {
/* 177 */       this.log.trace("Importing work " + wrapper);
/*     */     }
/* 179 */     ExecutionContext ctx = wrapper.getExecutionContext();
/* 180 */     if (ctx != null)
/*     */     {
/* 182 */       Xid xid = ctx.getXid();
/* 183 */       if (xid != null)
/*     */       {
/* 186 */         long timeout = ctx.getTransactionTimeout() * 1000L;
/* 187 */         this.xaTerminator.registerWork(wrapper.getWork(), xid, timeout);
/*     */       }
/*     */     }
/* 190 */     if (this.trace)
/* 191 */       this.log.trace("Imported work " + wrapper);
/*     */   }
/*     */ 
/*     */   protected void executeWork(WorkWrapper wrapper)
/*     */     throws WorkException
/*     */   {
/* 202 */     if (this.trace) {
/* 203 */       this.log.trace("Submitting work to thread pool " + wrapper);
/*     */     }
/* 205 */     this.threadPool.runTaskWrapper(wrapper);
/*     */ 
/* 207 */     if (this.trace)
/* 208 */       this.log.trace("Submitted work to thread pool " + wrapper);
/*     */   }
/*     */ 
/*     */   protected void startWork(WorkWrapper wrapper)
/*     */     throws WorkException
/*     */   {
/* 219 */     if (this.trace) {
/* 220 */       this.log.trace("Starting work " + wrapper);
/*     */     }
/* 222 */     ExecutionContext ctx = wrapper.getExecutionContext();
/* 223 */     if (ctx != null)
/*     */     {
/* 225 */       Xid xid = ctx.getXid();
/* 226 */       if (xid != null)
/*     */       {
/* 228 */         this.xaTerminator.startWork(wrapper.getWork(), xid);
/*     */       }
/*     */     }
/* 231 */     if (this.trace)
/* 232 */       this.log.trace("Started work " + wrapper);
/*     */   }
/*     */ 
/*     */   protected void endWork(WorkWrapper wrapper)
/*     */   {
/* 243 */     if (this.trace) {
/* 244 */       this.log.trace("Ending work " + wrapper);
/*     */     }
/* 246 */     ExecutionContext ctx = wrapper.getExecutionContext();
/* 247 */     if (ctx != null)
/*     */     {
/* 249 */       Xid xid = ctx.getXid();
/* 250 */       if (xid != null)
/*     */       {
/* 252 */         this.xaTerminator.endWork(wrapper.getWork(), xid);
/*     */       }
/*     */     }
/* 255 */     if (this.trace)
/* 256 */       this.log.trace("Ended work " + wrapper);
/*     */   }
/*     */ 
/*     */   protected void cancelWork(WorkWrapper wrapper)
/*     */   {
/* 267 */     if (this.trace) {
/* 268 */       this.log.trace("Cancel work " + wrapper);
/*     */     }
/* 270 */     ExecutionContext ctx = wrapper.getExecutionContext();
/* 271 */     if (ctx != null)
/*     */     {
/* 273 */       Xid xid = ctx.getXid();
/* 274 */       if (xid != null)
/*     */       {
/* 276 */         this.xaTerminator.cancelWork(wrapper.getWork(), xid);
/*     */       }
/*     */     }
/* 279 */     if (this.trace)
/* 280 */       this.log.trace("Canceled work " + wrapper);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.work.JBossWorkManager
 * JD-Core Version:    0.6.0
 */