/*     */ package org.jboss.resource.statistic.pool;
/*     */ 
/*     */ import java.io.StringWriter;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import javax.xml.parsers.ParserConfigurationException;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.Transformer;
/*     */ import javax.xml.transform.TransformerException;
/*     */ import javax.xml.transform.TransformerFactory;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import javax.xml.transform.stream.StreamResult;
/*     */ import org.jboss.resource.statistic.JBossStatistics;
/*     */ import org.jboss.resource.statistic.formatter.StatisticsFormatter;
/*     */ import org.jboss.resource.statistic.formatter.StatisticsFormatterException;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Text;
/*     */ 
/*     */ public class JBossXmlSubPoolStatisticFormatter
/*     */   implements StatisticsFormatter
/*     */ {
/*     */   public Object formatSubPoolStatistics(Collection subPoolStatistics)
/*     */   {
/*  54 */     Document doc = createDocument();
/*  55 */     Element root = doc.createElement("subpool-statistics");
/*  56 */     doc.appendChild(root);
/*     */ 
/*  58 */     for (Iterator iter = subPoolStatistics.iterator(); iter.hasNext(); )
/*     */     {
/*  60 */       JBossSubPoolStatistics stat = (JBossSubPoolStatistics)iter.next();
/*  61 */       createChildNode(doc, root, stat);
/*     */     }
/*     */ 
/*  65 */     return getDocumentAsString(doc);
/*     */   }
/*     */ 
/*     */   public Object formatSubPoolStatistics(ManagedConnectionPoolStatistics stats)
/*     */   {
/*  70 */     return formatSubPoolStatistics(stats.getSubPools());
/*     */   }
/*     */ 
/*     */   private void createChildNode(Document doc, Element root, JBossSubPoolStatistics stat)
/*     */   {
/*  75 */     root.appendChild(createTextNode(doc, "max-connections-in-use", String.valueOf(stat.getMaxConnectionsInUse())));
/*  76 */     root.appendChild(createTextNode(doc, "track-by-txn", String.valueOf(stat.getTrackByTxn())));
/*  77 */     root.appendChild(createTextNode(doc, "connections-in-use", String.valueOf(stat.getConnectionsInUse())));
/*  78 */     root.appendChild(createTextNode(doc, "connections-destroyed", String.valueOf(stat.getConnectionsDestroyed())));
/*  79 */     root.appendChild(createTextNode(doc, "available-connections", String.valueOf(stat.getAvailableConnections())));
/*     */   }
/*     */ 
/*     */   private Element createTextNode(Document doc, String name, String value)
/*     */   {
/*  85 */     Text node = doc.createTextNode(name);
/*  86 */     node.setNodeValue(String.valueOf(value));
/*  87 */     Element child = doc.createElement(name);
/*  88 */     child.appendChild(node);
/*  89 */     return child;
/*     */   }
/*     */ 
/*     */   private Document createDocument()
/*     */   {
/*     */     try
/*     */     {
/*  98 */       Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
/*  99 */       return doc;
/*     */     }
/*     */     catch (ParserConfigurationException e) {
/*     */     }
/* 103 */     throw new StatisticsFormatterException(e.getMessage());
/*     */   }
/*     */ 
/*     */   private String getDocumentAsString(Document doc)
/*     */   {
/*     */     try
/*     */     {
/* 113 */       Source source = new DOMSource(doc);
/* 114 */       StringWriter writer = new StringWriter();
/* 115 */       StreamResult result = new StreamResult(writer);
/* 116 */       TransformerFactory.newInstance().newTransformer().transform(source, result);
/* 117 */       return writer.toString();
/*     */     }
/*     */     catch (TransformerException e) {
/*     */     }
/* 121 */     throw new StatisticsFormatterException(e.getMessage());
/*     */   }
/*     */ 
/*     */   public Object formatStatistics(JBossStatistics stats)
/*     */   {
/* 129 */     if (!(stats instanceof ManagedConnectionPoolStatistics))
/*     */     {
/* 131 */       throw new IllegalArgumentException("Error: invalid statistics implementaiton for formatter.");
/*     */     }
/*     */ 
/* 135 */     ManagedConnectionPoolStatistics poolStats = (ManagedConnectionPoolStatistics)stats;
/* 136 */     return formatSubPoolStatistics(poolStats);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.statistic.pool.JBossXmlSubPoolStatisticFormatter
 * JD-Core Version:    0.6.0
 */