/*     */ package org.jboss.resource.statistic.pool;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.resource.statistic.JBossStatistics;
/*     */ 
/*     */ public class JBossManagedConnectionPoolStatistics
/*     */   implements ManagedConnectionPoolStatistics
/*     */ {
/*     */   private static final long serialVersionUID = -2962342009092796221L;
/*     */   private String poolName;
/*     */   private long blockingTimeout;
/*     */   private long idleTimeout;
/*     */   private int min;
/*     */   private int max;
/*     */   private String criteria;
/*     */   private boolean noTxnSeperatePool;
/*     */   private final List subPools;
/*     */   private boolean trackByTxn;
/*     */   private boolean prefill;
/*     */ 
/*     */   public JBossManagedConnectionPoolStatistics()
/*     */   {
/*  61 */     this.subPools = new ArrayList();
/*     */   }
/*     */ 
/*     */   public JBossManagedConnectionPoolStatistics(int subPoolSize)
/*     */   {
/*  66 */     this.subPools = new ArrayList(subPoolSize);
/*     */   }
/*     */ 
/*     */   public JBossManagedConnectionPoolStatistics(String poolName)
/*     */   {
/*  71 */     this();
/*  72 */     this.poolName = poolName;
/*     */   }
/*     */ 
/*     */   public void addSubPool(JBossSubPoolStatistics subPool)
/*     */   {
/*  78 */     this.subPools.add(subPool);
/*     */   }
/*     */ 
/*     */   public Collection getSubPools()
/*     */   {
/*  83 */     return Collections.unmodifiableCollection(this.subPools);
/*     */   }
/*     */ 
/*     */   public long getBlockingTimeout()
/*     */   {
/*  90 */     return this.blockingTimeout;
/*     */   }
/*     */ 
/*     */   public void setBlockingTimeout(long blockTime)
/*     */   {
/*  96 */     this.blockingTimeout = blockTime;
/*     */   }
/*     */ 
/*     */   public String getCriteria()
/*     */   {
/* 102 */     return this.criteria;
/*     */   }
/*     */ 
/*     */   public long getIdleTimeout()
/*     */   {
/* 108 */     return this.idleTimeout;
/*     */   }
/*     */ 
/*     */   public void setIdleTimeout(long idleTimeout)
/*     */   {
/* 113 */     this.idleTimeout = idleTimeout;
/*     */   }
/*     */ 
/*     */   public int getMax()
/*     */   {
/* 118 */     return this.max;
/*     */   }
/*     */ 
/*     */   public void setMax(int max)
/*     */   {
/* 123 */     this.max = max;
/*     */   }
/*     */ 
/*     */   public int getMin() {
/* 127 */     return this.min;
/*     */   }
/*     */ 
/*     */   public void setMin(int min)
/*     */   {
/* 132 */     this.min = min;
/*     */   }
/*     */ 
/*     */   public boolean getNoTxnSeperatePool()
/*     */   {
/* 138 */     return this.noTxnSeperatePool;
/*     */   }
/*     */ 
/*     */   public void setNoTxnSeperatePool(boolean noTxnSeperatePool)
/*     */   {
/* 143 */     this.noTxnSeperatePool = noTxnSeperatePool;
/*     */   }
/*     */ 
/*     */   public JBossManagedConnectionPoolStatistics getStatistics()
/*     */   {
/* 149 */     return null;
/*     */   }
/*     */ 
/*     */   public int getSubPoolCount()
/*     */   {
/* 154 */     return this.subPools.size();
/*     */   }
/*     */ 
/*     */   public int getTotalConnectionsInUseCount()
/*     */   {
/* 160 */     int statValue = 0;
/*     */ 
/* 162 */     for (Iterator iter = this.subPools.iterator(); iter.hasNext(); )
/*     */     {
/* 164 */       JBossSubPoolStatistics statGroup = (JBossSubPoolStatistics)iter.next();
/* 165 */       statValue += statGroup.getConnectionsInUse();
/*     */     }
/*     */ 
/* 169 */     return statValue;
/*     */   }
/*     */ 
/*     */   public int getTotalMaxConnectionsInUseCount()
/*     */   {
/* 176 */     int statValue = 0;
/*     */ 
/* 178 */     for (Iterator iter = this.subPools.iterator(); iter.hasNext(); )
/*     */     {
/* 180 */       JBossSubPoolStatistics statGroup = (JBossSubPoolStatistics)iter.next();
/* 181 */       statValue += statGroup.getMaxConnectionsInUse();
/*     */     }
/*     */ 
/* 185 */     return statValue;
/*     */   }
/*     */ 
/*     */   public boolean getTrackByTxn()
/*     */   {
/* 191 */     return this.trackByTxn;
/*     */   }
/*     */ 
/*     */   public void setTrackByTxn(boolean trackByTxn)
/*     */   {
/* 196 */     this.trackByTxn = trackByTxn;
/*     */   }
/*     */ 
/*     */   public boolean getPrefill()
/*     */   {
/* 203 */     return this.prefill;
/*     */   }
/*     */ 
/*     */   public void setPrefill(boolean prefill)
/*     */   {
/* 208 */     this.prefill = prefill;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 213 */     return this.poolName;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 218 */     this.poolName = name;
/*     */   }
/*     */ 
/*     */   public void setCriteria(String criteria)
/*     */   {
/* 223 */     this.criteria = criteria;
/*     */   }
/*     */ 
/*     */   public void addSubPool(JBossStatistics subPool)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.statistic.pool.JBossManagedConnectionPoolStatistics
 * JD-Core Version:    0.6.0
 */