/*     */ package org.jboss.resource.security;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Map;
/*     */ import javax.resource.spi.security.PasswordCredential;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public class ConfiguredIdentityLoginModule extends AbstractPasswordCredentialLoginModule
/*     */ {
/*     */   private String principalName;
/*     */   private String userName;
/*     */   private String password;
/*  59 */   private static final Logger log = Logger.getLogger(ConfiguredIdentityLoginModule.class);
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)
/*     */   {
/*  68 */     super.initialize(subject, handler, sharedState, options);
/*  69 */     this.principalName = ((String)options.get("principal"));
/*  70 */     if (this.principalName == null)
/*     */     {
/*  72 */       throw new IllegalArgumentException("Must supply a principal name!");
/*     */     }
/*  74 */     this.userName = ((String)options.get("userName"));
/*  75 */     if (this.userName == null)
/*     */     {
/*  77 */       throw new IllegalArgumentException("Must supply a user name!");
/*     */     }
/*  79 */     this.password = ((String)options.get("password"));
/*  80 */     if (this.password == null)
/*     */     {
/*  82 */       log.warn("Creating LoginModule with no configured password!");
/*  83 */       this.password = "";
/*     */     }
/*  85 */     log.trace("got principal: " + this.principalName + ", username: " + this.userName + ", password: " + this.password);
/*     */   }
/*     */ 
/*     */   public boolean login()
/*     */     throws LoginException
/*     */   {
/*  91 */     log.trace("login called");
/*  92 */     if (super.login() == true) {
/*  93 */       return true;
/*     */     }
/*  95 */     Principal principal = new SimplePrincipal(this.principalName);
/*  96 */     SubjectActions.addPrincipals(this.subject, principal);
/*     */ 
/*  98 */     this.sharedState.put("javax.security.auth.login.name", this.principalName);
/*  99 */     PasswordCredential cred = new PasswordCredential(this.userName, this.password.toCharArray());
/* 100 */     cred.setManagedConnectionFactory(getMcf());
/* 101 */     SubjectActions.addCredentials(this.subject, cred);
/* 102 */     this.loginOk = true;
/* 103 */     return true;
/*     */   }
/*     */ 
/*     */   protected Principal getIdentity()
/*     */   {
/* 108 */     log.trace("getIdentity called");
/* 109 */     Principal principal = new SimplePrincipal(this.principalName);
/* 110 */     return principal;
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets()
/*     */     throws LoginException
/*     */   {
/* 118 */     log.trace("getRoleSets called");
/* 119 */     return new Group[0];
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.security.ConfiguredIdentityLoginModule
 * JD-Core Version:    0.6.0
 */