/*     */ package org.jboss.resource.metadata.repository;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.resource.spi.ActivationSpec;
/*     */ import org.jboss.aop.microcontainer.aspects.jmx.JMX;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.deployment.AdminObject;
/*     */ import org.jboss.resource.metadata.ConnectorMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
/*     */ 
/*     */ @JMX(exposedInterface=JCAMetaDataRepository.class, name="jboss.jca:service=JCAMetaDataRepository,name=DefaultJCAMetaDataRepository")
/*     */ public class DefaultJCAMetaDataRepository
/*     */   implements JCAMetaDataRepository, Serializable
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(DefaultJCAMetaDataRepository.class);
/*     */   private static final long serialVersionUID = 244233303934974673L;
/*  54 */   private static final String DEFAULT_FORMATTER = DefaultJCAEntryFormatter.class.getName();
/*     */   private String formatterClassName;
/*     */   private JCAMetaDataEntryFormatter formatter;
/*  59 */   private Map<JCAConnectorMetaDataKey, JCAConnectorMetaDataEntry> connectors = new ConcurrentHashMap();
/*     */ 
/*     */   public void setFormatterClassName(String formatterClassName)
/*     */   {
/*  63 */     if (formatterClassName != null)
/*     */     {
/*  65 */       if ((this.formatterClassName != null) && (!this.formatterClassName.equals(formatterClassName)))
/*     */       {
/*  67 */         loadFormatter(formatterClassName);
/*  68 */         this.formatterClassName = this.formatter.getClass().getName();
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  73 */       this.formatterClassName = "org.jboss.resource.metadata.repository.DefaultJCAEntryFormatter";
/*  74 */       loadFormatter(this.formatterClassName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getFormatterClassName()
/*     */   {
/*  80 */     return this.formatterClassName;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*  86 */     if ((this.formatter == null) && (this.formatterClassName != null))
/*     */     {
/*  88 */       loadFormatter(this.formatterClassName);
/*     */     }
/*  90 */     else if ((this.formatter == null) && (this.formatterClassName == null))
/*     */     {
/*  92 */       loadFormatter(DEFAULT_FORMATTER);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addConnectorMetaData(String name, ConnectorMetaData cmd)
/*     */   {
/*  99 */     JCAConnectorMetaDataKey key = new JCAConnectorMetaDataKey(name);
/* 100 */     key.setName(name);
/*     */ 
/* 102 */     JCAConnectorMetaDataEntry entry = (JCAConnectorMetaDataEntry)this.connectors.get(key);
/*     */ 
/* 104 */     if (entry != null)
/*     */     {
/* 106 */       entry.setConnectorMetaData(cmd);
/* 107 */       log.debug("Updated ConnectorMetaData for: " + name);
/*     */     }
/*     */     else
/*     */     {
/* 111 */       entry = new JCAConnectorMetaDataEntry();
/* 112 */       entry.setConnectorMetaData(cmd);
/* 113 */       log.debug("Added ConnectorMetaData for: " + name);
/* 114 */       this.connectors.put(key, entry);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ConnectorMetaData getConnectorMetaData(String name)
/*     */   {
/* 121 */     JCAConnectorMetaDataKey entry = new JCAConnectorMetaDataKey(name);
/* 122 */     entry.setName(name);
/* 123 */     ConnectorMetaData md = getConnectorMetaData(entry);
/* 124 */     return md;
/*     */   }
/*     */ 
/*     */   private ConnectorMetaData getConnectorMetaData(JCAConnectorMetaDataKey key)
/*     */   {
/* 129 */     JCAConnectorMetaDataEntry entry = (JCAConnectorMetaDataEntry)this.connectors.get(key);
/* 130 */     return entry.getConnectorMetaData();
/*     */   }
/*     */ 
/*     */   public void addActivationSpec(String rarName, ActivationSpec spec)
/*     */   {
/* 136 */     JCAConnectorMetaDataKey key = new JCAConnectorMetaDataKey(rarName);
/* 137 */     addDeployment(key, JCADeploymentType.ACTIVATION_SPEC, spec);
/*     */   }
/*     */ 
/*     */   public void addAdminObject(String rarName, AdminObject adminObject)
/*     */   {
/* 143 */     JCAConnectorMetaDataKey key = new JCAConnectorMetaDataKey(rarName);
/* 144 */     addDeployment(key, JCADeploymentType.ADMIN_OBJECT, adminObject);
/*     */   }
/*     */ 
/*     */   public void addManagedConnectionFactoryDeploymentGroup(ManagedConnectionFactoryDeploymentGroup group)
/*     */   {
/* 150 */     List mcf = group.getDeployments();
/*     */ 
/* 152 */     for (ManagedConnectionFactoryDeploymentMetaData deployment : mcf)
/*     */     {
/* 154 */       JCAConnectorMetaDataKey key = new JCAConnectorMetaDataKey(deployment.getRarName());
/* 155 */       addDeployment(key, JCADeploymentType.MCF, deployment);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object listDeploymentsForConnector(String rarName)
/*     */   {
/* 163 */     Object results = null;
/* 164 */     JCAConnectorMetaDataKey key = new JCAConnectorMetaDataKey(rarName);
/* 165 */     JCAConnectorMetaDataEntry entry = (JCAConnectorMetaDataEntry)this.connectors.get(key);
/*     */ 
/* 167 */     if (entry != null)
/*     */     {
/* 169 */       List deployments = entry.getDeployments();
/* 170 */       results = this.formatter.formatEntries(deployments);
/*     */     }
/*     */     else
/*     */     {
/* 175 */       results = "No entries for ConnectorMetaData " + rarName;
/*     */     }
/*     */ 
/* 178 */     return results;
/*     */   }
/*     */ 
/*     */   private void addDeployment(JCAConnectorMetaDataKey key, JCADeploymentType deploymentType, Object deployment)
/*     */   {
/* 185 */     JCAConnectorMetaDataEntry entry = (JCAConnectorMetaDataEntry)this.connectors.get(key);
/*     */ 
/* 187 */     if (entry == null)
/*     */     {
/* 189 */       entry = new JCAConnectorMetaDataEntry();
/* 190 */       entry.addDeployment(deploymentType, deployment);
/*     */ 
/* 192 */       this.connectors.put(key, entry);
/*     */     }
/*     */     else
/*     */     {
/* 197 */       entry.addDeployment(deploymentType, deployment);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getActivationSpecCount()
/*     */   {
/* 203 */     return getCount(JCADeploymentType.ACTIVATION_SPEC);
/*     */   }
/*     */ 
/*     */   public int getAdminObjectCount()
/*     */   {
/* 208 */     return getCount(JCADeploymentType.ADMIN_OBJECT);
/*     */   }
/*     */ 
/*     */   public int getConnectorMetaDataCount()
/*     */   {
/* 213 */     int count = 0;
/*     */     Iterator iter;
/* 215 */     synchronized (this.connectors)
/*     */     {
/* 217 */       for (iter = this.connectors.values().iterator(); iter.hasNext(); )
/*     */       {
/* 219 */         JCAConnectorMetaDataEntry entry = (JCAConnectorMetaDataEntry)iter.next();
/*     */ 
/* 221 */         if (entry.getConnectorMetaData() != null)
/*     */         {
/* 223 */           count++;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 229 */     return count;
/*     */   }
/*     */ 
/*     */   public int getManagedConnectionFactoryCount()
/*     */   {
/* 234 */     return getCount(JCADeploymentType.MCF);
/*     */   }
/*     */ 
/*     */   private int getCount(JCADeploymentType deploymentType)
/*     */   {
/* 239 */     int count = 0;
/*     */     Iterator iter;
/* 241 */     synchronized (this.connectors)
/*     */     {
/* 243 */       for (iter = this.connectors.values().iterator(); iter.hasNext(); )
/*     */       {
/* 245 */         JCAConnectorMetaDataEntry entry = (JCAConnectorMetaDataEntry)iter.next();
/*     */ 
/* 247 */         List deployments = entry.getDeployments();
/*     */ 
/* 249 */         for (JCADeploymentMetaDataEntry deployment : deployments)
/*     */         {
/* 251 */           if (deployment.getDeploymentType().equals(deploymentType))
/*     */           {
/* 253 */             count++;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 259 */     return count;
/*     */   }
/*     */ 
/*     */   private void loadFormatter(String name)
/*     */   {
/* 265 */     if (name != null)
/*     */     {
/*     */       try
/*     */       {
/* 269 */         ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 270 */         Class clz = cl.loadClass(this.formatterClassName);
/* 271 */         this.formatter = ((JCAMetaDataEntryFormatter)clz.newInstance());
/* 272 */         this.formatterClassName = name;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 276 */         log.trace("Could not formatter for classname " + this.formatterClassName + " using default.");
/* 277 */         this.formatter = new DefaultJCAEntryFormatter();
/* 278 */         this.formatterClassName = this.formatter.getClass().getName();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.metadata.repository.DefaultJCAMetaDataRepository
 * JD-Core Version:    0.6.0
 */