/*     */ package org.jboss.resource.metadata.mcf;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlAccessType;
/*     */ import javax.xml.bind.annotation.XmlAccessorType;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlElements;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
/*     */ import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
/*     */ import org.jboss.managed.api.annotation.ManagementObject;
/*     */ import org.jboss.managed.api.annotation.ManagementObjectID;
/*     */ import org.jboss.managed.api.annotation.ManagementObjectRef;
/*     */ import org.jboss.managed.api.annotation.ManagementProperties;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty;
/*     */ import org.jboss.resource.deployers.management.ConnectionFactoryProperty;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ 
/*     */ @XmlAccessorType(XmlAccessType.FIELD)
/*     */ @ManagementObject(properties=ManagementProperties.EXPLICIT)
/*     */ public class ManagedConnectionFactoryDeploymentMetaData
/*     */   implements Serializable, ConnectionPoolMetaData
/*     */ {
/*     */   private static final long serialVersionUID = -4591557831734316580L;
/*     */ 
/*     */   @XmlElement(name="jndi-name")
/*     */   private String jndiName;
/*     */ 
/*     */   @XmlElement(name="rar-name")
/*     */   private String rarName;
/*     */ 
/*     */   @XmlElement(name="use-java-context")
/*  68 */   private boolean useJavaContext = true;
/*     */ 
/*     */   @XmlElement(name="connection-definition")
/*     */   @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
/*     */   protected String connectionDefinition;
/*     */ 
/*     */   @XmlElement(name="jmx-invoker-name")
/*  77 */   private String jmxInvokerName = "jboss:service=invoker,type=jrmp";
/*     */ 
/*     */   @XmlElement(name="min-pool-size")
/*  80 */   private int minSize = 0;
/*     */ 
/*     */   @XmlElement(name="max-pool-size")
/*  83 */   private int maxPoolSize = 10;
/*     */ 
/*     */   @XmlElement(name="blocking-timeout-millis")
/*  86 */   private long blockingTimeout = 30000L;
/*     */ 
/*     */   @XmlElement(name="idle-timeout-minutes")
/*  89 */   private int idleTimeout = 30;
/*     */ 
/*     */   @XmlElement(name="prefill")
/*  92 */   private Boolean prefill = Boolean.FALSE;
/*     */ 
/*     */   @XmlElement(name="background-validation")
/*     */   private boolean backgroundValidation;
/*     */ 
/*     */   @XmlElement(name="background-validation-minutes")
/*     */   private int backgroundValidationMinutes;
/*     */ 
/*     */   @XmlElement(name="validate-on-match")
/* 101 */   private boolean validateOnMatch = true;
/*     */ 
/*     */   @XmlJavaTypeAdapter(ManagedConnectionEmptyContentAdapter.class)
/*     */   @XmlElement(name="use-strict-min")
/* 104 */   private Boolean useStrictMin = Boolean.FALSE;
/*     */ 
/*     */   @XmlJavaTypeAdapter(ManagedConnectionEmptyContentAdapter.class)
/*     */   @XmlElement(name="no-tx-separate-pools")
/* 108 */   private Boolean noTxSeparatePools = Boolean.FALSE;
/*     */ 
/*     */   @XmlElement(name="statistics-formatter")
/* 112 */   private String statisticsFormatter = "org.jboss.resource.statistic.pool.JBossDefaultSubPoolStatisticFormatter";
/*     */ 
/*     */   @XmlElement(name="isSameRM-override-value")
/* 115 */   private Boolean isSameRMOverrideValue = Boolean.FALSE;
/*     */ 
/*     */   @XmlJavaTypeAdapter(ManagedConnectionEmptyContentAdapter.class)
/*     */   @XmlElement(name="track-connection-by-tx")
/* 118 */   private Boolean trackConnectionByTransaction = Boolean.FALSE;
/*     */ 
/*     */   @XmlTransient
/* 123 */   private ManagedConnectionFactoryTransactionSupportMetaData transactionSupportMetaData = ManagedConnectionFactoryTransactionSupportMetaData.NONE;
/*     */ 
/*     */   @XmlElement(name="config-property")
/* 127 */   private List<ManagedConnectionFactoryPropertyMetaData> managedConnectionFactoryProperties = new ArrayList();
/*     */ 
/*     */   @XmlElements({@XmlElement(name="security-domain", type=SecurityDomainMetaData.class), @XmlElement(name="security-domain-and-application", type=SecurityDomainApplicationManagedMetaData.class), @XmlElement(name="application-managed-security", type=ApplicationManagedSecurityMetaData.class)})
/*     */   private SecurityMetaData securityMetaData;
/*     */ 
/*     */   @XmlElement(name="depends")
/* 134 */   private List<String> dependsNames = new ArrayList();
/*     */ 
/*     */   @XmlTransient
/* 137 */   private List<ServiceMetaData> dependsServices = new ArrayList();
/*     */ 
/*     */   @XmlElement(name="metadata")
/*     */   private DBMSMetaData dbmsMetaData;
/*     */ 
/*     */   @XmlElement(name="type-mapping")
/*     */   String typeMapping;
/*     */ 
/*     */   @XmlJavaTypeAdapter(ManagedConnectionEmptyContentAdapter.class)
/*     */   @XmlElement(name="local-transaction")
/* 148 */   private Boolean localTransactions = Boolean.FALSE;
/*     */ 
/*     */   @ManagementProperty(name="connection-definition")
/*     */   public String getConnectionDefinition()
/*     */   {
/* 161 */     return this.connectionDefinition;
/*     */   }
/*     */ 
/*     */   public void setConnectionDefinition(String connectionDefinition)
/*     */   {
/* 171 */     this.connectionDefinition = connectionDefinition;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="jndi-name", description="The global JNDI name to bind the factory under")
/*     */   @ManagementObjectID(type="DataSource")
/*     */   public String getJndiName()
/*     */   {
/* 183 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/* 193 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(ignored=true)
/*     */   public ManagedConnectionFactoryTransactionSupportMetaData getTransactionSupportMetaData()
/*     */   {
/* 204 */     return this.transactionSupportMetaData;
/*     */   }
/*     */ 
/*     */   public void setTransactionSupportMetaData(ManagedConnectionFactoryTransactionSupportMetaData transactionSupportMetaData)
/*     */   {
/* 214 */     this.transactionSupportMetaData = transactionSupportMetaData;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="use-java-context")
/*     */   public boolean isUseJavaContext()
/*     */   {
/* 225 */     return this.useJavaContext;
/*     */   }
/*     */ 
/*     */   public void setUseJavaContext(boolean useJavaContext)
/*     */   {
/* 235 */     this.useJavaContext = useJavaContext;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="config-property", managed=true, propertyFactory=ConnectionFactoryProperty.class)
/*     */   public List<ManagedConnectionFactoryPropertyMetaData> getManagedConnectionFactoryProperties()
/*     */   {
/* 246 */     return this.managedConnectionFactoryProperties;
/*     */   }
/*     */ 
/*     */   public void setManagedConnectionFactoryProperties(List<ManagedConnectionFactoryPropertyMetaData> managedConnectionFactoryProperties)
/*     */   {
/* 257 */     this.managedConnectionFactoryProperties = managedConnectionFactoryProperties;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="rar-name")
/*     */   public String getRarName()
/*     */   {
/* 268 */     return this.rarName;
/*     */   }
/*     */ 
/*     */   public void setRarName(String rarName)
/*     */   {
/* 278 */     this.rarName = rarName;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="security-domain", managed=true)
/*     */   public SecurityMetaData getSecurityMetaData()
/*     */   {
/* 289 */     return this.securityMetaData;
/*     */   }
/*     */ 
/*     */   public void setSecurityMetaData(SecurityMetaData securityMetaData)
/*     */   {
/* 299 */     this.securityMetaData = securityMetaData;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="type-mapping")
/*     */   public String getTypeMapping()
/*     */   {
/* 311 */     return this.typeMapping;
/*     */   }
/*     */ 
/*     */   public void setTypeMapping(String typeMapping)
/*     */   {
/* 321 */     this.typeMapping = typeMapping;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="jmx-invoker-name")
/*     */   @ManagementObjectRef(type="JMXInvoker")
/*     */   public String getJmxInvokerName()
/*     */   {
/* 333 */     return this.jmxInvokerName;
/*     */   }
/*     */ 
/*     */   public void setJmxInvokerName(String jmxInvokerName)
/*     */   {
/* 343 */     this.jmxInvokerName = jmxInvokerName;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="depends", ignored=true)
/*     */   public List<String> getDependsNames()
/*     */   {
/* 354 */     return this.dependsNames;
/*     */   }
/*     */ 
/*     */   public void setDependsNames(List<String> dependsNames)
/*     */   {
/* 364 */     this.dependsNames = dependsNames;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="services", ignored=true)
/*     */   public List<ServiceMetaData> getDependsServices()
/*     */   {
/* 375 */     return this.dependsServices;
/*     */   }
/*     */ 
/*     */   public void setDependsServices(List<ServiceMetaData> dependsServices)
/*     */   {
/* 385 */     this.dependsServices = dependsServices;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="min-pool-size")
/*     */   public void setMinSize(int minSize) {
/* 391 */     this.minSize = minSize;
/*     */   }
/*     */ 
/*     */   public int getMinSize()
/*     */   {
/* 396 */     return this.minSize;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="max-pool-size")
/*     */   public void setMaxSize(int maxSize)
/*     */   {
/* 403 */     this.maxPoolSize = maxSize;
/*     */   }
/*     */ 
/*     */   public int getMaxSize()
/*     */   {
/* 408 */     return this.maxPoolSize;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="blocking-timeout-millis")
/*     */   public void setBlockingTimeoutMilliSeconds(long blockTimeout)
/*     */   {
/* 415 */     this.blockingTimeout = blockTimeout;
/*     */   }
/*     */ 
/*     */   public long getBlockingTimeoutMilliSeconds()
/*     */   {
/* 421 */     return this.blockingTimeout;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="idle-timeout-minutes")
/*     */   public void setIdleTimeoutMinutes(int idleTimeout)
/*     */   {
/* 428 */     this.idleTimeout = idleTimeout;
/*     */   }
/*     */ 
/*     */   public int getIdleTimeoutMinutes()
/*     */   {
/* 433 */     return this.idleTimeout;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="prefill")
/*     */   public void setPrefill(Boolean prefill)
/*     */   {
/* 440 */     this.prefill = prefill;
/*     */   }
/*     */ 
/*     */   public Boolean getPrefill()
/*     */   {
/* 445 */     return this.prefill;
/*     */   }
/*     */ 
/*     */   public void setBackgroundValidation(boolean bgv)
/*     */   {
/* 451 */     this.backgroundValidation = bgv;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="background-validation")
/*     */   public boolean isBackgroundValidation()
/*     */   {
/* 458 */     return this.backgroundValidation;
/*     */   }
/*     */ 
/*     */   public void setBackgroundValidationMinutes(int interval)
/*     */   {
/* 463 */     this.backgroundValidationMinutes = interval;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="background-validation-minutes")
/*     */   public int getBackgroundValidationMinutes() {
/* 469 */     return this.backgroundValidationMinutes;
/*     */   }
/*     */ 
/*     */   public void setValidateOnMatch(boolean validateOnMatch)
/*     */   {
/* 474 */     this.validateOnMatch = validateOnMatch;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="validate-on-match")
/*     */   public boolean isValidateOnMatch() {
/* 480 */     return this.validateOnMatch;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="isSameRM-override-value")
/*     */   public Boolean getIsSameRMOverrideValue()
/*     */   {
/* 487 */     return this.isSameRMOverrideValue;
/*     */   }
/*     */ 
/*     */   public void setIsSameRMOverrideValue(Boolean isSameRMOverrideValue)
/*     */   {
/* 492 */     this.isSameRMOverrideValue = isSameRMOverrideValue;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="track-connection-by-tx")
/*     */   public Boolean getTrackConnectionByTransaction() {
/* 498 */     return this.trackConnectionByTransaction;
/*     */   }
/*     */ 
/*     */   public void setTrackConnectionByTransaction(Boolean trackConnectionByTransaction)
/*     */   {
/* 503 */     this.trackConnectionByTransaction = trackConnectionByTransaction;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="local-transaction")
/*     */   public Boolean getLocalTransactions() {
/* 509 */     return this.localTransactions;
/*     */   }
/*     */ 
/*     */   public void setLocalTransactions(Boolean localTransactions)
/*     */   {
/* 514 */     this.localTransactions = localTransactions;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="use-strict-min")
/*     */   public Boolean getUseStrictMin() {
/* 520 */     return this.useStrictMin;
/*     */   }
/*     */ 
/*     */   public void setUseStrictMin(Boolean useStrictMin)
/*     */   {
/* 525 */     this.useStrictMin = useStrictMin;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="statistics-formatter")
/*     */   public String getStatisticsFormatter() {
/* 531 */     return this.statisticsFormatter;
/*     */   }
/*     */ 
/*     */   public void setStatisticsFormatter(String statisticsFormatter)
/*     */   {
/* 536 */     this.statisticsFormatter = statisticsFormatter;
/*     */   }
/*     */ 
/*     */   public Boolean getNoTxSeparatePools()
/*     */   {
/* 541 */     return this.noTxSeparatePools;
/*     */   }
/*     */ 
/*     */   public void setNoTxSeparatePools(Boolean notxpool)
/*     */   {
/* 546 */     this.noTxSeparatePools = notxpool;
/*     */   }
/*     */ 
/*     */   public DBMSMetaData getDBMSMetaData()
/*     */   {
/* 551 */     return this.dbmsMetaData;
/*     */   }
/*     */ 
/*     */   public void setDBMSMetaData(DBMSMetaData dbmsMetaData)
/*     */   {
/* 556 */     this.dbmsMetaData = dbmsMetaData;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData
 * JD-Core Version:    0.6.0
 */