/*     */ package org.jboss.resource.metadata;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Locale;
/*     */ 
/*     */ public class DescriptionMetaDataContainer
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2831943526217092377L;
/*  42 */   private ConcurrentReaderHashMap descriptions = new ConcurrentReaderHashMap();
/*     */ 
/*     */   public DescriptionMetaDataContainer()
/*     */   {
/*  46 */     DescriptionMetaData dmd = new DescriptionMetaData();
/*  47 */     this.descriptions.put(dmd.getLanguage(), dmd);
/*     */   }
/*     */ 
/*     */   public DescriptionMetaData getDescription()
/*     */   {
/*  59 */     DescriptionMetaData dmd = (DescriptionMetaData)this.descriptions.get(Locale.getDefault().getLanguage());
/*     */ 
/*  61 */     if (dmd == null)
/*     */     {
/*  63 */       Iterator i = this.descriptions.values().iterator(); if (i.hasNext())
/*     */       {
/*  65 */         dmd = (DescriptionMetaData)i.next();
/*     */       }
/*     */     }
/*     */ 
/*  69 */     return dmd;
/*     */   }
/*     */ 
/*     */   public DescriptionMetaData getDescription(String lang)
/*     */   {
/*  80 */     return (DescriptionMetaData)this.descriptions.get(lang);
/*     */   }
/*     */ 
/*     */   public void addDescription(DescriptionMetaData dmd)
/*     */   {
/*  90 */     this.descriptions.put(dmd.getLanguage(), dmd);
/*     */   }
/*     */ 
/*     */   public Collection getDescriptions()
/*     */   {
/* 100 */     return this.descriptions.values();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 105 */     StringBuffer buffer = new StringBuffer();
/* 106 */     buffer.append("DescriptionMetaDataContainer").append('@');
/* 107 */     buffer.append(Integer.toHexString(System.identityHashCode(this)));
/* 108 */     buffer.append("[descriptions=").append(this.descriptions.values());
/* 109 */     buffer.append(']');
/* 110 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.metadata.DescriptionMetaDataContainer
 * JD-Core Version:    0.6.0
 */