/*     */ package org.jboss.resource.deployment;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.metadata.AdminObjectMetaData;
/*     */ import org.jboss.resource.metadata.AuthenticationMechanismMetaData;
/*     */ import org.jboss.resource.metadata.ConfigPropertyMetaData;
/*     */ import org.jboss.resource.metadata.ConnectionDefinitionMetaData;
/*     */ import org.jboss.resource.metadata.ConnectorMetaData;
/*     */ import org.jboss.resource.metadata.DescriptionGroupMetaData;
/*     */ import org.jboss.resource.metadata.DescriptionMetaData;
/*     */ import org.jboss.resource.metadata.LicenseMetaData;
/*     */ import org.jboss.resource.metadata.MessageListenerMetaData;
/*     */ import org.jboss.resource.metadata.RequiredConfigPropertyMetaData;
/*     */ import org.jboss.resource.metadata.SecurityPermissionMetaData;
/*     */ import org.jboss.resource.metadata.TransactionSupportMetaData;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class ResourceAdapterObjectModelFactory
/*     */   implements ObjectModelFactory
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(ResourceAdapterObjectModelFactory.class);
/*     */ 
/*  53 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public Object newChild(ConnectorMetaData cmd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  66 */     if (this.trace) {
/*  67 */       log.trace("connector newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/*     */     }
/*  69 */     if ((localName.equals("vendor-name")) || (localName.equals("eis-type")) || (localName.equals("resourceadapter-version")) || ((localName.equals("resourceadapter")) && (!cmd.getVersion().equals("1.0"))) || (localName.equals("resourceadapter-class")) || (localName.equals("reauthentication-support")))
/*     */     {
/*  76 */       return null;
/*     */     }
/*  78 */     if ((localName.equals("description")) || (localName.equals("display-name")) || (localName.equals("small-icon")) || (localName.equals("large-icon")))
/*     */     {
/*  83 */       String language = attrs.getValue("xml:lang");
/*  84 */       DescriptionGroupMetaData dmd = null;
/*  85 */       if (language == null)
/*  86 */         dmd = cmd.getDescription();
/*     */       else
/*  88 */         dmd = cmd.getDescription(language);
/*  89 */       if (dmd == null)
/*  90 */         dmd = new DescriptionGroupMetaData(language);
/*  91 */       cmd.addDescription(dmd);
/*  92 */       return dmd;
/*     */     }
/*  94 */     if ((localName.equals("icon")) && (cmd.getVersion().equals("1.0")))
/*     */     {
/*  96 */       return null;
/*     */     }
/*  98 */     if (localName.equals("config-property"))
/*     */     {
/* 100 */       ConfigPropertyMetaData cpmd = new ConfigPropertyMetaData();
/* 101 */       cmd.addProperty(cpmd);
/* 102 */       return cpmd;
/*     */     }
/* 104 */     if (localName.equals("license"))
/*     */     {
/* 106 */       return cmd.getLicense();
/*     */     }
/* 108 */     if (localName.equals("outbound-resourceadapter"))
/*     */     {
/* 110 */       return null;
/*     */     }
/* 112 */     if ((localName.equals("connection-definition")) || ((localName.equals("resourceadapter")) && (cmd.getVersion().equals("1.0"))))
/*     */     {
/* 115 */       ConnectionDefinitionMetaData cdmd = new ConnectionDefinitionMetaData(cmd);
/* 116 */       cmd.addConnectionDefinition(cdmd);
/* 117 */       return cdmd;
/*     */     }
/* 119 */     if (localName.equals("transaction-support"))
/*     */     {
/* 121 */       TransactionSupportMetaData tsmd = new TransactionSupportMetaData();
/* 122 */       cmd.setTransactionSupport(tsmd);
/* 123 */       return tsmd;
/*     */     }
/* 125 */     if (localName.equals("authentication-mechanism"))
/*     */     {
/* 127 */       AuthenticationMechanismMetaData ammd = new AuthenticationMechanismMetaData();
/* 128 */       cmd.setAuthenticationMechansim(ammd);
/* 129 */       return ammd;
/*     */     }
/* 131 */     if ((localName.equals("inbound-resourceadapter")) || (localName.equals("messageadapter")))
/*     */     {
/* 134 */       return null;
/*     */     }
/* 136 */     if (localName.equals("messagelistener"))
/*     */     {
/* 138 */       MessageListenerMetaData mlmd = new MessageListenerMetaData();
/* 139 */       cmd.addMessageListener(mlmd);
/* 140 */       return mlmd;
/*     */     }
/* 142 */     if (localName.equals("adminobject"))
/*     */     {
/* 144 */       AdminObjectMetaData aomd = new AdminObjectMetaData();
/* 145 */       cmd.addAdminObject(aomd);
/* 146 */       return aomd;
/*     */     }
/* 148 */     if (localName.equals("security-permission"))
/*     */     {
/* 150 */       SecurityPermissionMetaData spmd = new SecurityPermissionMetaData();
/* 151 */       cmd.addSecurityPermission(spmd);
/* 152 */       return spmd;
/*     */     }
/*     */ 
/* 155 */     if ((localName.equals("spec-version")) || (localName.equals("version")))
/*     */     {
/* 158 */       return null;
/*     */     }
/* 160 */     throw new IllegalArgumentException("Unknown connector newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/*     */   }
/*     */ 
/*     */   public void setValue(ConnectorMetaData cmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 174 */     if (this.trace)
/* 175 */       log.trace("connector setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/* 176 */     if ((!localName.equals("connector")) && (!localName.equals("resourceadapter")) && (!localName.equals("outbound-resourceadapter")) && (!localName.equals("inbound-resourceadapter")) && (!localName.equals("messageadapter")))
/*     */     {
/* 183 */       if (localName.equals("vendor-name"))
/* 184 */         cmd.setVendorName(value);
/* 185 */       else if (localName.equals("eis-type"))
/* 186 */         cmd.setEISType(value);
/* 187 */       else if (localName.equals("resourceadapter-version"))
/* 188 */         cmd.setRAVersion(value);
/* 189 */       else if (localName.equals("resourceadapter-class"))
/* 190 */         cmd.setRAClass(value);
/* 191 */       else if (localName.equals("reauthentication-support")) {
/* 192 */         cmd.setReauthenticationSupport(Boolean.valueOf(value).booleanValue());
/*     */       }
/* 194 */       else if (localName.equals("spec-version"))
/* 195 */         cmd.setVersion(value);
/* 196 */       else if (localName.equals("version"))
/* 197 */         cmd.setRAVersion(value);
/*     */       else
/* 199 */         throw new IllegalArgumentException("Unknown connector setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(DescriptionGroupMetaData dmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 213 */     if (this.trace)
/* 214 */       log.trace("description group setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/* 215 */     if (localName.equals("description"))
/* 216 */       dmd.setDescription(value);
/* 217 */     else if (localName.equals("display-name"))
/* 218 */       dmd.setDisplayName(value);
/* 219 */     else if (localName.equals("small-icon"))
/* 220 */       dmd.setSmallIcon(value);
/* 221 */     else if (localName.equals("large-icon"))
/* 222 */       dmd.setLargeIcon(value);
/*     */     else
/* 224 */       throw new IllegalArgumentException("Unknown description group setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */   }
/*     */ 
/*     */   public void setValue(DescriptionMetaData dmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 238 */     if (this.trace)
/* 239 */       log.trace("description setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/* 240 */     if (localName.equals("description"))
/* 241 */       dmd.setDescription(value);
/*     */     else
/* 243 */       throw new IllegalArgumentException("Unknown description setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */   }
/*     */ 
/*     */   public Object newChild(ConfigPropertyMetaData cpmd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 257 */     if (this.trace)
/* 258 */       log.trace("config property newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/* 259 */     if ((localName.equals("config-property-name")) || (localName.equals("config-property-type")) || (localName.equals("config-property-value")))
/*     */     {
/* 263 */       return null;
/*     */     }
/* 265 */     if (localName.equals("description"))
/*     */     {
/* 267 */       String language = attrs.getValue("xml:lang");
/* 268 */       DescriptionMetaData dmd = null;
/* 269 */       if (language == null)
/* 270 */         dmd = cpmd.getDescription();
/*     */       else
/* 272 */         dmd = cpmd.getDescription(language);
/* 273 */       if (dmd == null)
/* 274 */         dmd = new DescriptionMetaData(language);
/* 275 */       cpmd.addDescription(dmd);
/* 276 */       return dmd;
/*     */     }
/*     */ 
/* 279 */     throw new IllegalArgumentException("Unknown config property newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/*     */   }
/*     */ 
/*     */   public void setValue(ConfigPropertyMetaData cpmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 293 */     if (this.trace)
/* 294 */       log.trace("config property setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/* 295 */     if (!localName.equals("config-property"))
/*     */     {
/* 298 */       if (localName.equals("config-property-name"))
/* 299 */         cpmd.setName(value);
/* 300 */       else if (localName.equals("config-property-type"))
/* 301 */         cpmd.setType(value);
/* 302 */       else if (localName.equals("config-property-value"))
/* 303 */         cpmd.setValue(value);
/*     */       else
/* 305 */         throw new IllegalArgumentException("Unknown config property setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(LicenseMetaData lmd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 319 */     if (this.trace)
/* 320 */       log.trace("license newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/* 321 */     if (localName.equals("license"))
/*     */     {
/* 323 */       return null;
/*     */     }
/* 325 */     if (localName.equals("license-required"))
/*     */     {
/* 327 */       return null;
/*     */     }
/* 329 */     if (localName.equals("description"))
/*     */     {
/* 331 */       String language = attrs.getValue("xml:lang");
/* 332 */       DescriptionMetaData dmd = null;
/* 333 */       if (language == null)
/* 334 */         dmd = lmd.getDescription();
/*     */       else
/* 336 */         dmd = lmd.getDescription(language);
/* 337 */       if (dmd == null)
/* 338 */         dmd = new DescriptionMetaData(language);
/* 339 */       lmd.addDescription(dmd);
/* 340 */       return dmd;
/*     */     }
/*     */ 
/* 343 */     throw new IllegalArgumentException("Unknown license newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/*     */   }
/*     */ 
/*     */   public void setValue(LicenseMetaData lmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 357 */     if (this.trace)
/* 358 */       log.trace("license setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/* 359 */     if (!localName.equals("license"))
/*     */     {
/* 362 */       if (localName.equals("license-required"))
/* 363 */         lmd.setRequired(Boolean.valueOf(value).booleanValue());
/*     */       else
/* 365 */         throw new IllegalArgumentException("Unknown license setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(ConnectionDefinitionMetaData cdmd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 379 */     if (this.trace)
/* 380 */       log.trace("connection definition newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/* 381 */     if ((localName.equals("connection-definition")) || (localName.equals("managedconnectionfactory-class")) || (localName.equals("connectionfactory-interface")) || (localName.equals("connectionfactory-impl-class")) || (localName.equals("connection-interface")) || (localName.equals("connection-impl-class")))
/*     */     {
/* 388 */       return null;
/*     */     }
/* 390 */     if (localName.equals("config-property"))
/*     */     {
/* 392 */       ConfigPropertyMetaData cpmd = new ConfigPropertyMetaData();
/* 393 */       cdmd.addProperty(cpmd);
/* 394 */       return cpmd;
/*     */     }
/*     */ 
/* 397 */     if (localName.equals("transaction-support"))
/*     */     {
/* 399 */       TransactionSupportMetaData tsmd = new TransactionSupportMetaData();
/* 400 */       cdmd.getConnector().setTransactionSupport(tsmd);
/* 401 */       return tsmd;
/*     */     }
/* 403 */     if (localName.equals("authentication-mechanism"))
/*     */     {
/* 405 */       AuthenticationMechanismMetaData ammd = new AuthenticationMechanismMetaData();
/* 406 */       cdmd.getConnector().setAuthenticationMechansim(ammd);
/* 407 */       return ammd;
/*     */     }
/* 409 */     if (localName.equals("security-permission"))
/*     */     {
/* 411 */       SecurityPermissionMetaData spmd = new SecurityPermissionMetaData();
/* 412 */       cdmd.getConnector().addSecurityPermission(spmd);
/* 413 */       return spmd;
/*     */     }
/* 415 */     if (localName.equals("reauthentication-support"))
/*     */     {
/* 417 */       return null;
/*     */     }
/*     */ 
/* 420 */     throw new IllegalArgumentException("Unknown connection definition newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/*     */   }
/*     */ 
/*     */   public void setValue(ConnectionDefinitionMetaData cdmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 434 */     if (this.trace)
/* 435 */       log.trace("connection definition setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/* 436 */     if (!localName.equals("connection-definition"))
/*     */     {
/* 439 */       if (localName.equals("managedconnectionfactory-class"))
/* 440 */         cdmd.setManagedConnectionFactoryClass(value);
/* 441 */       else if (localName.equals("connectionfactory-interface"))
/* 442 */         cdmd.setConnectionFactoryInterfaceClass(value);
/* 443 */       else if (localName.equals("connectionfactory-impl-class"))
/* 444 */         cdmd.setConnectionFactoryImplementationClass(value);
/* 445 */       else if (localName.equals("connection-interface"))
/* 446 */         cdmd.setConnectionInterfaceClass(value);
/* 447 */       else if (localName.equals("connection-impl-class")) {
/* 448 */         cdmd.setConnectionImplementationClass(value);
/*     */       }
/* 450 */       else if (localName.equals("reauthentication-support"))
/* 451 */         cdmd.getConnector().setReauthenticationSupport(Boolean.valueOf(value).booleanValue());
/*     */       else
/* 453 */         throw new IllegalArgumentException("Unknown connection definition setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(TransactionSupportMetaData tsmd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 467 */     if (this.trace)
/* 468 */       log.trace("transaction support newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/* 469 */     if (localName.equals("transaction-support"))
/* 470 */       return null;
/* 471 */     throw new IllegalArgumentException("Unknown transaction support newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/*     */   }
/*     */ 
/*     */   public void setValue(TransactionSupportMetaData tsmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 485 */     if (this.trace)
/* 486 */       log.trace("transaction support setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/* 487 */     if ((localName.equals("transaction-support")) && (value.equals("NoTransaction")))
/* 488 */       tsmd.setTransactionSupport(0);
/* 489 */     else if ((localName.equals("transaction-support")) && (value.equals("LocalTransaction")))
/* 490 */       tsmd.setTransactionSupport(1);
/* 491 */     else if ((localName.equals("transaction-support")) && (value.equals("XATransaction")))
/* 492 */       tsmd.setTransactionSupport(2);
/*     */     else
/* 494 */       throw new IllegalArgumentException("Unknown transaction support setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */   }
/*     */ 
/*     */   public Object newChild(AuthenticationMechanismMetaData ammd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 508 */     if (this.trace)
/* 509 */       log.trace("authentication mechanism newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/* 510 */     if ((localName.equals("authentication-mechanism")) || (localName.equals("authentication-mechanism-type")) || (localName.equals("credential-interface")))
/*     */     {
/* 514 */       return null;
/*     */     }
/* 516 */     if (localName.equals("description"))
/*     */     {
/* 518 */       String language = attrs.getValue("xml:lang");
/* 519 */       DescriptionMetaData dmd = null;
/* 520 */       if (language == null)
/* 521 */         dmd = ammd.getDescription();
/*     */       else
/* 523 */         dmd = ammd.getDescription(language);
/* 524 */       if (dmd == null)
/* 525 */         dmd = new DescriptionMetaData(language);
/* 526 */       ammd.addDescription(dmd);
/* 527 */       return dmd;
/*     */     }
/*     */ 
/* 530 */     throw new IllegalArgumentException("Unknown authentication mechanism newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/*     */   }
/*     */ 
/*     */   public void setValue(AuthenticationMechanismMetaData ammd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 544 */     if (this.trace)
/* 545 */       log.trace("authentication mechanism setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/* 546 */     if (!localName.equals("authentication-mechanism"))
/*     */     {
/* 549 */       if (localName.equals("authentication-mechanism-type"))
/* 550 */         ammd.setAuthenticationMechansimType(value);
/* 551 */       else if (localName.equals("credential-interface"))
/* 552 */         ammd.setCredentialInterfaceClass(value);
/*     */       else
/* 554 */         throw new IllegalArgumentException("Unknown authentication mechanism setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(MessageListenerMetaData mlmd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 568 */     if (this.trace)
/* 569 */       log.trace("message listener newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/* 570 */     if ((localName.equals("messagelistener-type")) || (localName.equals("activationspec")) || (localName.equals("activationspec-class")))
/*     */     {
/* 574 */       return null;
/*     */     }
/* 576 */     if (localName.equals("required-config-property"))
/*     */     {
/* 578 */       RequiredConfigPropertyMetaData rcpmd = new RequiredConfigPropertyMetaData();
/* 579 */       mlmd.addRequiredConfigProperty(rcpmd);
/* 580 */       return rcpmd;
/*     */     }
/*     */ 
/* 583 */     throw new IllegalArgumentException("Unknown message listener newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/*     */   }
/*     */ 
/*     */   public void setValue(MessageListenerMetaData mlmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 597 */     if (this.trace)
/* 598 */       log.trace("message listener setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/* 599 */     if ((!localName.equals("messagelistener")) && (!localName.equals("activationspec")))
/*     */     {
/* 603 */       if (localName.equals("messagelistener-type"))
/* 604 */         mlmd.setType(value);
/* 605 */       else if (localName.equals("activationspec-class"))
/* 606 */         mlmd.setActivationSpecType(value);
/*     */       else
/* 608 */         throw new IllegalArgumentException("Unknown mesasge listener setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(AdminObjectMetaData aomd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 622 */     if (this.trace)
/* 623 */       log.trace("admin object newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/* 624 */     if ((localName.equals("adminobject")) || (localName.equals("adminobject-interface")) || (localName.equals("adminobject-class")))
/*     */     {
/* 628 */       return null;
/*     */     }
/* 630 */     if (localName.equals("config-property"))
/*     */     {
/* 632 */       ConfigPropertyMetaData cpmd = new ConfigPropertyMetaData();
/* 633 */       aomd.addProperty(cpmd);
/* 634 */       return cpmd;
/*     */     }
/*     */ 
/* 637 */     throw new IllegalArgumentException("Unknown admin object newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/*     */   }
/*     */ 
/*     */   public void setValue(AdminObjectMetaData aomd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 651 */     if (this.trace)
/* 652 */       log.trace("admin object setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/* 653 */     if (!localName.equals("adminobject"))
/*     */     {
/* 656 */       if (localName.equals("adminobject-interface"))
/* 657 */         aomd.setAdminObjectInterfaceClass(value);
/* 658 */       else if (localName.equals("adminobject-class"))
/* 659 */         aomd.setAdminObjectImplementationClass(value);
/*     */       else
/* 661 */         throw new IllegalArgumentException("Unknown admin object setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(SecurityPermissionMetaData spmd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 675 */     if (this.trace)
/* 676 */       log.trace("security permission newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/* 677 */     if ((localName.equals("security-permission")) || (localName.equals("security-permission-spec")))
/*     */     {
/* 680 */       return null;
/*     */     }
/* 682 */     if (localName.equals("description"))
/*     */     {
/* 684 */       String language = attrs.getValue("xml:lang");
/* 685 */       DescriptionMetaData dmd = null;
/* 686 */       if (language == null)
/* 687 */         dmd = spmd.getDescription();
/*     */       else
/* 689 */         dmd = spmd.getDescription(language);
/* 690 */       if (dmd == null)
/* 691 */         dmd = new DescriptionMetaData(language);
/* 692 */       spmd.addDescription(dmd);
/* 693 */       return dmd;
/*     */     }
/*     */ 
/* 696 */     throw new IllegalArgumentException("Unknown security permission newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/*     */   }
/*     */ 
/*     */   public void setValue(SecurityPermissionMetaData spmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 710 */     if (this.trace)
/* 711 */       log.trace("security permission setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/* 712 */     if (!localName.equals("security-permission"))
/*     */     {
/* 715 */       if (localName.equals("security-permission-spec"))
/* 716 */         spmd.setSecurityPermissionSpec(value);
/*     */       else
/* 718 */         throw new IllegalArgumentException("Unknown security permission setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(RequiredConfigPropertyMetaData rcpmd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 732 */     if (this.trace)
/* 733 */       log.trace("required config property newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/* 734 */     if (localName.equals("config-property-name"))
/*     */     {
/* 736 */       return null;
/*     */     }
/* 738 */     if (localName.equals("description"))
/*     */     {
/* 740 */       String language = attrs.getValue("xml:lang");
/* 741 */       DescriptionMetaData dmd = null;
/* 742 */       if (language == null)
/* 743 */         dmd = rcpmd.getDescription();
/*     */       else
/* 745 */         dmd = rcpmd.getDescription(language);
/* 746 */       if (dmd == null)
/* 747 */         dmd = new DescriptionMetaData(language);
/* 748 */       rcpmd.addDescription(dmd);
/* 749 */       return dmd;
/*     */     }
/*     */ 
/* 752 */     throw new IllegalArgumentException("Unknown required config property newChild: nuri=" + namespaceURI + " localName=" + localName + " attrs=" + attrs);
/*     */   }
/*     */ 
/*     */   public void setValue(RequiredConfigPropertyMetaData rcpmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 766 */     if (this.trace)
/* 767 */       log.trace("required config property setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/* 768 */     if (!localName.equals("required-config-property"))
/*     */     {
/* 771 */       if (localName.equals("config-property-name"))
/* 772 */         rcpmd.setName(value);
/*     */       else
/* 774 */         throw new IllegalArgumentException("Unknown required config property setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 783 */     if (!localName.equals("connector"))
/*     */     {
/* 785 */       throw new IllegalStateException("Unexpected root element: was expecting 'connector' but got '" + localName + "'");
/*     */     }
/*     */ 
/* 788 */     ConnectorMetaData cmd = new ConnectorMetaData();
/* 789 */     String version = attrs.getValue("version");
/* 790 */     if (version != null)
/*     */     {
/* 792 */       cmd.setVersion(version);
/*     */     }
/* 794 */     return cmd;
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name)
/*     */   {
/* 799 */     return root;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployment.ResourceAdapterObjectModelFactory
 * JD-Core Version:    0.6.0
 */