/*     */ package org.jboss.resource.deployers.management;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Type;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.managed.api.Fields;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.api.factory.ManagedObjectFactory;
/*     */ import org.jboss.managed.plugins.ManagedPropertyImpl;
/*     */ import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
/*     */ import org.jboss.managed.spi.factory.InstanceClassFactory;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.types.MetaTypeFactory;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.MetaValueFactory;
/*     */ import org.jboss.resource.metadata.mcf.XAConnectionPropertyMetaData;
/*     */ 
/*     */ public class XAConnectionFactoryProperty extends ManagedPropertyImpl
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private MetaValueFactory metaValueFactory;
/*     */   private ManagedObjectFactory moFactory;
/*     */ 
/*     */   public XAConnectionFactoryProperty(String s)
/*     */   {
/*  61 */     super(s);
/*     */   }
/*     */ 
/*     */   public XAConnectionFactoryProperty(Fields fields)
/*     */   {
/*  66 */     super(fields);
/*     */   }
/*     */ 
/*     */   public XAConnectionFactoryProperty(ManagedObject managedObject, Fields fields)
/*     */   {
/*  71 */     super(managedObject, fields);
/*     */   }
/*     */ 
/*     */   public MetaType getMetaType()
/*     */   {
/*  77 */     return getMapMetaType();
/*     */   }
/*     */ 
/*     */   public void setField(String fieldName, Serializable value)
/*     */   {
/*  82 */     if ("metaType".equals(fieldName))
/*  83 */       value = getMapMetaType();
/*  84 */     super.setField(fieldName, value);
/*     */   }
/*     */ 
/*     */   public void setValue(Serializable value)
/*     */   {
/*  95 */     super.setValue(value);
/*     */ 
/*  97 */     PropertyInfo propertyInfo = (PropertyInfo)getField("propertyInfo", PropertyInfo.class);
/*  98 */     if (propertyInfo != null)
/*     */     {
/* 100 */       Serializable attachment = getManagedObject().getAttachment();
/* 101 */       if (attachment != null)
/*     */       {
/*     */         MetaValue metaValue;
/*     */         MetaValue metaValue;
/* 104 */         if ((value instanceof MetaValue))
/*     */         {
/* 106 */           Map map = (Map)getMetaValueFactory().unwrap((MetaValue)value, getMapType());
/* 107 */           List list = new ArrayList();
/* 108 */           for (String name : map.keySet())
/*     */           {
/* 110 */             String entry = (String)map.get(name);
/* 111 */             XAConnectionPropertyMetaData prop = new XAConnectionPropertyMetaData();
/* 112 */             prop.setName(name);
/* 113 */             prop.setValue(entry);
/* 114 */             list.add(prop);
/*     */           }
/* 116 */           metaValue = getMetaValueFactory().create(list, propertyInfo.getType());
/*     */         }
/*     */         else
/*     */         {
/* 120 */           metaValue = getMetaValueFactory().create(value);
/*     */         }
/*     */ 
/* 123 */         InstanceClassFactory icf = getMOFactory().getInstanceClassFactory(attachment.getClass());
/* 124 */         BeanInfo beanInfo = propertyInfo.getBeanInfo();
/* 125 */         icf.setValue(beanInfo, this, attachment, metaValue);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private ManagedObjectFactory getMOFactory()
/*     */   {
/* 132 */     if (this.moFactory == null)
/* 133 */       this.moFactory = ManagedObjectFactoryBuilder.create();
/* 134 */     return this.moFactory;
/*     */   }
/*     */ 
/*     */   private MetaValueFactory getMetaValueFactory()
/*     */   {
/* 139 */     if (this.metaValueFactory == null)
/* 140 */       this.metaValueFactory = MetaValueFactory.getInstance();
/* 141 */     return this.metaValueFactory;
/*     */   }
/*     */ 
/*     */   private Object writeReplace()
/*     */     throws ObjectStreamException
/*     */   {
/* 152 */     ManagedPropertyImpl managedProperty = new ManagedPropertyImpl(getManagedObject(), getFields());
/* 153 */     managedProperty.setTargetManagedObject(getTargetManagedObject());
/* 154 */     return managedProperty;
/*     */   }
/*     */ 
/*     */   private MetaType getMapMetaType()
/*     */   {
/* 159 */     Type type = getMapType();
/* 160 */     return MetaTypeFactory.getInstance().resolve(type);
/*     */   }
/*     */ 
/*     */   private Type getMapType()
/*     */   {
/*     */     Type type;
/*     */     try {
/* 168 */       type = getClass().getMethod("mapOfStrings", new Class[0]).getGenericReturnType();
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 172 */       throw new IllegalStateException("Failed to find compoditeValueMap method.");
/*     */     }
/* 174 */     return type;
/*     */   }
/*     */ 
/*     */   public Map<String, String> mapOfStrings()
/*     */   {
/* 179 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.management.XAConnectionFactoryProperty
 * JD-Core Version:    0.6.0
 */