/*     */ package org.jboss.resource.deployers.management;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Map;
/*     */ import org.jboss.managed.api.Fields;
/*     */ import org.jboss.managed.plugins.DefaultFieldsImpl;
/*     */ import org.jboss.managed.plugins.ManagedObjectImpl;
/*     */ import org.jboss.managed.plugins.ManagedPropertyImpl;
/*     */ import org.jboss.metatype.api.types.CompositeMetaType;
/*     */ import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.types.SimpleMetaType;
/*     */ import org.jboss.metatype.api.values.SimpleValueSupport;
/*     */ import org.jboss.profileservice.management.plugins.BasicDeploymentTemplateInfo;
/*     */ 
/*     */ public class ConnectionFactoryTemplateInfo extends BasicDeploymentTemplateInfo
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private Map<String, String> propertyNameMappings;
/*     */   private String attachmentName;
/*     */   private String dsTypeAttachmentName;
/*     */ 
/*     */   public ConnectionFactoryTemplateInfo(String name, String description, String attachmentName)
/*     */   {
/*  65 */     this(name, description, attachmentName, attachmentName);
/*     */   }
/*     */ 
/*     */   public ConnectionFactoryTemplateInfo(String name, String description, String attachmentName, String dsTypeAttachmentName)
/*     */   {
/*  70 */     super(name, description);
/*  71 */     this.attachmentName = attachmentName;
/*  72 */     this.dsTypeAttachmentName = dsTypeAttachmentName;
/*     */   }
/*     */ 
/*     */   public Map<String, String> getPropertyNameMappings()
/*     */   {
/*  77 */     return this.propertyNameMappings;
/*     */   }
/*     */ 
/*     */   public void setPropertyNameMappings(Map<String, String> propertyNameMappings) {
/*  81 */     this.propertyNameMappings = propertyNameMappings;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  86 */     ManagedObjectImpl mo = new ManagedObjectImpl(this.attachmentName);
/*     */ 
/*  88 */     DefaultFieldsImpl f0 = new DefaultFieldsImpl();
/*  89 */     setFieldName("jndi-name", f0);
/*  90 */     f0.setDescription("The jndi name to bind the DataSource under");
/*  91 */     f0.setMandatory(true);
/*  92 */     f0.setMetaType(SimpleMetaType.STRING);
/*  93 */     ManagedPropertyImpl jndiName = new ManagedPropertyImpl(mo, f0);
/*  94 */     super.addProperty(jndiName);
/*     */ 
/*  96 */     DefaultFieldsImpl f1 = new DefaultFieldsImpl();
/*  97 */     setFieldName("connection-url", f1);
/*  98 */     f1.setDescription("The jdbc url of the DataSource");
/*  99 */     f1.setMandatory(true);
/* 100 */     f1.setMetaType(SimpleMetaType.STRING);
/* 101 */     ManagedPropertyImpl conURL = new ManagedPropertyImpl(mo, f1);
/* 102 */     super.addProperty(conURL);
/*     */ 
/* 104 */     DefaultFieldsImpl f2 = new DefaultFieldsImpl();
/* 105 */     setFieldName("user-name", f2);
/* 106 */     f2.setDescription("The username for the connection-url");
/* 107 */     f2.setMandatory(false);
/* 108 */     f2.setMetaType(SimpleMetaType.STRING);
/* 109 */     ManagedPropertyImpl user = new ManagedPropertyImpl(mo, f2);
/* 110 */     super.addProperty(user);
/*     */ 
/* 112 */     DefaultFieldsImpl f3 = new DefaultFieldsImpl();
/* 113 */     setFieldName("password", f3);
/* 114 */     f3.setDescription("The password for the connection-url");
/* 115 */     f3.setMandatory(false);
/* 116 */     f3.setMetaType(SimpleMetaType.STRING);
/* 117 */     ManagedPropertyImpl password = new ManagedPropertyImpl(mo, f3);
/* 118 */     super.addProperty(password);
/*     */ 
/* 120 */     DefaultFieldsImpl f4 = new DefaultFieldsImpl();
/* 121 */     setFieldName("security-domain", f4);
/* 122 */     f4.setDescription("The security-domain used to validate connections");
/* 123 */     f4.setMandatory(false);
/* 124 */     f4.setMetaType(SimpleMetaType.STRING);
/* 125 */     ManagedPropertyImpl secDomain = new ManagedPropertyImpl(mo, f4);
/* 126 */     super.addProperty(secDomain);
/*     */ 
/* 128 */     DefaultFieldsImpl f5 = new DefaultFieldsImpl();
/* 129 */     setFieldName("driver-class", f5);
/* 130 */     f5.setDescription("The jdbc driver class name");
/* 131 */     f5.setMandatory(true);
/* 132 */     f5.setMetaType(SimpleMetaType.STRING);
/* 133 */     ManagedPropertyImpl driverClass = new ManagedPropertyImpl(mo, f5);
/* 134 */     super.addProperty(driverClass);
/*     */ 
/* 136 */     DefaultFieldsImpl f6 = new DefaultFieldsImpl();
/* 137 */     setFieldName("connection-properties", f6);
/* 138 */     f6.setDescription("The jdbc driver connection properties");
/* 139 */     f6.setMandatory(false);
/* 140 */     String[] itemNames = { "conn-prop1", "conn-prop2" };
/* 141 */     String[] itemDescriptions = { "conn-prop1 description", "conn-prop2 description" };
/* 142 */     MetaType[] itemTypes = { SimpleMetaType.STRING, SimpleMetaType.STRING };
/* 143 */     CompositeMetaType propsType = new ImmutableCompositeMetaType("java.lang.Properties", "DS connection properties", itemNames, itemDescriptions, itemTypes);
/*     */ 
/* 145 */     f6.setMetaType(propsType);
/* 146 */     ManagedPropertyImpl connProps = new ManagedPropertyImpl(mo, f6);
/* 147 */     super.addProperty(connProps);
/*     */ 
/* 150 */     ManagedObjectImpl mo2 = new ManagedObjectImpl(this.dsTypeAttachmentName);
/* 151 */     DefaultFieldsImpl f21 = new DefaultFieldsImpl();
/* 152 */     setFieldName("datasource-type", f21);
/* 153 */     f21.setDescription("The type of the ConnectionFactory");
/* 154 */     f21.setMandatory(true);
/* 155 */     f21.setValue("local-tx-datasource");
/* 156 */     HashSet values = new HashSet();
/* 157 */     values.add(SimpleValueSupport.wrap("local-tx-datasource"));
/* 158 */     values.add(SimpleValueSupport.wrap("no-tx-datasource"));
/* 159 */     values.add(SimpleValueSupport.wrap("xa-datasource"));
/* 160 */     f21.setLegalValues(values);
/* 161 */     f21.setMetaType(SimpleMetaType.STRING);
/* 162 */     ManagedPropertyImpl dsType = new ManagedPropertyImpl(mo2, f21);
/* 163 */     super.addProperty(dsType);
/*     */   }
/*     */ 
/*     */   protected void setFieldName(String name, Fields f)
/*     */   {
/* 168 */     f.setField("name", name);
/* 169 */     if (this.propertyNameMappings != null)
/*     */     {
/* 171 */       String mappedName = (String)this.propertyNameMappings.get(name);
/* 172 */       if (mappedName != null)
/* 173 */         f.setField("mappedName", mappedName);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.management.ConnectionFactoryTemplateInfo
 * JD-Core Version:    0.6.0
 */