/*     */ package org.jboss.resource.deployers.management;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Type;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.managed.api.Fields;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.api.factory.ManagedObjectFactory;
/*     */ import org.jboss.managed.plugins.ManagedPropertyImpl;
/*     */ import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
/*     */ import org.jboss.managed.spi.factory.InstanceClassFactory;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.types.MetaTypeFactory;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.MetaValueFactory;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryPropertyMetaData;
/*     */ 
/*     */ public class ConnectionFactoryProperty extends ManagedPropertyImpl
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private MetaValueFactory metaValueFactory;
/*     */   private ManagedObjectFactory moFactory;
/*     */ 
/*     */   public ConnectionFactoryProperty(String s)
/*     */   {
/*  56 */     super(s);
/*     */   }
/*     */ 
/*     */   public ConnectionFactoryProperty(Fields fields)
/*     */   {
/*  61 */     super(fields);
/*     */   }
/*     */ 
/*     */   public ConnectionFactoryProperty(ManagedObject managedObject, Fields fields)
/*     */   {
/*  66 */     super(managedObject, fields);
/*     */   }
/*     */ 
/*     */   public MetaType getMetaType()
/*     */   {
/*  72 */     return getMapMetaType();
/*     */   }
/*     */ 
/*     */   public void setField(String fieldName, Serializable value)
/*     */   {
/*  77 */     if ("metaType".equals(fieldName))
/*  78 */       value = getMapMetaType();
/*  79 */     super.setField(fieldName, value);
/*     */   }
/*     */ 
/*     */   public void setValue(Serializable value)
/*     */   {
/*  90 */     super.setValue(value);
/*     */ 
/*  92 */     PropertyInfo propertyInfo = (PropertyInfo)getField("propertyInfo", PropertyInfo.class);
/*  93 */     if (propertyInfo != null)
/*     */     {
/*  95 */       Serializable attachment = getManagedObject().getAttachment();
/*  96 */       if (attachment != null)
/*     */       {
/*     */         MetaValue metaValue;
/*     */         MetaValue metaValue;
/*  99 */         if ((value instanceof MetaValue))
/*     */         {
/* 101 */           Map map = (Map)getMetaValueFactory().unwrap((MetaValue)value, getMapType());
/* 102 */           List list = new ArrayList();
/* 103 */           for (String name : map.keySet())
/*     */           {
/* 105 */             Map entry = (Map)map.get(name);
/* 106 */             ManagedConnectionFactoryPropertyMetaData prop = new ManagedConnectionFactoryPropertyMetaData();
/* 107 */             prop.setName((String)entry.get("name"));
/* 108 */             prop.setType((String)entry.get("type"));
/* 109 */             prop.setValue((String)entry.get("value"));
/* 110 */             list.add(prop);
/*     */           }
/* 112 */           metaValue = getMetaValueFactory().create(list, propertyInfo.getType());
/*     */         }
/*     */         else
/*     */         {
/* 116 */           metaValue = getMetaValueFactory().create(value);
/*     */         }
/*     */ 
/* 119 */         InstanceClassFactory icf = getMOFactory().getInstanceClassFactory(attachment.getClass());
/* 120 */         BeanInfo beanInfo = propertyInfo.getBeanInfo();
/* 121 */         icf.setValue(beanInfo, this, attachment, metaValue);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private ManagedObjectFactory getMOFactory()
/*     */   {
/* 128 */     if (this.moFactory == null)
/* 129 */       this.moFactory = ManagedObjectFactoryBuilder.create();
/* 130 */     return this.moFactory;
/*     */   }
/*     */ 
/*     */   private MetaValueFactory getMetaValueFactory()
/*     */   {
/* 135 */     if (this.metaValueFactory == null)
/* 136 */       this.metaValueFactory = MetaValueFactory.getInstance();
/* 137 */     return this.metaValueFactory;
/*     */   }
/*     */ 
/*     */   public Serializable getValue()
/*     */   {
/* 142 */     Object o = super.getValue();
/* 143 */     return (Serializable)o;
/*     */   }
/*     */ 
/*     */   private Object writeReplace()
/*     */     throws ObjectStreamException
/*     */   {
/* 154 */     ManagedPropertyImpl managedProperty = new ManagedPropertyImpl(getManagedObject(), getFields());
/* 155 */     managedProperty.setTargetManagedObject(getTargetManagedObject());
/* 156 */     return managedProperty;
/*     */   }
/*     */ 
/*     */   private MetaType getMapMetaType()
/*     */   {
/* 161 */     Type type = getMapType();
/* 162 */     return MetaTypeFactory.getInstance().resolve(type);
/*     */   }
/*     */ 
/*     */   private Type getMapType()
/*     */   {
/*     */     Type type;
/*     */     try {
/* 170 */       type = getClass().getMethod("compositeValueMap", new Class[0]).getGenericReturnType();
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 174 */       throw new IllegalStateException("Failed to find compoditeValueMap method.");
/*     */     }
/* 176 */     return type;
/*     */   }
/*     */ 
/*     */   public Map<String, Map<String, String>> compositeValueMap()
/*     */   {
/* 181 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.management.ConnectionFactoryProperty
 * JD-Core Version:    0.6.0
 */