/*     */ package org.jboss.resource.deployers.builder;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.resource.metadata.mcf.DBMSMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ 
/*     */ public class MetaDataTypeMappingBuilder extends AbstractBuilder
/*     */ {
/*     */   private static final String BINDING_JMX = "jboss.jdbc:service=metadata,datasource=";
/*     */   private static final String BINDING = "org.jboss.ejb.plugins.cmp.jdbc.metadata.DataSourceMetaData";
/*     */ 
/*     */   public List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/*  49 */     List attributes = new ArrayList();
/*  50 */     ServiceAttributeMetaData attribute = null;
/*     */ 
/*  52 */     attribute = buildDependencyAttribute("MetadataLibrary", "jboss.jdbc:service=metadata");
/*  53 */     attributes.add(attribute);
/*     */ 
/*  55 */     String typeMapping = null;
/*     */ 
/*  57 */     if (md.getDBMSMetaData() != null)
/*     */     {
/*  59 */       if (md.getDBMSMetaData().getTypeMapping() != null)
/*     */       {
/*  61 */         typeMapping = md.getDBMSMetaData().getTypeMapping();
/*     */       }
/*     */     }
/*  64 */     else if (md.getTypeMapping() != null)
/*     */     {
/*  66 */       typeMapping = md.getTypeMapping();
/*     */     }
/*     */ 
/*  70 */     attribute = buildSimpleAttribute("TypeMapping", typeMapping);
/*  71 */     attributes.add(attribute);
/*     */ 
/*  73 */     return attributes;
/*     */   }
/*     */ 
/*     */   public ServiceMetaData build(ManagedConnectionFactoryDeploymentMetaData mcfmd)
/*     */   {
/*  79 */     ServiceMetaData md = null;
/*     */ 
/*  81 */     if ((mcfmd.getTypeMapping() != null) || (mcfmd.getDBMSMetaData() != null))
/*     */     {
/*  83 */       md = super.build(mcfmd);
/*     */     }
/*     */ 
/*  87 */     return md;
/*     */   }
/*     */ 
/*     */   public ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/*  94 */     ObjectName on = null;
/*     */ 
/*  96 */     if ((md.getTypeMapping() != null) || (md.getDBMSMetaData() != null))
/*     */     {
/*  98 */       on = ObjectNameFactory.create("jboss.jdbc:service=metadata,datasource=" + md.getJndiName());
/*     */     }
/*     */ 
/* 102 */     return on;
/*     */   }
/*     */ 
/*     */   public String getCode(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/* 108 */     return "org.jboss.ejb.plugins.cmp.jdbc.metadata.DataSourceMetaData";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.builder.MetaDataTypeMappingBuilder
 * JD-Core Version:    0.6.0
 */