/*     */ package org.jboss.resource.deployers.builder;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.resource.connectionmanager.NoTxConnectionManager;
/*     */ import org.jboss.resource.connectionmanager.TxConnectionManager;
/*     */ import org.jboss.resource.metadata.mcf.DataSourceDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryTransactionSupportMetaData;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ 
/*     */ public class ConnectionManagerBuilder extends AbstractBuilder
/*     */ {
/*     */   private static final String CCM_JMX = "jboss.jca:service=CachedConnectionManager";
/*     */   private static final String JAAS_JMX = "jboss.security:service=JaasSecurityManager";
/*     */   private static final String TM_JMX = "jboss:service=TransactionManager";
/*     */   private static final String POOL_JMX = "jboss.jca:service=ManagedConnectionPool,name=";
/*     */ 
/*     */   public List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/*  53 */     List attributes = new ArrayList();
/*  54 */     ServiceAttributeMetaData attribute = null;
/*     */ 
/*  56 */     attribute = buildSimpleAttribute("JndiName", md.getJndiName());
/*  57 */     attributes.add(attribute);
/*     */ 
/*  59 */     attribute = buildDependencyAttribute("CachedConnectionManager", "jboss.jca:service=CachedConnectionManager");
/*  60 */     attributes.add(attribute);
/*     */ 
/*  62 */     attribute = buildDependencyAttribute("JaasSecurityManagerService", "jboss.security:service=JaasSecurityManager");
/*  63 */     attributes.add(attribute);
/*     */ 
/*  65 */     attribute = buildDependencyAttribute("ManagedConnectionPool", "jboss.jca:service=ManagedConnectionPool,name=" + md.getJndiName());
/*  66 */     attributes.add(attribute);
/*     */ 
/*  68 */     if (!md.getTransactionSupportMetaData().equals(ManagedConnectionFactoryTransactionSupportMetaData.NONE)) {
/*  70 */       attribute = buildDependencyAttribute("TransactionManagerService", "jboss:service=TransactionManager");
/*  71 */       attributes.add(attribute);
/*     */ 
/*  73 */       attribute = buildSimpleAttribute("LocalTransactions", String.valueOf(md.getLocalTransactions()));
/*  74 */       attributes.add(attribute);
/*     */ 
/*  76 */       attribute = buildSimpleAttribute("TrackConnectionByTx", String.valueOf(md.getTrackConnectionByTransaction()));
/*  77 */       attributes.add(attribute);
/*     */ 
/*  79 */       if (!md.getTransactionSupportMetaData().equals(ManagedConnectionFactoryTransactionSupportMetaData.XA));
/*  86 */     }return attributes;
/*     */   }
/*     */ 
/*     */   public ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/*  92 */     String cmType = "jboss.jca:service=";
/*  93 */     String jndiName = md.getJndiName();
/*     */ 
/*  95 */     if (md.getTransactionSupportMetaData().equals(ManagedConnectionFactoryTransactionSupportMetaData.NONE))
/*     */     {
/*  97 */       cmType = cmType + "NoTxCM,name=" + jndiName;
/*     */     }
/* 100 */     else if (md.getTransactionSupportMetaData().equals(ManagedConnectionFactoryTransactionSupportMetaData.LOCAL))
/*     */     {
/* 102 */       if ((md instanceof DataSourceDeploymentMetaData))
/*     */       {
/* 104 */         cmType = cmType + "LocalTxCM,name=" + jndiName;
/*     */       }
/*     */       else
/*     */       {
/* 108 */         cmType = cmType + "TxCM,name=" + jndiName;
/*     */       }
/*     */ 
/*     */     }
/* 114 */     else if ((md instanceof DataSourceDeploymentMetaData))
/*     */     {
/* 116 */       cmType = cmType + "XATxCM,name=" + jndiName;
/*     */     }
/*     */     else
/*     */     {
/* 121 */       cmType = cmType + "TxCM,name=" + jndiName;
/*     */     }
/*     */ 
/* 126 */     return ObjectNameFactory.create(cmType);
/*     */   }
/*     */ 
/*     */   public String getCode(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/* 133 */     String code = null;
/*     */ 
/* 135 */     if (md.getTransactionSupportMetaData().equals(ManagedConnectionFactoryTransactionSupportMetaData.NONE))
/*     */     {
/* 137 */       code = NoTxConnectionManager.class.getName();
/*     */     }
/*     */     else
/*     */     {
/* 141 */       code = TxConnectionManager.class.getName();
/*     */     }
/*     */ 
/* 144 */     return code;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.builder.ConnectionManagerBuilder
 * JD-Core Version:    0.6.0
 */