/*     */ package org.jboss.resource.deployers;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Timer;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.resource.spi.ActivationSpec;
/*     */ import javax.resource.spi.BootstrapContext;
/*     */ import javax.resource.spi.ResourceAdapter;
/*     */ import javax.resource.spi.UnavailableException;
/*     */ import javax.resource.spi.XATerminator;
/*     */ import javax.resource.spi.endpoint.MessageEndpointFactory;
/*     */ import javax.resource.spi.work.WorkManager;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.deployment.ActivationSpecFactory;
/*     */ import org.jboss.resource.deployment.ResourceAdapterFactory;
/*     */ import org.jboss.resource.metadata.AuthenticationMechanismMetaData;
/*     */ import org.jboss.resource.metadata.ConfigPropertyMetaData;
/*     */ import org.jboss.resource.metadata.ConnectorMetaData;
/*     */ import org.jboss.resource.metadata.DescriptionGroupMetaData;
/*     */ import org.jboss.resource.metadata.DescriptionMetaData;
/*     */ import org.jboss.resource.metadata.LicenseMetaData;
/*     */ import org.jboss.resource.metadata.MessageListenerMetaData;
/*     */ import org.jboss.system.ServiceDynamicMBeanSupport;
/*     */ import org.jboss.system.server.ServerConfigUtil;
/*     */ 
/*     */ public class RARDeployment extends ServiceDynamicMBeanSupport
/*     */   implements BootstrapContext
/*     */ {
/*     */   protected ConnectorMetaData cmd;
/*     */   protected ResourceAdapter resourceAdapter;
/*     */   private WorkManager workManager;
/*     */   private XATerminator xaTerminator;
/*     */ 
/*     */   public RARDeployment(ConnectorMetaData cmd)
/*     */   {
/*  88 */     if (cmd == null)
/*  89 */       throw new IllegalArgumentException("Null metadata");
/*  90 */     this.cmd = cmd;
/*     */   }
/*     */ 
/*     */   public Timer createTimer()
/*     */     throws UnavailableException
/*     */   {
/*  97 */     return new Timer(true);
/*     */   }
/*     */ 
/*     */   public WorkManager getWorkManager()
/*     */   {
/* 107 */     return this.workManager;
/*     */   }
/*     */ 
/*     */   public void setWorkManager(WorkManager workManager)
/*     */   {
/* 117 */     this.workManager = workManager;
/*     */   }
/*     */ 
/*     */   public XATerminator getXATerminator()
/*     */   {
/* 127 */     return this.xaTerminator;
/*     */   }
/*     */ 
/*     */   public void setXATerminator(XATerminator xaTerminator)
/*     */   {
/* 137 */     this.xaTerminator = xaTerminator;
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/* 142 */     URL url = this.cmd.getURL();
/*     */ 
/* 144 */     if (this.cmd.getLicense().getRequired())
/*     */     {
/* 146 */       this.log.info("Required license terms exist, view " + ServerConfigUtil.shortUrlFromServerHome(url.toString()));
/* 147 */       this.log.debug("License terms full URL: " + url);
/*     */     }
/* 149 */     this.resourceAdapter = ResourceAdapterFactory.createResourceAdapter(this.cmd);
/* 150 */     this.resourceAdapter.start(this);
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 155 */     this.resourceAdapter.stop();
/*     */   }
/*     */ 
/*     */   protected String getInternalDescription()
/*     */   {
/* 160 */     String description = null;
/* 161 */     DescriptionGroupMetaData dgmd = this.cmd.getDescription();
/* 162 */     if (dgmd != null)
/* 163 */       description = dgmd.getDescription();
/* 164 */     if (description == null)
/* 165 */       description = "RAR Deployment " + this.cmd.getURL();
/* 166 */     return description;
/*     */   }
/*     */ 
/*     */   protected MBeanAttributeInfo[] getInternalAttributeInfo()
/*     */   {
/* 171 */     Collection properties = this.cmd.getProperties();
/* 172 */     MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[13 + properties.size()];
/* 173 */     attrs[0] = new MBeanAttributeInfo("MetaData", ConnectorMetaData.class.getName(), "The meta data", true, false, false);
/* 174 */     attrs[1] = new MBeanAttributeInfo("AuthenticationMechanism", String.class.getName(), "The authentication mechanism", true, false, false);
/* 175 */     attrs[2] = new MBeanAttributeInfo("EISType", String.class.getName(), "The EIS type", true, false, false);
/* 176 */     attrs[3] = new MBeanAttributeInfo("License", String.class.getName(), "The license", true, false, false);
/* 177 */     attrs[4] = new MBeanAttributeInfo("RAClass", String.class.getName(), "The resource adapter class", true, false, false);
/* 178 */     attrs[5] = new MBeanAttributeInfo("RAVersion", String.class.getName(), "The resource adapter version", true, false, false);
/* 179 */     attrs[6] = new MBeanAttributeInfo("TransactionSupport", String.class.getName(), "The transaction support", true, false, false);
/* 180 */     attrs[7] = new MBeanAttributeInfo("VendorName", String.class.getName(), "The vendor name", true, false, false);
/* 181 */     attrs[8] = new MBeanAttributeInfo("Version", String.class.getName(), "The spec version", true, false, false);
/* 182 */     attrs[9] = new MBeanAttributeInfo("ReauthenticationSupport", Boolean.TYPE.getName(), "Whether reauthentication support is supported", true, false, false);
/* 183 */     attrs[10] = new MBeanAttributeInfo("ResourceAdapter", ResourceAdapter.class.getName(), "The resource adapter instance", true, false, false);
/* 184 */     attrs[11] = new MBeanAttributeInfo("WorkManager", WorkManager.class.getName(), "The work manager", true, true, false);
/* 185 */     attrs[12] = new MBeanAttributeInfo("XATerminator", XATerminator.class.getName(), "The xa terminator", true, true, false);
/* 186 */     int n = 13;
/* 187 */     for (Iterator i = properties.iterator(); i.hasNext(); )
/*     */     {
/* 189 */       ConfigPropertyMetaData cpmd = (ConfigPropertyMetaData)i.next();
/* 190 */       attrs[(n++)] = new MBeanAttributeInfo(cpmd.getName(), cpmd.getType(), cpmd.getDescription().getDescription(), true, false, false);
/*     */     }
/* 192 */     return attrs;
/*     */   }
/*     */ 
/*     */   protected Object getInternalAttribute(String attribute)
/*     */     throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 198 */     if ("MetaData".equals(attribute))
/* 199 */       return this.cmd;
/* 200 */     if ("AuthenticationMechanism".equals(attribute))
/* 201 */       return this.cmd.getAuthenticationMechanism().getAuthenticationMechansimType();
/* 202 */     if ("EISType".equals(attribute))
/* 203 */       return this.cmd.getEISType();
/* 204 */     if ("License".equals(attribute))
/* 205 */       return this.cmd.getLicense().getDescription().getDescription();
/* 206 */     if ("RAClass".equals(attribute))
/* 207 */       return this.cmd.getRAClass();
/* 208 */     if ("RAVersion".equals(attribute))
/* 209 */       return this.cmd.getRAVersion();
/* 210 */     if ("TransactionSupport".equals(attribute))
/* 211 */       return this.cmd.getTransactionSupport();
/* 212 */     if ("VendorName".equals(attribute))
/* 213 */       return this.cmd.getVendorName();
/* 214 */     if ("Version".equals(attribute))
/* 215 */       return this.cmd.getVersion();
/* 216 */     if ("ReauthenticationSupport".equals(attribute))
/* 217 */       return new Boolean(this.cmd.getReauthenticationSupport());
/* 218 */     if ("ResourceAdapter".equals(attribute))
/* 219 */       return this.resourceAdapter;
/* 220 */     if ("WorkManager".equals(attribute))
/* 221 */       return this.workManager;
/* 222 */     if ("XATerminator".equals(attribute))
/* 223 */       return this.xaTerminator;
/* 224 */     Object property = this.cmd.getProperty(attribute);
/* 225 */     if (property != null) {
/* 226 */       return property;
/*     */     }
/* 228 */     return super.getInternalAttribute(attribute);
/*     */   }
/*     */ 
/*     */   protected void setInternalAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/* 233 */     String name = attribute.getName();
/* 234 */     if ("WorkManager".equals(name))
/* 235 */       this.workManager = ((WorkManager)attribute.getValue());
/* 236 */     else if ("XATerminator".equals(name))
/* 237 */       this.xaTerminator = ((XATerminator)attribute.getValue());
/*     */     else
/* 239 */       super.setInternalAttribute(attribute);
/*     */   }
/*     */ 
/*     */   protected MBeanOperationInfo[] getInternalOperationInfo()
/*     */   {
/* 244 */     MBeanOperationInfo[] ops = new MBeanOperationInfo[3];
/*     */ 
/* 246 */     MBeanParameterInfo[] createActivationSpecParams = { new MBeanParameterInfo("MessagingType", Class.class.getName(), "The type of the message listener"), new MBeanParameterInfo("ActivationConfig", Collection.class.getName(), "A collection of activation config properties") };
/*     */ 
/* 251 */     ops[0] = new MBeanOperationInfo("createActivationSpec", "Create an activation spec", createActivationSpecParams, ActivationSpec.class.getName(), 1);
/*     */ 
/* 254 */     MBeanParameterInfo[] activationParams = { new MBeanParameterInfo("MessageEndpointFactory", MessageEndpointFactory.class.getName(), "The message endpoint factory"), new MBeanParameterInfo("ActivationSpec", ActivationSpec.class.getName(), "The activation spec") };
/*     */ 
/* 259 */     ops[1] = new MBeanOperationInfo("endpointActivation", "Active the endpoint", activationParams, Void.class.getName(), 1);
/*     */ 
/* 261 */     ops[2] = new MBeanOperationInfo("endpointDeactivation", "Deactive the endpoint", activationParams, Void.class.getName(), 1);
/*     */ 
/* 264 */     return ops;
/*     */   }
/*     */ 
/*     */   protected Object internalInvoke(String actionName, Object[] params, String[] signature)
/*     */     throws MBeanException, ReflectionException
/*     */   {
/* 270 */     if ("createActivationSpec".equals(actionName))
/*     */     {
/* 272 */       if (params.length != 2)
/* 273 */         throw new IllegalArgumentException("Wrong number of parameters for " + actionName);
/* 274 */       Class messagingType = (Class)params[0];
/* 275 */       Collection activationConfig = (Collection)params[1];
/* 276 */       return createActivationSpec(messagingType, activationConfig);
/*     */     }
/* 278 */     if ("endpointActivation".equals(actionName))
/*     */     {
/* 280 */       if (params.length != 2)
/* 281 */         throw new IllegalArgumentException("Wrong number of parameters for " + actionName);
/* 282 */       MessageEndpointFactory messageEndpointFactory = (MessageEndpointFactory)params[0];
/* 283 */       ActivationSpec activationSpec = (ActivationSpec)params[1];
/* 284 */       endpointActivation(messageEndpointFactory, activationSpec);
/* 285 */       return null;
/*     */     }
/* 287 */     if ("endpointDeactivation".equals(actionName))
/*     */     {
/* 289 */       if (params.length != 2)
/* 290 */         throw new IllegalArgumentException("Wrong number of parameters for " + actionName);
/* 291 */       MessageEndpointFactory messageEndpointFactory = (MessageEndpointFactory)params[0];
/* 292 */       ActivationSpec activationSpec = (ActivationSpec)params[1];
/* 293 */       endpointDeactivation(messageEndpointFactory, activationSpec);
/* 294 */       return null;
/*     */     }
/* 296 */     return super.internalInvoke(actionName, params, signature);
/*     */   }
/*     */ 
/*     */   protected ActivationSpec createActivationSpec(Class messagingType, Collection activationConfig) throws MBeanException
/*     */   {
/* 301 */     boolean trace = this.log.isTraceEnabled();
/* 302 */     if (trace) {
/* 303 */       this.log.trace("CreateActivateSpec rar=" + getServiceName() + " messagingType=" + messagingType.getName() + " activationConfig=" + activationConfig);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 308 */       MessageListenerMetaData mlmd = this.cmd.getMessageListener(messagingType.getName());
/* 309 */       if (mlmd == null) {
/* 310 */         throw new DeploymentException("MessagingType '" + messagingType.getName() + "' not found in resource deployment " + getServiceName());
/*     */       }
/* 312 */       return ActivationSpecFactory.createActivationSpec(getServiceName(), messagingType.getName(), activationConfig, mlmd);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 316 */     throw new MBeanException(e, "Error in create activation spec " + getServiceName());
/*     */   }
/*     */ 
/*     */   protected void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec)
/*     */     throws MBeanException
/*     */   {
/* 322 */     boolean trace = this.log.isTraceEnabled();
/* 323 */     if (trace) {
/* 324 */       this.log.trace("EndpointActivation rar=" + getServiceName() + " messagingEndpointFactory=" + messageEndpointFactory + " activationSpec=" + activationSpec);
/*     */     }
/*     */     try
/*     */     {
/* 328 */       activationSpec.setResourceAdapter(this.resourceAdapter);
/* 329 */       this.resourceAdapter.endpointActivation(messageEndpointFactory, activationSpec);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 333 */       throw new MBeanException(e, "Error in endpoint activation " + getServiceName());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws MBeanException
/*     */   {
/* 339 */     boolean trace = this.log.isTraceEnabled();
/* 340 */     if (trace) {
/* 341 */       this.log.trace("EndpointDeactivation rar=" + getServiceName() + " messagingEndpointFactory=" + messageEndpointFactory + " activationSpec=" + activationSpec);
/*     */     }
/*     */     try
/*     */     {
/* 345 */       this.resourceAdapter.endpointDeactivation(messageEndpointFactory, activationSpec);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 349 */       throw new MBeanException(e, "Error in endpoint deactivation " + getServiceName());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.RARDeployment
 * JD-Core Version:    0.6.0
 */