/*     */ package org.jboss.resource.deployers;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.util.Map;
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.bind.JAXBElement;
/*     */ import javax.xml.bind.Unmarshaller;
/*     */ import javax.xml.transform.stream.StreamSource;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.api.factory.ManagedObjectFactory;
/*     */ import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
/*     */ import org.jboss.resource.deployers.management.XADataSourceDeploymentMetaDataBuilder;
/*     */ import org.jboss.resource.metadata.mcf.LocalDataSourceDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.NoTxDataSourceDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.TxConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.repository.JCAMetaDataRepository;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class ManagedConnectionFactoryParserDeployer extends AbstractVFSParsingDeployer<ManagedConnectionFactoryDeploymentGroup>
/*     */ {
/*     */   private JAXBContext context;
/*     */   private JCAMetaDataRepository repository;
/*     */   private ManagedObjectFactory moFactory;
/*     */ 
/*     */   public ManagedConnectionFactoryParserDeployer()
/*     */   {
/*  73 */     super(ManagedConnectionFactoryDeploymentGroup.class);
/*  74 */     setIncludeDeploymentFile(true);
/*  75 */     setBuildManagedObject(true);
/*     */ 
/*  77 */     this.moFactory = ManagedObjectFactoryBuilder.create();
/*  78 */     XADataSourceDeploymentMetaDataBuilder builder = new XADataSourceDeploymentMetaDataBuilder();
/*  79 */     this.moFactory.setBuilder(LocalDataSourceDeploymentMetaData.class, builder);
/*  80 */     this.moFactory.setBuilder(XADataSourceDeploymentMetaData.class, builder);
/*  81 */     this.moFactory.setBuilder(NoTxDataSourceDeploymentMetaData.class, builder);
/*  82 */     this.moFactory.setBuilder(TxConnectionFactoryDeploymentMetaData.class, builder);
/*  83 */     this.moFactory.setBuilder(TxConnectionFactoryDeploymentMetaData.class, builder);
/*     */   }
/*     */ 
/*     */   public JCAMetaDataRepository getRepository()
/*     */   {
/*  93 */     return this.repository;
/*     */   }
/*     */ 
/*     */   public void setRepository(JCAMetaDataRepository repository)
/*     */   {
/* 103 */     this.repository = repository;
/*     */   }
/*     */ 
/*     */   public void create() throws Exception
/*     */   {
/* 108 */     Class[] classes = { super.getOutput() };
/* 109 */     this.context = JAXBContext.newInstance(classes);
/*     */   }
/*     */ 
/*     */   protected ManagedConnectionFactoryDeploymentGroup parse(VFSDeploymentUnit unit, VirtualFile file, ManagedConnectionFactoryDeploymentGroup root)
/*     */     throws Exception
/*     */   {
/* 116 */     Unmarshaller um = this.context.createUnmarshaller();
/* 117 */     InputStream is = file.openStream();
/*     */     try
/*     */     {
/* 121 */       JAXBElement elem = um.unmarshal(new StreamSource(is), ManagedConnectionFactoryDeploymentGroup.class);
/* 122 */       ManagedConnectionFactoryDeploymentGroup deployment = (ManagedConnectionFactoryDeploymentGroup)elem.getValue();
/* 123 */       this.repository.addManagedConnectionFactoryDeploymentGroup(deployment);
/* 124 */       ManagedConnectionFactoryDeploymentGroup localManagedConnectionFactoryDeploymentGroup1 = deployment;
/*     */       return localManagedConnectionFactoryDeploymentGroup1;
/*     */     }
/*     */     finally
/*     */     {
/* 129 */       if (is != null)
/* 130 */         is.close(); 
/* 130 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   protected void init(VFSDeploymentUnit unit, ManagedConnectionFactoryDeploymentGroup metaData, VirtualFile file)
/*     */     throws Exception
/*     */   {
/* 137 */     metaData.setUrl(file.toURL());
/*     */   }
/*     */ 
/*     */   public void build(DeploymentUnit unit, Map<String, ManagedObject> managedObjects)
/*     */     throws DeploymentException
/*     */   {
/* 150 */     super.build(unit, managedObjects);
/* 151 */     if (isBuildManagedObject())
/*     */     {
/* 153 */       ManagedConnectionFactoryDeploymentGroup deployment = (ManagedConnectionFactoryDeploymentGroup)unit.getAttachment(getOutput());
/* 154 */       if (deployment != null)
/*     */       {
/* 156 */         if (deployment.getDeployments() != null)
/*     */         {
/* 158 */           for (ManagedConnectionFactoryDeploymentMetaData mcf : deployment.getDeployments())
/*     */           {
/* 160 */             ManagedObject mo = this.moFactory.initManagedObject(mcf, null, null);
/* 161 */             if (mo != null)
/*     */             {
/* 165 */               managedObjects.put(mcf.getClass().getName(), mo);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.ManagedConnectionFactoryParserDeployer
 * JD-Core Version:    0.6.0
 */