/*     */ package org.jboss.resource.deployers;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
/*     */ import org.jboss.deployers.spi.management.KnownComponentTypes.DataSourceTypes;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.managed.api.ComponentType;
/*     */ import org.jboss.resource.deployers.builder.AbstractBuilder;
/*     */ import org.jboss.resource.metadata.mcf.LocalDataSourceDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.NoTxDataSourceDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.repository.DefaultJCAMetaDataRepository;
/*     */ import org.jboss.system.metadata.ServiceDeployment;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ 
/*     */ public class ManagedConnectionFactoryDeployer extends AbstractSimpleRealDeployer<ManagedConnectionFactoryDeploymentGroup>
/*     */ {
/*     */   private DefaultJCAMetaDataRepository repository;
/*  59 */   private List<AbstractBuilder> builders = new ArrayList();
/*     */ 
/*  61 */   private String[] propNames = { "jndiName", "jdbcURL", "userName", "passWord", "driverClass", "minPoolSize", "maxPoolSize", "securityMetaData", "managedConnectionFactoryProperties" };
/*     */ 
/*  75 */   private Map<String, String> propertyNameMappings = new HashMap();
/*     */ 
/*     */   public Map<String, String> getPropertyNameMappings()
/*     */   {
/*  79 */     return this.propertyNameMappings;
/*     */   }
/*     */ 
/*     */   public void setPropertyNameMappings(Map<String, String> mangedToMBeanNames)
/*     */   {
/*  84 */     this.propertyNameMappings.clear();
/*     */ 
/*  89 */     for (String key : mangedToMBeanNames.keySet())
/*     */     {
/*  91 */       String value = (String)mangedToMBeanNames.get(key);
/*  92 */       this.propertyNameMappings.put(value, key);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String[] getPropNames()
/*     */   {
/*  98 */     return this.propNames;
/*     */   }
/*     */ 
/*     */   public void setPropNames(String[] propNames)
/*     */   {
/* 103 */     this.propNames = propNames;
/*     */   }
/*     */ 
/*     */   public ManagedConnectionFactoryDeployer()
/*     */   {
/* 111 */     super(ManagedConnectionFactoryDeploymentGroup.class);
/* 112 */     setOutput(ServiceDeployment.class);
/*     */   }
/*     */ 
/*     */   public void setBuilders(List<AbstractBuilder> builders)
/*     */   {
/* 117 */     this.builders = builders;
/*     */   }
/*     */ 
/*     */   public List<AbstractBuilder> getBuilders()
/*     */   {
/* 122 */     return this.builders;
/*     */   }
/*     */ 
/*     */   public DefaultJCAMetaDataRepository getRepository()
/*     */   {
/* 132 */     return this.repository;
/*     */   }
/*     */ 
/*     */   public void setRepository(DefaultJCAMetaDataRepository repository)
/*     */   {
/* 142 */     this.repository = repository;
/*     */   }
/*     */ 
/*     */   public void deploy(DeploymentUnit unit, ManagedConnectionFactoryDeploymentGroup group)
/*     */     throws DeploymentException
/*     */   {
/* 149 */     List deployments = group.getDeployments();
/* 150 */     ServiceDeployment serviceDeployment = new ServiceDeployment();
/* 151 */     List componentServices = new ArrayList();
/* 152 */     List serviceDefintion = group.getServices();
/*     */ 
/* 154 */     serviceDeployment.setName(unit.getName() + " services");
/*     */ 
/* 156 */     for (ServiceMetaData data : serviceDefintion)
/*     */     {
/* 158 */       componentServices.add(data);
/*     */     }
/*     */ 
/* 161 */     ComponentType type = null;
/* 162 */     for (Iterator i$ = deployments.iterator(); i$.hasNext(); ) { data = (ManagedConnectionFactoryDeploymentMetaData)i$.next();
/*     */ 
/* 165 */       if (type == null)
/*     */       {
/* 167 */         if ((data instanceof LocalDataSourceDeploymentMetaData))
/* 168 */           type = KnownComponentTypes.DataSourceTypes.LocalTx.getType();
/* 169 */         if ((data instanceof NoTxDataSourceDeploymentMetaData))
/* 170 */           type = KnownComponentTypes.DataSourceTypes.NoTx.getType();
/* 171 */         if ((data instanceof XADataSourceDeploymentMetaData)) {
/* 172 */           type = KnownComponentTypes.DataSourceTypes.XA.getType();
/*     */         }
/*     */       }
/* 175 */       for (AbstractBuilder builder : this.builders)
/*     */       {
/* 177 */         ServiceMetaData candidate = builder.build(data);
/*     */ 
/* 179 */         if (candidate != null)
/*     */         {
/* 181 */           componentServices.add(candidate);
/*     */         }
/*     */       }
/*     */     }
/*     */     ManagedConnectionFactoryDeploymentMetaData data;
/* 186 */     serviceDeployment.setServices(componentServices);
/* 187 */     unit.addAttachment(ServiceDeployment.class, serviceDeployment);
/* 188 */     if (type != null)
/* 189 */       unit.addAttachment(ComponentType.class, type);
/*     */   }
/*     */ 
/*     */   public void undeploy(DeploymentUnit unit, ManagedConnectionFactoryDeploymentGroup deployment)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.ManagedConnectionFactoryDeployer
 * JD-Core Version:    0.6.0
 */