/*     */ package org.jboss.resource.connectionmanager;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ 
/*     */ public class TransactionSynchronizer
/*     */   implements Synchronization
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(TransactionSynchronizer.class);
/*     */   protected static TransactionLocal txSynchs;
/*     */   protected Transaction tx;
/*     */   protected Thread enlistingThread;
/*     */   protected ArrayList unenlisted;
/*     */   protected ArrayList enlisted;
/*     */   protected Synchronization ccmSynch;
/*     */ 
/*     */   public static void setTransactionManager(TransactionManager tm)
/*     */   {
/*  72 */     txSynchs = new TransactionLocal(tm);
/*     */   }
/*     */ 
/*     */   private TransactionSynchronizer(Transaction tx)
/*     */   {
/*  82 */     this.tx = tx;
/*     */   }
/*     */ 
/*     */   synchronized void addUnenlisted(Synchronization synch)
/*     */   {
/*  92 */     if (this.unenlisted == null)
/*  93 */       this.unenlisted = new ArrayList();
/*  94 */     this.unenlisted.add(synch);
/*     */   }
/*     */ 
/*     */   synchronized ArrayList getUnenlisted()
/*     */   {
/* 105 */     Thread currentThread = Thread.currentThread();
/* 106 */     while ((this.enlistingThread != null) && (this.enlistingThread != currentThread))
/*     */     {
/* 108 */       boolean interrupted = false;
/*     */       try
/*     */       {
/* 111 */         wait();
/*     */       }
/*     */       catch (InterruptedException e)
/*     */       {
/* 115 */         interrupted = true;
/*     */       }
/* 117 */       if (interrupted)
/* 118 */         currentThread.interrupt();
/*     */     }
/* 120 */     ArrayList result = this.unenlisted;
/* 121 */     this.unenlisted = null;
/* 122 */     if (result != null)
/* 123 */       this.enlistingThread = currentThread;
/* 124 */     return result;
/*     */   }
/*     */ 
/*     */   synchronized void addEnlisted(Synchronization synch)
/*     */   {
/* 134 */     if (this.enlisted == null)
/* 135 */       this.enlisted = new ArrayList();
/* 136 */     this.enlisted.add(synch);
/*     */   }
/*     */ 
/*     */   synchronized boolean removeEnlisted(Synchronization synch)
/*     */   {
/* 147 */     return this.enlisted.remove(synch);
/*     */   }
/*     */ 
/*     */   synchronized void enlisted()
/*     */   {
/* 155 */     Thread currentThread = Thread.currentThread();
/* 156 */     if ((this.enlistingThread == null) || (this.enlistingThread != currentThread))
/*     */     {
/* 158 */       log.warn("Thread " + currentThread + " not the enlisting thread " + this.enlistingThread, new Exception("STACKTRACE"));
/* 159 */       return;
/*     */     }
/* 161 */     this.enlistingThread = null;
/* 162 */     notifyAll();
/*     */   }
/*     */ 
/*     */   static TransactionSynchronizer getRegisteredSynchronizer(Transaction tx)
/*     */     throws RollbackException, SystemException
/*     */   {
/* 175 */     TransactionSynchronizer result = (TransactionSynchronizer)txSynchs.get(tx);
/* 176 */     if (result == null)
/*     */     {
/* 178 */       result = new TransactionSynchronizer(tx);
/* 179 */       tx.registerSynchronization(result);
/* 180 */       txSynchs.set(tx, result);
/*     */     }
/* 182 */     return result;
/*     */   }
/*     */ 
/*     */   static Synchronization getCCMSynchronization(Transaction tx)
/*     */   {
/* 192 */     TransactionSynchronizer ts = (TransactionSynchronizer)txSynchs.get(tx);
/* 193 */     if (ts != null) {
/* 194 */       return ts.ccmSynch;
/*     */     }
/* 196 */     return null;
/*     */   }
/*     */ 
/*     */   static void registerCCMSynchronization(Transaction tx, Synchronization synch)
/*     */     throws RollbackException, SystemException
/*     */   {
/* 209 */     TransactionSynchronizer ts = getRegisteredSynchronizer(tx);
/* 210 */     ts.ccmSynch = synch;
/*     */   }
/*     */ 
/*     */   static void lock(Transaction tx)
/*     */   {
/*     */     try
/*     */     {
/* 222 */       txSynchs.lock(tx);
/*     */     }
/*     */     catch (InterruptedException e)
/*     */     {
/* 226 */       throw new NestedRuntimeException("Unable to get synchronization", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   static void unlock(Transaction tx)
/*     */   {
/* 237 */     txSynchs.unlock(tx);
/*     */   }
/*     */ 
/*     */   public void beforeCompletion()
/*     */   {
/* 242 */     if (this.enlisted != null)
/*     */     {
/* 244 */       int i = 0;
/* 245 */       while (i < this.enlisted.size())
/*     */       {
/* 247 */         Synchronization synch = (Synchronization)this.enlisted.get(i);
/* 248 */         invokeBefore(synch);
/* 249 */         i++;
/*     */       }
/*     */     }
/*     */ 
/* 253 */     if (this.ccmSynch != null)
/* 254 */       invokeBefore(this.ccmSynch);
/*     */   }
/*     */ 
/*     */   public void afterCompletion(int status)
/*     */   {
/* 259 */     if (this.enlisted != null)
/*     */     {
/* 261 */       int i = 0;
/* 262 */       while (i < this.enlisted.size())
/*     */       {
/* 264 */         Synchronization synch = (Synchronization)this.enlisted.get(i);
/* 265 */         invokeAfter(synch, status);
/* 266 */         i++;
/*     */       }
/*     */     }
/*     */ 
/* 270 */     if (this.ccmSynch != null)
/* 271 */       invokeAfter(this.ccmSynch, status);
/*     */   }
/*     */ 
/*     */   protected void invokeBefore(Synchronization synch)
/*     */   {
/*     */     try
/*     */     {
/* 283 */       synch.beforeCompletion();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 287 */       log.warn("Transaction " + this.tx + " error in before completion " + synch, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void invokeAfter(Synchronization synch, int status)
/*     */   {
/*     */     try
/*     */     {
/* 301 */       synch.afterCompletion(status);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 305 */       log.warn("Transaction " + this.tx + " error in after completion " + synch, t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.TransactionSynchronizer
 * JD-Core Version:    0.6.0
 */