/*     */ package org.jboss.resource.connectionmanager;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.io.PrintWriter;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.Notification;
/*     */ import javax.management.ObjectName;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionManager;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.resource.spi.ManagedConnection;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import javax.resource.spi.ResourceAdapter;
/*     */ import javax.resource.spi.ResourceAdapterAssociation;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.resource.metadata.ConfigPropertyMetaData;
/*     */ import org.jboss.resource.metadata.ConnectionDefinitionMetaData;
/*     */ import org.jboss.resource.metadata.ConnectorMetaData;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class RARDeployment extends ServiceMBeanSupport
/*     */   implements RARDeploymentMBean, ManagedConnectionFactory
/*     */ {
/*     */   static final long serialVersionUID = -294341806721616790L;
/*     */   public static final String MCF_ATTRIBUTE_CHANGED_NOTIFICATION = "jboss.mcfattributechangednotification";
/*  72 */   private Logger log = Logger.getLogger(getClass());
/*     */   private ObjectName oldRarDeployment;
/*     */   private String rarName;
/*     */   private String connectionDefinition;
/*     */   private String vendorName;
/*     */   private String specVersion;
/*     */   private String eisType;
/*     */   private String version;
/*     */   private String managedConnectionFactoryClass;
/*     */   private String connectionFactoryInterface;
/*     */   private String connectionFactoryImplClass;
/*     */   private String connectionInterface;
/*     */   private String connectionImplClass;
/*     */   private String transactionSupport;
/*     */   private Element managedConnectionFactoryProperties;
/*     */   private String authenticationMechanismType;
/*     */   private String credentialInterface;
/*     */   private boolean reauthenticationSupport;
/*     */   private Class mcfClass;
/*     */   private ManagedConnectionFactory mcf;
/*     */ 
/*     */   public ObjectName getOldRarDeployment()
/*     */   {
/* 122 */     return this.oldRarDeployment;
/*     */   }
/*     */ 
/*     */   public void setOldRarDeployment(ObjectName oldRarDeployment)
/*     */   {
/* 127 */     this.oldRarDeployment = oldRarDeployment;
/*     */   }
/*     */ 
/*     */   public String getRARName()
/*     */   {
/* 132 */     return this.rarName;
/*     */   }
/*     */ 
/*     */   public void setRARName(String rarName)
/*     */   {
/* 137 */     this.rarName = rarName;
/*     */   }
/*     */ 
/*     */   public String getConnectionDefinition()
/*     */   {
/* 142 */     return this.connectionDefinition;
/*     */   }
/*     */ 
/*     */   public void setConnectionDefinition(String connectionDefinition)
/*     */   {
/* 147 */     this.connectionDefinition = connectionDefinition;
/*     */   }
/*     */ 
/*     */   public String getVendorName()
/*     */   {
/* 152 */     return this.vendorName;
/*     */   }
/*     */ 
/*     */   public void setVendorName(String vendorName)
/*     */   {
/* 157 */     this.vendorName = vendorName;
/*     */   }
/*     */ 
/*     */   public String getSpecVersion()
/*     */   {
/* 162 */     return this.specVersion;
/*     */   }
/*     */ 
/*     */   public void setSpecVersion(String specVersion)
/*     */   {
/* 167 */     this.specVersion = specVersion;
/*     */   }
/*     */ 
/*     */   public String getEisType()
/*     */   {
/* 172 */     return this.eisType;
/*     */   }
/*     */ 
/*     */   public void setEisType(String eisType)
/*     */   {
/* 177 */     this.eisType = eisType;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 182 */     return this.version;
/*     */   }
/*     */ 
/*     */   public void setVersion(String version)
/*     */   {
/* 187 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public String getManagedConnectionFactoryClass()
/*     */   {
/* 192 */     return this.managedConnectionFactoryClass;
/*     */   }
/*     */ 
/*     */   public void setManagedConnectionFactoryClass(String managedConnectionFactoryClass)
/*     */   {
/* 197 */     this.managedConnectionFactoryClass = managedConnectionFactoryClass;
/*     */   }
/*     */ 
/*     */   public String getConnectionFactoryInterface()
/*     */   {
/* 202 */     return this.connectionFactoryInterface;
/*     */   }
/*     */ 
/*     */   public void setConnectionFactoryInterface(String connectionFactoryInterface)
/*     */   {
/* 207 */     this.connectionFactoryInterface = connectionFactoryInterface;
/*     */   }
/*     */ 
/*     */   public String getConnectionFactoryImplClass()
/*     */   {
/* 212 */     return this.connectionFactoryImplClass;
/*     */   }
/*     */ 
/*     */   public void setConnectionFactoryImplClass(String connectionFactoryImplClass)
/*     */   {
/* 217 */     this.connectionFactoryImplClass = connectionFactoryImplClass;
/*     */   }
/*     */ 
/*     */   public String getConnectionInterface()
/*     */   {
/* 222 */     return this.connectionInterface;
/*     */   }
/*     */ 
/*     */   public void setConnectionInterface(String connectionInterface)
/*     */   {
/* 227 */     this.connectionInterface = connectionInterface;
/*     */   }
/*     */ 
/*     */   public String getConnectionImplClass()
/*     */   {
/* 232 */     return this.connectionImplClass;
/*     */   }
/*     */ 
/*     */   public void setConnectionImplClass(String connectionImplClass)
/*     */   {
/* 237 */     this.connectionImplClass = connectionImplClass;
/*     */   }
/*     */ 
/*     */   public String getTransactionSupport()
/*     */   {
/* 242 */     return this.transactionSupport;
/*     */   }
/*     */ 
/*     */   public void setTransactionSupport(String transactionSupport)
/*     */   {
/* 247 */     this.transactionSupport = transactionSupport;
/*     */   }
/*     */ 
/*     */   public Element getManagedConnectionFactoryProperties()
/*     */   {
/* 252 */     return this.managedConnectionFactoryProperties;
/*     */   }
/*     */ 
/*     */   public void setManagedConnectionFactoryProperties(Element managedConnectionFactoryProperties)
/*     */   {
/* 257 */     this.managedConnectionFactoryProperties = managedConnectionFactoryProperties;
/*     */   }
/*     */ 
/*     */   public String getAuthenticationMechanismType()
/*     */   {
/* 262 */     return this.authenticationMechanismType;
/*     */   }
/*     */ 
/*     */   public void setAuthenticationMechanismType(String authenticationMechanismType)
/*     */   {
/* 267 */     this.authenticationMechanismType = authenticationMechanismType;
/*     */   }
/*     */ 
/*     */   public String getCredentialInterface()
/*     */   {
/* 272 */     return this.credentialInterface;
/*     */   }
/*     */ 
/*     */   public void setCredentialInterface(String credentialInterface)
/*     */   {
/* 277 */     this.credentialInterface = credentialInterface;
/*     */   }
/*     */ 
/*     */   public boolean isReauthenticationSupport()
/*     */   {
/* 282 */     return this.reauthenticationSupport;
/*     */   }
/*     */ 
/*     */   public void setReauthenticationSupport(boolean reauthenticationSupport)
/*     */   {
/* 287 */     this.reauthenticationSupport = reauthenticationSupport;
/*     */   }
/*     */ 
/*     */   public ManagedConnectionFactory getMcfInstance()
/*     */   {
/* 292 */     return this.mcf;
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/* 297 */     if (this.mcf != null) {
/* 298 */       throw new DeploymentException("Stop the RARDeployment before restarting it");
/*     */     }
/* 300 */     ConnectorMetaData cmd = null;
/* 301 */     ConnectionDefinitionMetaData cdmd = null;
/* 302 */     ResourceAdapter resourceAdapter = null;
/* 303 */     if (this.oldRarDeployment != null)
/*     */     {
/*     */       try
/*     */       {
/* 307 */         resourceAdapter = (ResourceAdapter)getServer().getAttribute(this.oldRarDeployment, "ResourceAdapter");
/* 308 */         cmd = (ConnectorMetaData)getServer().getAttribute(this.oldRarDeployment, "MetaData");
/* 309 */         cdmd = cmd.getConnectionDefinition(this.connectionDefinition);
/* 310 */         if (cdmd == null)
/* 311 */           throw new DeploymentException("ConnectionDefinition '" + this.connectionDefinition + "' not found in rar '" + this.rarName + "'");
/* 312 */         setManagedConnectionFactoryClass(cdmd.getManagedConnectionFactoryClass());
/* 313 */         setReauthenticationSupport(cmd.getReauthenticationSupport());
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 317 */         throw new DeploymentException("couldn't get oldRarDeployment! " + this.oldRarDeployment, e);
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/* 322 */       this.mcfClass = Thread.currentThread().getContextClassLoader().loadClass(this.managedConnectionFactoryClass);
/*     */     }
/*     */     catch (ClassNotFoundException cnfe)
/*     */     {
/* 326 */       this.log.error("Could not find ManagedConnectionFactory class: " + this.managedConnectionFactoryClass, cnfe);
/* 327 */       throw new DeploymentException("Could not find ManagedConnectionFactory class: " + this.managedConnectionFactoryClass);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 332 */       this.mcf = ((ManagedConnectionFactory)this.mcfClass.newInstance());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 336 */       this.log.error("Could not instantiate ManagedConnectionFactory: " + this.managedConnectionFactoryClass, e);
/* 337 */       throw new DeploymentException("Could not instantiate ManagedConnectionFactory: " + this.managedConnectionFactoryClass);
/*     */     }
/*     */ 
/* 340 */     if (cmd != null)
/*     */     {
/* 343 */       setMcfProperties(cmd.getProperties(), false);
/*     */ 
/* 345 */       setMcfProperties(cdmd.getProperties(), true);
/*     */     }
/*     */ 
/* 348 */     setMcfProperties(this.managedConnectionFactoryProperties);
/*     */ 
/* 350 */     if ((resourceAdapter != null) && ((this.mcf instanceof ResourceAdapterAssociation)))
/*     */     {
/* 352 */       ResourceAdapterAssociation raa = (ResourceAdapterAssociation)this.mcf;
/* 353 */       raa.setResourceAdapter(resourceAdapter);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */   {
/* 359 */     this.mcf = null;
/* 360 */     this.mcfClass = null;
/*     */   }
/*     */ 
/*     */   public void setManagedConnectionFactoryAttribute(String name, Class clazz, Object value)
/*     */   {
/* 365 */     setManagedConnectionFactoryAttribute(name, clazz, value, false);
/*     */   }
/*     */ 
/*     */   protected void setManagedConnectionFactoryAttribute(String name, Class clazz, Object value, boolean mustExist)
/*     */   {
/* 370 */     if ((name == null) || (name.length() == 0))
/* 371 */       throw new IllegalArgumentException("Null or empty attribute name " + name);
/* 372 */     String setterName = "set" + Character.toUpperCase(name.charAt(0));
/* 373 */     if (name.length() > 1)
/* 374 */       setterName = setterName.concat(name.substring(1));
/*     */     Method setter;
/*     */     try {
/* 378 */       setter = this.mcfClass.getMethod(setterName, new Class[] { clazz });
/*     */     }
/*     */     catch (NoSuchMethodException nsme)
/*     */     {
/* 382 */       String error = "The class '" + this.mcfClass.toString() + "' has no setter for config property '" + name + "'";
/* 383 */       if (mustExist) {
/* 384 */         throw new IllegalArgumentException(error);
/*     */       }
/*     */ 
/* 387 */       this.log.trace(error, nsme);
/* 388 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 393 */       setter.invoke(this.mcf, new Object[] { value });
/* 394 */       this.log.debug("set property " + name + " to value " + value);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 398 */       String error = "Unable to invoke setter method '" + setter + "' " + "on object '" + this.mcf + "'";
/* 399 */       if ((e instanceof InvocationTargetException)) {
/* 400 */         throw new NestedRuntimeException(error, ((InvocationTargetException)e).getCause());
/*     */       }
/* 402 */       throw new NestedRuntimeException(error, e);
/*     */     }
/* 404 */     sendNotification(new Notification("jboss.mcfattributechangednotification", getServiceName(), getNextNotificationSequenceNumber()));
/*     */   }
/*     */ 
/*     */   public Object getManagedConnectionFactoryAttribute(String name)
/*     */   {
/* 410 */     if ((name == null) || (name.length() == 0))
/* 411 */       throw new IllegalArgumentException("Null or empty attribute name " + name);
/* 412 */     String getterName = "get" + Character.toUpperCase(name.charAt(0));
/* 413 */     if (name.length() > 1)
/* 414 */       getterName = getterName.concat(name.substring(1));
/*     */     Method getter;
/*     */     try {
/* 418 */       getter = this.mcfClass.getMethod(getterName, new Class[0]);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 422 */       String msg = "The class '" + this.mcfClass + "' has no getter(" + getterName + ") for config property '" + name + "'";
/*     */ 
/* 424 */       this.log.debug(msg, e);
/* 425 */       throw new IllegalArgumentException(msg);
/*     */     }String error;
/*     */     try {
/* 429 */       Object value = getter.invoke(this.mcf, new Object[0]);
/* 430 */       this.log.debug("get property " + name + ": value " + value);
/* 431 */       return value;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 435 */       error = "Unable to invoke getter method '" + getter + "' " + "on object '" + this.mcf + "'";
/* 436 */       this.log.debug(error, e);
/* 437 */       if ((e instanceof InvocationTargetException))
/* 438 */         throw new NestedRuntimeException(error, ((InvocationTargetException)e).getCause());
/*     */     }
/* 440 */     throw new NestedRuntimeException(error, e);
/*     */   }
/*     */ 
/*     */   protected void setMcfProperties(Collection properties, boolean mustExist)
/*     */     throws DeploymentException
/*     */   {
/* 446 */     for (Iterator i = properties.iterator(); i.hasNext(); )
/*     */     {
/* 448 */       ConfigPropertyMetaData cpmd = (ConfigPropertyMetaData)i.next();
/* 449 */       String name = cpmd.getName();
/* 450 */       String type = cpmd.getType();
/* 451 */       String value = cpmd.getValue();
/* 452 */       if ((name == null) || (name.length() == 0) || (value == null) || (value.length() == 0))
/*     */       {
/* 454 */         this.log.debug("Not setting config property '" + name + "'");
/* 455 */         continue;
/*     */       }
/*     */ 
/* 458 */       Class clazz = Classes.getPrimitiveTypeForName(type);
/* 459 */       if (clazz == null)
/*     */       {
/*     */         try
/*     */         {
/* 464 */           clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
/*     */         }
/*     */         catch (ClassNotFoundException cnfe)
/*     */         {
/* 468 */           this.log.warn("Unable to find class '" + type + "' for " + "property '" + name + "' - skipping property.");
/* 469 */         }continue;
/*     */       }
/*     */ 
/* 472 */       PropertyEditor pe = PropertyEditorManager.findEditor(clazz);
/* 473 */       if (pe == null)
/*     */       {
/* 475 */         this.log.warn("Unable to find a PropertyEditor for class '" + clazz + "' of property '" + name + "' - " + "skipping property");
/*     */ 
/* 477 */         continue;
/*     */       }
/* 479 */       this.log.debug("setting property: " + name + " to value " + value);
/*     */       try
/*     */       {
/* 482 */         pe.setAsText(value);
/*     */       }
/*     */       catch (IllegalArgumentException iae)
/*     */       {
/* 486 */         this.log.warn("Value '" + value + "' is not valid for property '" + name + "' of class '" + clazz + "' - skipping " + "property");
/*     */       }
/* 488 */       continue;
/*     */ 
/* 490 */       Object v = pe.getValue();
/* 491 */       setManagedConnectionFactoryAttribute(name, clazz, v, mustExist);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setMcfProperties(Element mcfProps) throws DeploymentException
/*     */   {
/* 497 */     if (mcfProps == null) {
/* 498 */       return;
/*     */     }
/* 500 */     NodeList props = mcfProps.getChildNodes();
/* 501 */     for (int i = 0; i < props.getLength(); i++)
/*     */     {
/* 503 */       if (props.item(i).getNodeType() != 1)
/*     */         continue;
/* 505 */       Element prop = (Element)props.item(i);
/* 506 */       if (!prop.getTagName().equals("config-property"))
/*     */         continue;
/* 508 */       String name = null;
/* 509 */       String type = null;
/* 510 */       String value = null;
/*     */ 
/* 513 */       if (prop.hasAttribute("name"))
/*     */       {
/* 515 */         name = prop.getAttribute("name");
/* 516 */         type = prop.getAttribute("type");
/* 517 */         value = MetaData.getElementContent(prop, null, false);
/*     */       }
/*     */       else
/*     */       {
/* 521 */         name = MetaData.getElementContent(MetaData.getUniqueChild(prop, "config-property-name"));
/* 522 */         type = MetaData.getElementContent(MetaData.getUniqueChild(prop, "config-property-type"));
/* 523 */         value = MetaData.getElementContent(MetaData.getOptionalChild(prop, "config-property-value"), null, false);
/*     */       }
/* 525 */       if ((name == null) || (name.length() == 0) || (value == null) || (value.length() == 0))
/*     */       {
/* 527 */         this.log.debug("Not setting config property '" + name + "'");
/*     */       }
/*     */       else {
/* 530 */         if ((type == null) || (type.length() == 0))
/*     */         {
/* 533 */           type = "java.lang.String";
/*     */         }
/*     */ 
/* 536 */         Class clazz = Classes.getPrimitiveTypeForName(type);
/* 537 */         if (clazz == null)
/*     */         {
/*     */           try
/*     */           {
/* 542 */             clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
/*     */           }
/*     */           catch (ClassNotFoundException cnfe)
/*     */           {
/* 546 */             this.log.warn("Unable to find class '" + type + "' for " + "property '" + name + "' - skipping property.");
/*     */ 
/* 548 */             continue;
/*     */           }
/*     */         }
/* 551 */         PropertyEditor pe = PropertyEditorManager.findEditor(clazz);
/* 552 */         if (pe == null)
/*     */         {
/* 554 */           this.log.warn("Unable to find a PropertyEditor for class '" + clazz + "' of property '" + name + "' - " + "skipping property");
/*     */         }
/*     */         else
/*     */         {
/* 558 */           this.log.debug("setting property: " + name + " to value " + value);
/*     */           try
/*     */           {
/* 561 */             pe.setAsText(value);
/*     */           }
/*     */           catch (IllegalArgumentException iae)
/*     */           {
/* 565 */             this.log.warn("Value '" + value + "' is not valid for property '" + name + "' of class '" + clazz + "' - skipping " + "property");
/*     */ 
/* 567 */             continue;
/*     */           }
/* 569 */           Object v = pe.getValue();
/* 570 */           setManagedConnectionFactoryAttribute(name, clazz, v);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object createConnectionFactory() throws ResourceException
/*     */   {
/* 578 */     return this.mcf.createConnectionFactory();
/*     */   }
/*     */ 
/*     */   public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException
/*     */   {
/* 583 */     return this.mcf.createConnectionFactory(cxManager);
/*     */   }
/*     */ 
/*     */   public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo)
/*     */     throws ResourceException
/*     */   {
/* 589 */     return this.mcf.createManagedConnection(subject, cxRequestInfo);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 594 */     return this.mcf.equals(other);
/*     */   }
/*     */ 
/*     */   public PrintWriter getLogWriter() throws ResourceException
/*     */   {
/* 599 */     return this.mcf.getLogWriter();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 604 */     StringBuffer buffer = new StringBuffer();
/* 605 */     buffer.append(getClass().getName());
/* 606 */     buffer.append('@');
/* 607 */     buffer.append(Integer.toHexString(System.identityHashCode(this)));
/* 608 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 613 */     return this.mcf.hashCode();
/*     */   }
/*     */ 
/*     */   public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo)
/*     */     throws ResourceException
/*     */   {
/* 619 */     return this.mcf.matchManagedConnections(connectionSet, subject, cxRequestInfo);
/*     */   }
/*     */ 
/*     */   public void setLogWriter(PrintWriter out) throws ResourceException
/*     */   {
/* 624 */     this.mcf.setLogWriter(out);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.RARDeployment
 * JD-Core Version:    0.6.0
 */