/*    */ package org.jboss.resource.connectionmanager;
/*    */ 
/*    */ import javax.resource.ResourceException;
/*    */ import javax.resource.spi.ConnectionEvent;
/*    */ import javax.resource.spi.ManagedConnection;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class NoTxConnectionManager extends BaseConnectionManager2
/*    */ {
/*    */   public NoTxConnectionManager()
/*    */   {
/*    */   }
/*    */ 
/*    */   public NoTxConnectionManager(CachedConnectionManager ccm, ManagedConnectionPool poolingStrategy)
/*    */   {
/* 60 */     super(ccm, poolingStrategy);
/*    */   }
/*    */ 
/*    */   public ConnectionListener createConnectionListener(ManagedConnection mc, Object context)
/*    */   {
/* 65 */     ConnectionListener cli = new NoTxConnectionEventListener(mc, this.poolingStrategy, context, this.log, null);
/* 66 */     mc.addConnectionEventListener(cli);
/* 67 */     return cli;
/*    */   }
/*    */ 
/*    */   protected void managedConnectionDisconnected(ConnectionListener cl)
/*    */     throws ResourceException
/*    */   {
/* 73 */     if (cl.isManagedConnectionFree())
/* 74 */       returnManagedConnection(cl, false);
/*    */   }
/*    */ 
/*    */   private class NoTxConnectionEventListener extends BaseConnectionManager2.BaseConnectionEventListener
/*    */   {
/*    */     private NoTxConnectionEventListener(ManagedConnection mc, ManagedConnectionPool mcp, Object context, Logger log)
/*    */     {
/* 81 */       super(mc, mcp, context, log);
/*    */     }
/*    */ 
/*    */     public void connectionClosed(ConnectionEvent ce)
/*    */     {
/*    */       try
/*    */       {
/* 88 */         NoTxConnectionManager.this.getCcm().unregisterConnection(NoTxConnectionManager.this, ce.getConnectionHandle());
/*    */       }
/*    */       catch (Throwable t)
/*    */       {
/* 92 */         this.log.info("Throwable from unregisterConnection", t);
/*    */       }
/*    */       try
/*    */       {
/* 96 */         NoTxConnectionManager.this.unregisterAssociation(this, ce.getConnectionHandle());
/* 97 */         if (isManagedConnectionFree())
/*    */         {
/* 99 */           NoTxConnectionManager.this.returnManagedConnection(this, false);
/*    */         }
/*    */       }
/*    */       catch (ResourceException re)
/*    */       {
/* 104 */         this.log.error("ResourceException while closing connection handle!", re);
/*    */       }
/*    */     }
/*    */ 
/*    */     public void localTransactionStarted(ConnectionEvent ce)
/*    */     {
/*    */     }
/*    */ 
/*    */     public void localTransactionCommitted(ConnectionEvent ce)
/*    */     {
/*    */     }
/*    */ 
/*    */     public void localTransactionRolledback(ConnectionEvent ce)
/*    */     {
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.NoTxConnectionManager
 * JD-Core Version:    0.6.0
 */