/*    */ package org.jboss.resource.connectionmanager;
/*    */ 
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.ObjectName;
/*    */ import javax.transaction.xa.XAException;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.system.ServiceMBeanSupport;
/*    */ import org.jboss.tm.XAExceptionFormatter;
/*    */ 
/*    */ public class JBossLocalXAExceptionFormatter extends ServiceMBeanSupport
/*    */   implements XAExceptionFormatter, JBossLocalXAExceptionFormatterMBean
/*    */ {
/*    */   private ObjectName transactionManagerService;
/*    */ 
/*    */   public ObjectName getTransactionManagerService()
/*    */   {
/* 51 */     return this.transactionManagerService;
/*    */   }
/*    */ 
/*    */   public void setTransactionManagerService(ObjectName transactionManagerService)
/*    */   {
/* 56 */     this.transactionManagerService = transactionManagerService;
/*    */   }
/*    */ 
/*    */   protected void startService() throws Exception
/*    */   {
/* 61 */     getServer().invoke(this.transactionManagerService, "registerXAExceptionFormatter", new Object[] { JBossLocalXAException.class, this }, new String[] { Class.class.getName(), JBossLocalXAExceptionFormatterMBean.class.getName() });
/*    */   }
/*    */ 
/*    */   protected void stopService()
/*    */     throws Exception
/*    */   {
/* 69 */     getServer().invoke(this.transactionManagerService, "unregisterXAExceptionFormatter", new Object[] { JBossLocalXAException.class }, new String[] { Class.class.getName() });
/*    */   }
/*    */ 
/*    */   public void formatXAException(XAException xae, Logger log)
/*    */   {
/*    */     try
/*    */     {
/* 79 */       log.warn("JBoss Local XA wrapper error: ", ((JBossLocalXAException)xae).getCause());
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 83 */       log.warn("Problem trying to format XAException: ", e);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.JBossLocalXAExceptionFormatter
 * JD-Core Version:    0.6.0
 */