/*     */ package org.jboss.resource.connectionmanager;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import javax.transaction.xa.XAException;
/*     */ import org.jboss.util.NestedThrowable;
/*     */ import org.jboss.util.NestedThrowable.Util;
/*     */ 
/*     */ public class JBossLocalXAException extends XAException
/*     */   implements NestedThrowable
/*     */ {
/*     */   private static final long serialVersionUID = -6208145503935506281L;
/*     */   private final Throwable t;
/*     */ 
/*     */   public JBossLocalXAException()
/*     */   {
/*  47 */     this.t = null;
/*     */   }
/*     */ 
/*     */   public JBossLocalXAException(int errcode)
/*     */   {
/*  52 */     super(errcode);
/*  53 */     this.t = null;
/*     */   }
/*     */ 
/*     */   public JBossLocalXAException(String message)
/*     */   {
/*  58 */     super(message);
/*  59 */     this.t = null;
/*     */   }
/*     */ 
/*     */   public JBossLocalXAException(String message, int errorcode)
/*     */   {
/*  64 */     super(message);
/*  65 */     this.errorCode = errorcode;
/*  66 */     this.t = null;
/*     */   }
/*     */ 
/*     */   public JBossLocalXAException(String message, Throwable t)
/*     */   {
/*  71 */     super(message);
/*  72 */     this.t = t;
/*     */   }
/*     */ 
/*     */   public JBossLocalXAException(String message, int errorcode, Throwable t)
/*     */   {
/*  77 */     super(message);
/*  78 */     this.errorCode = errorcode;
/*  79 */     this.t = t;
/*     */   }
/*     */ 
/*     */   public Throwable getNested()
/*     */   {
/*  86 */     return this.t;
/*     */   }
/*     */ 
/*     */   public Throwable getCause()
/*     */   {
/*  91 */     return this.t;
/*     */   }
/*     */ 
/*     */   public String getMessage()
/*     */   {
/* 101 */     return NestedThrowable.Util.getMessage(super.getMessage(), this.t);
/*     */   }
/*     */ 
/*     */   public void printStackTrace(PrintStream stream)
/*     */   {
/* 112 */     if ((this.t == null) || (NestedThrowable.PARENT_TRACE_ENABLED))
/* 113 */       super.printStackTrace(stream);
/* 114 */     NestedThrowable.Util.print(this.t, stream);
/*     */   }
/*     */ 
/*     */   public void printStackTrace(PrintWriter writer)
/*     */   {
/* 125 */     if ((this.t == null) || (NestedThrowable.PARENT_TRACE_ENABLED))
/* 126 */       super.printStackTrace(writer);
/* 127 */     NestedThrowable.Util.print(this.t, writer);
/*     */   }
/*     */ 
/*     */   public void printStackTrace()
/*     */   {
/* 136 */     printStackTrace(System.err);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.JBossLocalXAException
 * JD-Core Version:    0.6.0
 */