/*     */ package org.jboss.resource.connectionmanager;
/*     */ 
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingException;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.annotation.ManagementObjectID;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.util.naming.NonSerializableFactory;
/*     */ 
/*     */ public class ConnectionFactoryBindingService extends ServiceMBeanSupport
/*     */   implements ConnectionFactoryBindingServiceMBean
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(ConnectionFactoryBindingService.class);
/*     */   protected ObjectName cm;
/*     */   protected String jndiName;
/*     */   protected String bindName;
/*  62 */   protected boolean useJavaContext = true;
/*     */   protected Object cf;
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/*  69 */     determineBindName();
/*  70 */     createConnectionFactory();
/*  71 */     bindConnectionFactory();
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/*  76 */     unbindConnectionFactory();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.RUNTIME})
/*     */   public ObjectName getConnectionManager() {
/*  82 */     return this.cm;
/*     */   }
/*     */ 
/*     */   public void setConnectionManager(ObjectName cm)
/*     */   {
/*  87 */     this.cm = cm;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.RUNTIME})
/*     */   public String getBindName() {
/*  93 */     return this.bindName;
/*     */   }
/*     */ 
/*     */   @ManagementObjectID(type="DataSource")
/*     */   public String getJndiName()
/*     */   {
/* 104 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/* 109 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public boolean isUseJavaContext()
/*     */   {
/* 114 */     return this.useJavaContext;
/*     */   }
/*     */ 
/*     */   public void setUseJavaContext(boolean useJavaContext)
/*     */   {
/* 119 */     this.useJavaContext = useJavaContext;
/*     */   }
/*     */ 
/*     */   protected void determineBindName()
/*     */     throws Exception
/*     */   {
/* 127 */     this.bindName = this.jndiName;
/* 128 */     if ((this.useJavaContext) && (!this.jndiName.startsWith("java:")))
/* 129 */       this.bindName = ("java:" + this.jndiName);
/*     */   }
/*     */ 
/*     */   protected void createConnectionFactory()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 139 */       BaseConnectionManager2 bcm = (BaseConnectionManager2)this.server.getAttribute(this.cm, "Instance");
/* 140 */       BaseConnectionManager2.ConnectionManagerProxy cmProxy = new BaseConnectionManager2.ConnectionManagerProxy(bcm, this.cm);
/* 141 */       this.cf = bcm.getPoolingStrategy().getManagedConnectionFactory().createConnectionFactory(cmProxy);
/*     */     }
/*     */     catch (ResourceException re)
/*     */     {
/* 145 */       throw new DeploymentException("Could not create ConnectionFactory for adapter: " + this.cm, re);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindConnectionFactory()
/*     */     throws Exception
/*     */   {
/* 154 */     InitialContext ctx = new InitialContext();
/*     */     try
/*     */     {
/* 157 */       log.debug("Binding object '" + this.cf + "' into JNDI at '" + this.bindName + "'");
/* 158 */       Name name = ctx.getNameParser("").parse(this.bindName);
/* 159 */       NonSerializableFactory.rebind(name, this.cf, true);
/* 160 */       log.info("Bound ConnectionManager '" + this.serviceName + "' to JNDI name '" + this.bindName + "'");
/*     */     }
/*     */     catch (NamingException ne)
/*     */     {
/* 164 */       throw new DeploymentException("Could not bind ConnectionFactory into jndi: " + this.bindName, ne);
/*     */     }
/*     */     finally
/*     */     {
/* 168 */       ctx.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void unbindConnectionFactory()
/*     */     throws Exception
/*     */   {
/* 177 */     InitialContext ctx = new InitialContext();
/*     */     try
/*     */     {
/* 180 */       ctx.unbind(this.bindName);
/* 181 */       NonSerializableFactory.unbind(this.bindName);
/* 182 */       log.info("Unbound ConnectionManager '" + this.serviceName + "' from JNDI name '" + this.bindName + "'");
/*     */     }
/*     */     catch (NamingException ne)
/*     */     {
/* 186 */       log.error("Could not unbind managedConnectionFactory from jndi: " + this.bindName, ne);
/*     */     }
/*     */     finally
/*     */     {
/* 190 */       ctx.close();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.ConnectionFactoryBindingService
 * JD-Core Version:    0.6.0
 */