/*    */ package org.jboss.resource.connectionmanager;
/*    */ 
/*    */ import javax.transaction.TransactionManager;
/*    */ import org.jboss.ejb.EnterpriseContext;
/*    */ import org.jboss.tm.usertx.client.ServerVMClientUserTransaction;
/*    */ 
/*    */ public class CachedConnectionManagerReference
/*    */ {
/* 39 */   private CachedConnectionManager cachedConnectionManager = new CachedConnectionManager();
/*    */   private TransactionManager transactionManager;
/*    */ 
/*    */   public CachedConnectionManager getCachedConnectionManager()
/*    */   {
/* 44 */     return this.cachedConnectionManager;
/*    */   }
/*    */ 
/*    */   public void setCachedConnectionManager(CachedConnectionManager cachedConnectionManager)
/*    */   {
/* 49 */     this.cachedConnectionManager = cachedConnectionManager;
/*    */   }
/*    */ 
/*    */   public TransactionManager getTransactionManager()
/*    */   {
/* 54 */     return this.transactionManager;
/*    */   }
/*    */ 
/*    */   public void setTransactionManager(TransactionManager transactionManager)
/*    */   {
/* 59 */     this.transactionManager = transactionManager;
/*    */   }
/*    */ 
/*    */   public void start()
/*    */   {
/* 64 */     TransactionSynchronizer.setTransactionManager(this.transactionManager);
/* 65 */     ServerVMClientUserTransaction.getSingleton().registerTxStartedListener(this.cachedConnectionManager);
/* 66 */     EnterpriseContext.setUserTransactionStartedListener(this.cachedConnectionManager);
/*    */   }
/*    */ 
/*    */   public void stop()
/*    */   {
/* 71 */     ServerVMClientUserTransaction.getSingleton().unregisterTxStartedListener(this.cachedConnectionManager);
/* 72 */     EnterpriseContext.setUserTransactionStartedListener(null);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.CachedConnectionManagerReference
 * JD-Core Version:    0.6.0
 */