/*     */ package org.jboss.resource.binding.remote;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.BinaryRefAddr;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.StringRefAddr;
/*     */ import javax.resource.Referenceable;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.invocation.InvokerInterceptor;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.proxy.ClientMethodInterceptor;
/*     */ import org.jboss.proxy.GenericProxyFactory;
/*     */ import org.jboss.resource.connectionmanager.ConnectionFactoryBindingService;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.util.naming.NonSerializableFactory;
/*     */ import org.jboss.util.naming.Util;
/*     */ 
/*     */ public class RemoteConnectionFactoryService extends ConnectionFactoryBindingService
/*     */   implements RemoteConnectionFactoryServiceMBean
/*     */ {
/*  67 */   private static Logger log = Logger.getLogger(RemoteConnectionFactoryService.class);
/*     */   private ObjectName jmxInvokerName;
/*     */   private Invoker delegateInvoker;
/*     */   private Object theProxy;
/*  79 */   private Map marshalledInvocationMapping = new HashMap();
/*     */ 
/*  82 */   private Map objectMap = new HashMap();
/*     */ 
/*     */   public ObjectName getJMXInvokerName()
/*     */   {
/*  86 */     return this.jmxInvokerName;
/*     */   }
/*     */ 
/*     */   public void setJMXInvokerName(ObjectName jmxInvokerName)
/*     */   {
/*  91 */     this.jmxInvokerName = jmxInvokerName;
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/*  96 */     determineBindName();
/*  97 */     createConnectionFactory();
/*     */ 
/*  99 */     if (this.jmxInvokerName != null)
/*     */     {
/* 101 */       createProxy();
/* 102 */       calculateHashes();
/* 103 */       bindConnectionFactory();
/*     */     }
/*     */     else
/*     */     {
/* 107 */       super.bindConnectionFactory();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 114 */     Object result = null;
/*     */ 
/* 116 */     if ((invocation instanceof MarshalledInvocation))
/*     */     {
/* 118 */       MarshalledInvocation mi = (MarshalledInvocation)invocation;
/* 119 */       mi.setMethodMap(this.marshalledInvocationMapping);
/*     */     }
/*     */ 
/* 122 */     Method targetMethod = invocation.getMethod();
/* 123 */     Class targetClass = targetMethod.getDeclaringClass();
/* 124 */     Object[] targetArguments = invocation.getArguments();
/*     */ 
/* 126 */     Object retVal = internalInvoke(targetClass, targetMethod, targetArguments, invocation.getId());
/*     */ 
/* 128 */     if ((!(retVal instanceof Serializable)) && (retVal != null))
/*     */     {
/* 130 */       log.debug("Creating proxy for instance " + retVal);
/* 131 */       result = createProxy(retVal);
/*     */     }
/*     */ 
/* 135 */     return result;
/*     */   }
/*     */ 
/*     */   private Object internalInvoke(Class clazz, Method method, Object[] arguments, Object id)
/*     */     throws Exception
/*     */   {
/* 142 */     Object result = null;
/*     */ 
/* 146 */     if (clazz.isAssignableFrom(this.cf.getClass()))
/*     */     {
/* 149 */       InitialContext initCtx = new InitialContext();
/* 150 */       Object boundCf = initCtx.lookup(this.bindName);
/* 151 */       result = method.invoke(boundCf, arguments);
/*     */ 
/* 154 */       this.objectMap.put(Integer.valueOf(String.valueOf(result.hashCode())), result);
/*     */     }
/*     */     else
/*     */     {
/* 160 */       Object target = this.objectMap.get(id);
/*     */ 
/* 162 */       if (target != null)
/*     */       {
/* 165 */         result = method.invoke(target, arguments);
/*     */ 
/* 168 */         if (method.getName().equals("close"))
/*     */         {
/* 170 */           this.objectMap.remove(id);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 177 */     return result;
/*     */   }
/*     */ 
/*     */   private void calculateHashes(Class clazz)
/*     */   {
/* 183 */     Class[] interfaces = clazz.getInterfaces();
/*     */ 
/* 185 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 187 */       Class target = interfaces[i];
/* 188 */       Map m = MarshalledInvocation.methodToHashesMap(target);
/* 189 */       this.marshalledInvocationMapping.putAll(m);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void calculateHashes()
/*     */   {
/* 196 */     Class[] cfInterfaces = this.cf.getClass().getInterfaces();
/*     */ 
/* 198 */     for (int i = 0; i < cfInterfaces.length; i++)
/*     */     {
/* 200 */       Class clazz = cfInterfaces[i];
/* 201 */       Method[] methods = clazz.getMethods();
/*     */ 
/* 203 */       for (int j = 0; j < methods.length; j++)
/*     */       {
/* 206 */         Method m = methods[j];
/* 207 */         Long hash = new Long(MarshalledInvocation.calculateHash(m));
/* 208 */         this.marshalledInvocationMapping.put(hash, m);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private Object createProxy(Object value)
/*     */     throws Exception
/*     */   {
/* 216 */     this.delegateInvoker = ((Invoker)Registry.lookup(this.jmxInvokerName));
/* 217 */     log.debug("Using delegate: " + this.delegateInvoker + " for invoker=" + this.jmxInvokerName);
/*     */ 
/* 220 */     calculateHashes(value.getClass());
/*     */ 
/* 222 */     Class[] targetInterfaces = value.getClass().getInterfaces();
/* 223 */     ArrayList interceptorList = new ArrayList();
/* 224 */     Object cacheID = new Integer(value.hashCode());
/* 225 */     String proxyBindingName = null;
/* 226 */     String jndiName = null;
/*     */ 
/* 228 */     interceptorList.add(ClientMethodInterceptor.class);
/* 229 */     interceptorList.add(InvokerInterceptor.class);
/*     */ 
/* 231 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 232 */     GenericProxyFactory proxyFactory = new GenericProxyFactory();
/*     */ 
/* 234 */     Object proxy = proxyFactory.createProxy(cacheID, this.serviceName, this.delegateInvoker, jndiName, proxyBindingName, interceptorList, loader, targetInterfaces);
/*     */ 
/* 238 */     this.objectMap.put(cacheID, value);
/*     */ 
/* 240 */     return proxy;
/*     */   }
/*     */ 
/*     */   private void createProxy()
/*     */     throws Exception
/*     */   {
/* 246 */     this.delegateInvoker = ((Invoker)Registry.lookup(this.jmxInvokerName));
/* 247 */     log.debug("Using delegate: " + this.delegateInvoker + " for invoker=" + this.jmxInvokerName);
/*     */ 
/* 249 */     ObjectName serviceName = getServiceName();
/* 250 */     Integer nameHash = Integer.valueOf(String.valueOf(serviceName.hashCode()));
/* 251 */     Registry.bind(nameHash, serviceName);
/*     */ 
/* 253 */     Object cacheID = null;
/* 254 */     String proxyBindingName = null;
/* 255 */     String jndiName = null;
/*     */ 
/* 257 */     Class[] connectionFactoryInterface = this.cf.getClass().getInterfaces();
/* 258 */     ArrayList interceptorList = new ArrayList();
/* 259 */     interceptorList.add(ClientMethodInterceptor.class);
/* 260 */     interceptorList.add(InvokerInterceptor.class);
/*     */ 
/* 262 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 263 */     GenericProxyFactory proxyFactory = new GenericProxyFactory();
/* 264 */     this.theProxy = proxyFactory.createProxy(cacheID, serviceName, this.delegateInvoker, jndiName, proxyBindingName, interceptorList, loader, connectionFactoryInterface);
/*     */   }
/*     */ 
/*     */   protected void bindConnectionFactory()
/*     */     throws Exception
/*     */   {
/* 272 */     InitialContext initCtx = new InitialContext();
/*     */     try
/*     */     {
/* 277 */       NonSerializableFactory.rebind(this.bindName, this.cf);
/* 278 */       Referenceable referenceable = (Referenceable)this.cf;
/*     */ 
/* 280 */       ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 281 */       ObjectOutputStream oos = new ObjectOutputStream(baos);
/* 282 */       oos.writeObject(this.theProxy);
/* 283 */       oos.close();
/*     */ 
/* 285 */       byte[] proxyBytes = baos.toByteArray();
/* 286 */       BinaryRefAddr dsAddr = new BinaryRefAddr("ProxyData", proxyBytes);
/* 287 */       String remoteFactoryName = RemoteConnectionFactoryHelper.class.getName();
/* 288 */       String localFactoryName = this.cf.getClass().getName();
/*     */ 
/* 290 */       Reference dsRef = new Reference(localFactoryName, dsAddr, remoteFactoryName, null);
/* 291 */       referenceable.setReference(dsRef);
/*     */ 
/* 293 */       baos.reset();
/* 294 */       ObjectOutputStream oos2 = new ObjectOutputStream(baos);
/* 295 */       oos2.writeObject(RemoteConnectionFactoryHelper.vmID);
/* 296 */       oos2.close();
/* 297 */       byte[] id = baos.toByteArray();
/* 298 */       BinaryRefAddr localAddr = new BinaryRefAddr("VMID", id);
/* 299 */       dsRef.add(localAddr);
/*     */ 
/* 301 */       StringRefAddr jndiRef = new StringRefAddr("JndiName", this.bindName);
/* 302 */       dsRef.add(jndiRef);
/* 303 */       Util.rebind(initCtx, this.bindName, this.cf);
/*     */ 
/* 305 */       log.info("Bound ConnectionManager '" + this.serviceName + "' to JNDI name '" + this.bindName + "'");
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 309 */       log.error("Could not bind ConnectionFactory into jndi: " + this.bindName, e);
/* 310 */       throw new DeploymentException("Could not bind ConnectionFactory into jndi: " + this.bindName, e);
/*     */     }
/*     */     finally
/*     */     {
/* 316 */       if (initCtx != null)
/*     */       {
/* 319 */         initCtx.close();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.binding.remote.RemoteConnectionFactoryService
 * JD-Core Version:    0.6.0
 */