/*    */ package org.jboss.resource.binding.remote;
/*    */ 
/*    */ import java.io.ByteArrayInputStream;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.rmi.server.UID;
/*    */ import java.util.Hashtable;
/*    */ import javax.naming.BinaryRefAddr;
/*    */ import javax.naming.Context;
/*    */ import javax.naming.Name;
/*    */ import javax.naming.Reference;
/*    */ import javax.naming.StringRefAddr;
/*    */ import javax.naming.spi.ObjectFactory;
/*    */ import org.jboss.util.naming.NonSerializableFactory;
/*    */ 
/*    */ public class RemoteConnectionFactoryHelper
/*    */   implements ObjectFactory
/*    */ {
/* 47 */   public static final UID vmID = new UID();
/*    */ 
/*    */   public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env)
/*    */     throws Exception
/*    */   {
/* 52 */     Object instance = null;
/*    */ 
/* 54 */     if ((obj instanceof Reference))
/*    */     {
/* 56 */       Reference ref = (Reference)obj;
/*    */ 
/* 58 */       BinaryRefAddr localID = (BinaryRefAddr)ref.get("VMID");
/* 59 */       byte[] idBytes = (byte[])(byte[])localID.getContent();
/* 60 */       ByteArrayInputStream bais = new ByteArrayInputStream(idBytes);
/* 61 */       ObjectInputStream ois = new ObjectInputStream(bais);
/* 62 */       UID id = (UID)ois.readObject();
/*    */ 
/* 64 */       if (id.equals(vmID) == true)
/*    */       {
/* 67 */         StringRefAddr jndiAddr = (StringRefAddr)ref.get("JndiName");
/* 68 */         String jndiName = (String)jndiAddr.getContent();
/* 69 */         instance = NonSerializableFactory.lookup(jndiName);
/*    */       }
/*    */       else
/*    */       {
/* 74 */         BinaryRefAddr proxyAddr = (BinaryRefAddr)ref.get("ProxyData");
/* 75 */         byte[] proxyBytes = (byte[])(byte[])proxyAddr.getContent();
/* 76 */         ByteArrayInputStream bais2 = new ByteArrayInputStream(proxyBytes);
/* 77 */         ObjectInputStream ois2 = new ObjectInputStream(bais2);
/* 78 */         instance = ois2.readObject();
/*    */       }
/*    */     }
/* 81 */     return instance;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.binding.remote.RemoteConnectionFactoryHelper
 * JD-Core Version:    0.6.0
 */