/*    */ package org.jboss.resource.adapter.jms.inflow.dlq;
/*    */ 
/*    */ import javax.jms.Message;
/*    */ import javax.naming.Context;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.resource.adapter.jms.inflow.JmsActivation;
/*    */ import org.jboss.resource.adapter.jms.inflow.JmsActivationSpec;
/*    */ 
/*    */ public class JBossMQDLQHandler extends AbstractDLQHandler
/*    */ {
/*    */   protected static final String JMS_JBOSS_REDELIVERY_COUNT = "JMS_JBOSS_REDELIVERY_COUNT";
/*    */   protected static final String JMS_JBOSS_REDELIVERY_LIMIT = "JMS_JBOSS_REDELIVERY_LIMIT";
/*    */   protected int maxResent;
/*    */ 
/*    */   public void setup(JmsActivation activation, Context ctx)
/*    */     throws Exception
/*    */   {
/* 48 */     super.setup(activation, ctx);
/* 49 */     this.maxResent = activation.getActivationSpec().getDLQMaxResent();
/*    */   }
/*    */ 
/*    */   protected boolean handleDelivery(Message msg)
/*    */   {
/* 54 */     int max = this.maxResent;
/*    */     try
/*    */     {
/* 57 */       if (msg.propertyExists("JMS_JBOSS_REDELIVERY_LIMIT")) {
/* 58 */         max = msg.getIntProperty("JMS_JBOSS_REDELIVERY_LIMIT");
/*    */       }
/* 60 */       if (msg.propertyExists("JMS_JBOSS_REDELIVERY_COUNT"))
/*    */       {
/* 62 */         int count = msg.getIntProperty("JMS_JBOSS_REDELIVERY_COUNT");
/*    */ 
/* 64 */         if (count > max)
/*    */         {
/* 66 */           warnDLQ(msg, count, max);
/* 67 */           return true;
/*    */         }
/*    */       }
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 73 */       log.warn("Unexpected error retrieving message properties " + msg, t);
/*    */     }
/* 75 */     return false;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.inflow.dlq.JBossMQDLQHandler
 * JD-Core Version:    0.6.0
 */