/*     */ package org.jboss.resource.adapter.jms.inflow.dlq;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Message;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class GenericDLQHandler extends JBossMQDLQHandler
/*     */ {
/*     */   protected HashMap resent;
/*     */ 
/*     */   public GenericDLQHandler()
/*     */   {
/*  38 */     this.resent = new HashMap();
/*     */   }
/*     */ 
/*     */   public void messageDelivered(Message msg)
/*     */   {
/*     */     try {
/*  44 */       String id = msg.getJMSMessageID();
/*  45 */       if (id == null)
/*     */       {
/*  47 */         log.error("Message id is null? " + msg);
/*  48 */         return;
/*     */       }
/*     */ 
/*  51 */       clearResentCounter(id);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  55 */       log.warn("Unexpected error processing delivery notification " + msg, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean handleDelivery(Message msg)
/*     */   {
/*  62 */     boolean handled = super.handleDelivery(msg);
/*  63 */     if (handled) {
/*  64 */       return true;
/*     */     }
/*     */     try
/*     */     {
/*  68 */       if (msg.propertyExists("JMS_JBOSS_REDELIVERY_COUNT")) {
/*  69 */         return false;
/*     */       }
/*  71 */       String id = msg.getJMSMessageID();
/*  72 */       if (id == null)
/*     */       {
/*  74 */         log.error("Message id is null? " + msg);
/*  75 */         return false;
/*     */       }
/*     */ 
/*  78 */       int count = 0;
/*     */       try
/*     */       {
/*  82 */         if (msg.propertyExists("JMSXDeliveryCount"))
/*  83 */           count = msg.getIntProperty("JMSXDeliveryCount") - 1;
/*     */       }
/*     */       catch (JMSException ignored)
/*     */       {
/*  87 */         count = incrementResentCounter(id);
/*     */       }
/*     */ 
/*  90 */       int max = this.maxResent;
/*  91 */       if (msg.propertyExists("JMS_JBOSS_REDELIVERY_LIMIT")) {
/*  92 */         max = msg.getIntProperty("JMS_JBOSS_REDELIVERY_LIMIT");
/*     */       }
/*  94 */       if (count > max)
/*     */       {
/*  96 */         warnDLQ(msg, count, max);
/*  97 */         clearResentCounter(id);
/*  98 */         return true;
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 103 */       log.warn("Unexpected error checking whether dlq should be used " + msg, t);
/*     */     }
/*     */ 
/* 106 */     return false;
/*     */   }
/*     */ 
/*     */   protected int incrementResentCounter(String id)
/*     */   {
/*     */     ResentInfo info;
/* 117 */     synchronized (this.resent)
/*     */     {
/* 119 */       info = (ResentInfo)this.resent.get(id);
/* 120 */       if (info == null)
/*     */       {
/* 122 */         info = new ResentInfo();
/* 123 */         this.resent.put(id, info);
/*     */       }
/*     */     }
/* 126 */     return ++info.count;
/*     */   }
/*     */ 
/*     */   protected void clearResentCounter(String id)
/*     */   {
/* 136 */     synchronized (this.resent)
/*     */     {
/* 138 */       this.resent.remove(id);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static class ResentInfo
/*     */   {
/* 147 */     int count = 0;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.inflow.dlq.GenericDLQHandler
 * JD-Core Version:    0.6.0
 */