/*     */ package org.jboss.resource.adapter.jms.inflow;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import javax.jms.Connection;
/*     */ import javax.jms.ConnectionConsumer;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Queue;
/*     */ import javax.jms.ServerSession;
/*     */ import javax.jms.ServerSessionPool;
/*     */ import javax.jms.Topic;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JmsServerSessionPool
/*     */   implements ServerSessionPool
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(JmsServerSessionPool.class);
/*     */   JmsActivation activation;
/*     */   ConnectionConsumer consumer;
/*  54 */   ArrayList serverSessions = new ArrayList();
/*     */ 
/*  57 */   boolean stopped = false;
/*     */ 
/*  60 */   int sessionCount = 0;
/*     */ 
/*     */   public JmsServerSessionPool(JmsActivation activation)
/*     */   {
/*  70 */     this.activation = activation;
/*     */   }
/*     */ 
/*     */   public JmsActivation getActivation()
/*     */   {
/*  78 */     return this.activation;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*  88 */     setupSessions();
/*  89 */     setupConsumer();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*  97 */     teardownConsumer();
/*  98 */     teardownSessions();
/*     */   }
/*     */ 
/*     */   public ServerSession getServerSession() throws JMSException
/*     */   {
/* 103 */     boolean trace = log.isTraceEnabled();
/* 104 */     if (trace) {
/* 105 */       log.trace("getServerSession");
/*     */     }
/* 107 */     ServerSession result = null;
/*     */     try
/*     */     {
/* 111 */       synchronized (this.serverSessions)
/*     */       {
/*     */         while (true)
/*     */         {
/* 115 */           int sessionsSize = this.serverSessions.size();
/*     */ 
/* 117 */           if (this.stopped) {
/* 118 */             throw new Exception("Cannot get a server session after the pool is stopped");
/*     */           }
/* 120 */           if (sessionsSize > 0)
/*     */           {
/* 122 */             result = (ServerSession)this.serverSessions.remove(sessionsSize - 1);
/* 123 */             break;
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 130 */             this.serverSessions.wait();
/*     */           }
/*     */           catch (InterruptedException ignored)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 141 */       log.error("Unable to get a server session", t);
/* 142 */       throw new JMSException("Unable to get a server session " + t);
/*     */     }
/*     */ 
/* 145 */     if (trace) {
/* 146 */       log.trace("Returning server session " + result);
/*     */     }
/* 148 */     return result;
/*     */   }
/*     */ 
/*     */   protected void returnServerSession(JmsServerSession session)
/*     */   {
/* 158 */     synchronized (this.serverSessions)
/*     */     {
/* 160 */       if (this.stopped)
/*     */       {
/* 162 */         session.teardown();
/* 163 */         this.sessionCount -= 1;
/*     */       }
/*     */       else {
/* 166 */         this.serverSessions.add(session);
/* 167 */       }this.serverSessions.notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setupSessions()
/*     */     throws Exception
/*     */   {
/* 178 */     JmsActivationSpec spec = this.activation.getActivationSpec();
/* 179 */     ArrayList clonedSessions = null;
/*     */ 
/* 182 */     synchronized (this.serverSessions)
/*     */     {
/* 184 */       for (int i = 0; i < spec.getMaxSessionInt(); i++)
/*     */       {
/* 186 */         JmsServerSession session = new JmsServerSession(this);
/* 187 */         this.serverSessions.add(session);
/*     */       }
/* 189 */       this.sessionCount = this.serverSessions.size();
/* 190 */       clonedSessions = (ArrayList)this.serverSessions.clone();
/*     */     }
/*     */ 
/* 195 */     for (int i = 0; i < clonedSessions.size(); i++)
/*     */     {
/* 197 */       JmsServerSession session = (JmsServerSession)clonedSessions.get(i);
/* 198 */       session.setup();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void teardownSessions()
/*     */   {
/* 207 */     synchronized (this.serverSessions)
/*     */     {
/* 210 */       this.stopped = true;
/* 211 */       this.serverSessions.notifyAll();
/*     */ 
/* 214 */       for (int i = 0; i < this.serverSessions.size(); i++)
/*     */       {
/* 216 */         JmsServerSession session = (JmsServerSession)this.serverSessions.get(i);
/* 217 */         session.teardown();
/*     */       }
/*     */ 
/* 220 */       this.sessionCount -= this.serverSessions.size();
/* 221 */       this.serverSessions.clear();
/*     */ 
/* 223 */       if (this.activation.getActivationSpec().isForceClearOnShutdown())
/*     */       {
/* 225 */         int attempts = 0;
/* 226 */         int forceClearAttempts = this.activation.getActivationSpec().getForceClearAttempts();
/* 227 */         long forceClearInterval = this.activation.getActivationSpec().getForceClearOnShutdownInterval();
/*     */ 
/* 229 */         log.info("Force clear behavior in effect. Waiting for " + forceClearInterval + " milliseconds for " + forceClearAttempts + " attempts.");
/*     */ 
/* 231 */         while ((this.sessionCount > 0) && (attempts < forceClearAttempts))
/*     */         {
/*     */           try
/*     */           {
/* 235 */             this.serverSessions.wait(forceClearInterval);
/* 236 */             log.trace("Clear attempt " + attempts);
/* 237 */             attempts++;
/*     */           }
/*     */           catch (InterruptedException ignore)
/*     */           {
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 249 */         while (this.sessionCount > 0)
/*     */         {
/*     */           try
/*     */           {
/* 253 */             this.serverSessions.wait();
/*     */           }
/*     */           catch (InterruptedException ignore)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setupConsumer()
/*     */     throws Exception
/*     */   {
/* 270 */     Connection connection = this.activation.getConnection();
/* 271 */     JmsActivationSpec spec = this.activation.getActivationSpec();
/* 272 */     String selector = spec.getMessageSelector();
/* 273 */     int maxMessages = spec.getMaxMessagesInt();
/* 274 */     if (spec.isTopic())
/*     */     {
/* 276 */       Topic topic = (Topic)this.activation.getDestination();
/* 277 */       String subscriptionName = spec.getSubscriptionName();
/* 278 */       if (spec.isDurable())
/* 279 */         this.consumer = connection.createDurableConnectionConsumer(topic, subscriptionName, selector, this, maxMessages);
/*     */       else
/* 281 */         this.consumer = connection.createConnectionConsumer(topic, selector, this, maxMessages);
/*     */     }
/*     */     else
/*     */     {
/* 285 */       Queue queue = (Queue)this.activation.getDestination();
/* 286 */       this.consumer = connection.createConnectionConsumer(queue, selector, this, maxMessages);
/*     */     }
/* 288 */     log.debug("Created consumer " + this.consumer);
/*     */   }
/*     */ 
/*     */   protected void teardownConsumer()
/*     */   {
/*     */     try
/*     */     {
/* 298 */       if (this.consumer != null)
/*     */       {
/* 300 */         log.debug("Closing the " + this.consumer);
/* 301 */         this.consumer.close();
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 306 */       log.debug("Error closing the consumer " + this.consumer, t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.inflow.JmsServerSessionPool
 * JD-Core Version:    0.6.0
 */