/*     */ package org.jboss.resource.adapter.jms.inflow;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.concurrent.atomic.AtomicBoolean;
/*     */ import javax.jms.Connection;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.ExceptionListener;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageListener;
/*     */ import javax.jms.Queue;
/*     */ import javax.jms.QueueConnection;
/*     */ import javax.jms.QueueConnectionFactory;
/*     */ import javax.jms.Topic;
/*     */ import javax.jms.TopicConnection;
/*     */ import javax.jms.TopicConnectionFactory;
/*     */ import javax.jms.XAQueueConnectionFactory;
/*     */ import javax.jms.XATopicConnectionFactory;
/*     */ import javax.management.Notification;
/*     */ import javax.naming.Context;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.endpoint.MessageEndpointFactory;
/*     */ import javax.resource.spi.work.Work;
/*     */ import javax.resource.spi.work.WorkManager;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.jms.jndi.JMSProviderAdapter;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
/*     */ import org.jboss.resource.adapter.jms.JmsResourceAdapter;
/*     */ import org.jboss.tm.TransactionManagerLocator;
/*     */ import org.jboss.util.Strings;
/*     */ import org.jboss.util.naming.Util;
/*     */ 
/*     */ public class JmsActivation
/*     */   implements ExceptionListener
/*     */ {
/*  66 */   private static final Logger log = Logger.getLogger(JmsActivation.class);
/*     */   private static final String CONNECTING_NOTIFICATION = "org.jboss.ejb.plugins.jms.CONNECTING";
/*     */   private static final String CONNECTED_NOTIFICATION = "org.jboss.ejb.plugins.jms.CONNECTED";
/*     */   private static final String DISCONNECTING_NOTIFICATION = "org.jboss.ejb.plugins.jms.DISCONNECTING";
/*     */   private static final String DISCONNECTED_NOTIFICATION = "org.jboss.ejb.plugins.jms.DISCONNECTED";
/*     */   private static final String FAILURE_NOTIFICATION = "org.jboss.ejb.plugins.jms.FAILURE";
/*     */   public static final Method ONMESSAGE;
/*     */   protected JmsResourceAdapter ra;
/*     */   protected JmsActivationSpec spec;
/*     */   protected MessageEndpointFactory endpointFactory;
/*     */   protected JBossNotificationBroadcasterSupport emitter;
/*  99 */   protected AtomicBoolean deliveryActive = new AtomicBoolean(false);
/*     */ 
/* 102 */   private AtomicBoolean inFailure = new AtomicBoolean(false);
/*     */   protected JMSProviderAdapter adapter;
/*     */   protected Destination destination;
/*     */   protected Connection connection;
/*     */   protected JmsServerSessionPool pool;
/*     */   protected boolean isDeliveryTransacted;
/*     */   protected DLQHandler dlqHandler;
/*     */   protected TransactionManager tm;
/*     */ 
/*     */   public JmsActivation(JmsResourceAdapter ra, MessageEndpointFactory endpointFactory, JmsActivationSpec spec)
/*     */     throws ResourceException
/*     */   {
/* 140 */     this.ra = ra;
/* 141 */     this.endpointFactory = endpointFactory;
/* 142 */     this.spec = spec;
/*     */     try
/*     */     {
/* 145 */       this.isDeliveryTransacted = endpointFactory.isDeliveryTransacted(ONMESSAGE);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 149 */       throw new ResourceException(e);
/*     */     }
/* 151 */     if ((endpointFactory instanceof JBossNotificationBroadcasterSupport))
/* 152 */       this.emitter = ((JBossNotificationBroadcasterSupport)endpointFactory);
/*     */   }
/*     */ 
/*     */   public JmsActivationSpec getActivationSpec()
/*     */   {
/* 160 */     return this.spec;
/*     */   }
/*     */ 
/*     */   public MessageEndpointFactory getMessageEndpointFactory()
/*     */   {
/* 168 */     return this.endpointFactory;
/*     */   }
/*     */ 
/*     */   public boolean isDeliveryTransacted()
/*     */   {
/* 176 */     return this.isDeliveryTransacted;
/*     */   }
/*     */ 
/*     */   public WorkManager getWorkManager()
/*     */   {
/* 184 */     return this.ra.getWorkManager();
/*     */   }
/*     */ 
/*     */   public TransactionManager getTransactionManager()
/*     */   {
/* 189 */     if (this.tm == null)
/* 190 */       this.tm = TransactionManagerLocator.locateTransactionManager();
/* 191 */     return this.tm;
/*     */   }
/*     */ 
/*     */   public Connection getConnection()
/*     */   {
/* 199 */     return this.connection;
/*     */   }
/*     */ 
/*     */   public Destination getDestination()
/*     */   {
/* 207 */     return this.destination;
/*     */   }
/*     */ 
/*     */   public JMSProviderAdapter getProviderAdapter()
/*     */   {
/* 215 */     return this.adapter;
/*     */   }
/*     */ 
/*     */   public DLQHandler getDLQHandler()
/*     */   {
/* 223 */     return this.dlqHandler;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws ResourceException
/*     */   {
/* 233 */     this.deliveryActive.set(true);
/* 234 */     this.ra.getWorkManager().scheduleWork(new SetupActivation(null));
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 242 */     this.deliveryActive.set(false);
/* 243 */     teardown();
/*     */   }
/*     */ 
/*     */   public void handleFailure(Throwable failure)
/*     */   {
/* 253 */     log.warn("Failure in jms activation " + this.spec, failure);
/* 254 */     int reconnectCount = 0;
/*     */ 
/* 257 */     if (this.inFailure.getAndSet(true))
/* 258 */       return;
/*     */     try
/*     */     {
/* 261 */       while ((this.deliveryActive.get()) && (reconnectCount < this.spec.getReconnectAttempts()))
/*     */       {
/* 263 */         teardown();
/*     */ 
/* 265 */         sendNotification("org.jboss.ejb.plugins.jms.FAILURE", failure);
/*     */         try
/*     */         {
/* 269 */           Thread.sleep(this.spec.getReconnectIntervalLong());
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/* 273 */           log.debug("Interrupted trying to reconnect " + this.spec, e);
/* 274 */           break;
/*     */         }
/*     */ 
/* 277 */         log.info("Attempting to reconnect " + this.spec);
/*     */         try
/*     */         {
/* 280 */           setup();
/* 281 */           log.info("Reconnected with messaging provider.");
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 286 */           log.error("Unable to reconnect " + this.spec, t);
/*     */         }
/* 288 */         reconnectCount++;
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 294 */       this.inFailure.set(false);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void onException(JMSException exception)
/*     */   {
/* 300 */     handleFailure(exception);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 305 */     StringBuffer buffer = new StringBuffer();
/* 306 */     buffer.append(Strings.defaultToString(this)).append('(');
/* 307 */     buffer.append("spec=").append(Strings.defaultToString(this.spec));
/* 308 */     buffer.append(" mepf=").append(Strings.defaultToString(this.endpointFactory));
/* 309 */     buffer.append(" active=").append(this.deliveryActive.get());
/* 310 */     if (this.destination != null)
/* 311 */       buffer.append(" destination=").append(this.destination);
/* 312 */     if (this.connection != null)
/* 313 */       buffer.append(" connection=").append(this.connection);
/* 314 */     if (this.pool != null)
/* 315 */       buffer.append(" pool=").append(Strings.defaultToString(this.pool));
/* 316 */     if (this.dlqHandler != null)
/* 317 */       buffer.append(" dlq=").append(Strings.defaultToString(this.dlqHandler));
/* 318 */     buffer.append(" transacted=").append(this.isDeliveryTransacted);
/* 319 */     buffer.append(')');
/* 320 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   protected void setup()
/*     */     throws Exception
/*     */   {
/* 330 */     log.debug("Setting up " + this.spec);
/*     */ 
/* 332 */     sendNotification("org.jboss.ejb.plugins.jms.CONNECTING", null);
/*     */ 
/* 334 */     setupJMSProviderAdapter();
/* 335 */     Context ctx = this.adapter.getInitialContext();
/* 336 */     log.debug("Using context " + ctx.getEnvironment() + " for " + this.spec);
/*     */     try
/*     */     {
/* 339 */       setupDLQ(ctx);
/* 340 */       setupDestination(ctx);
/* 341 */       setupConnection(ctx);
/*     */     }
/*     */     finally
/*     */     {
/* 345 */       ctx.close();
/*     */     }
/* 347 */     setupSessionPool();
/*     */ 
/* 349 */     log.debug("Setup complete " + this);
/*     */ 
/* 351 */     sendNotification("org.jboss.ejb.plugins.jms.CONNECTED", null);
/*     */   }
/*     */ 
/*     */   protected void teardown()
/*     */   {
/* 359 */     log.debug("Tearing down " + this.spec);
/*     */ 
/* 361 */     sendNotification("org.jboss.ejb.plugins.jms.DISCONNECTING", null);
/*     */ 
/* 363 */     teardownSessionPool();
/* 364 */     teardownConnection();
/* 365 */     teardownDestination();
/* 366 */     teardownDLQ();
/*     */ 
/* 368 */     log.debug("Tearing down complete " + this);
/*     */ 
/* 370 */     sendNotification("org.jboss.ejb.plugins.jms.DISCONNECTED", null);
/*     */   }
/*     */ 
/*     */   protected void setupJMSProviderAdapter()
/*     */     throws Exception
/*     */   {
/* 380 */     String providerAdapterJNDI = this.spec.getProviderAdapterJNDI();
/* 381 */     if (!providerAdapterJNDI.startsWith("java:")) {
/* 382 */       providerAdapterJNDI = "java:" + providerAdapterJNDI;
/*     */     }
/* 384 */     log.debug("Retrieving the jms provider adapter " + providerAdapterJNDI + " for " + this);
/* 385 */     this.adapter = ((JMSProviderAdapter)Util.lookup(providerAdapterJNDI, JMSProviderAdapter.class));
/* 386 */     log.debug("Using jms provider adapter " + this.adapter + " for " + this);
/*     */   }
/*     */ 
/*     */   protected void setupDLQ(Context ctx)
/*     */     throws Exception
/*     */   {
/* 397 */     if (this.spec.isUseDLQ())
/*     */     {
/* 399 */       Class clazz = Thread.currentThread().getContextClassLoader().loadClass(this.spec.getDLQHandler());
/* 400 */       this.dlqHandler = ((DLQHandler)clazz.newInstance());
/* 401 */       this.dlqHandler.setup(this, ctx);
/*     */     }
/*     */ 
/* 404 */     log.debug("Setup DLQ " + this);
/*     */   }
/*     */ 
/*     */   protected void teardownDLQ()
/*     */   {
/* 412 */     log.debug("Removing DLQ " + this);
/*     */     try
/*     */     {
/* 415 */       if (this.dlqHandler != null)
/* 416 */         this.dlqHandler.teardown();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 420 */       log.debug("Error tearing down the DLQ " + this.dlqHandler, t);
/*     */     }
/* 422 */     this.dlqHandler = null;
/*     */   }
/*     */ 
/*     */   protected void setupDestination(Context ctx)
/*     */     throws Exception
/*     */   {
/*     */     Class destinationType;
/*     */     Class destinationType;
/* 434 */     if (this.spec.isTopic())
/* 435 */       destinationType = Topic.class;
/*     */     else {
/* 437 */       destinationType = Queue.class;
/*     */     }
/* 439 */     String destinationName = this.spec.getDestination();
/* 440 */     log.debug("Retrieving destination " + destinationName + " of type " + destinationType.getName());
/* 441 */     this.destination = ((Destination)Util.lookup(ctx, destinationName, destinationType));
/* 442 */     log.debug("Got destination " + this.destination + " from " + destinationName);
/*     */   }
/*     */ 
/*     */   protected void teardownDestination()
/*     */   {
/* 450 */     this.destination = null;
/*     */   }
/*     */ 
/*     */   protected void setupConnection(Context ctx)
/*     */     throws Exception
/*     */   {
/* 461 */     log.debug("setup connection " + this);
/*     */ 
/* 463 */     String user = this.spec.getUser();
/* 464 */     String pass = this.spec.getPassword();
/* 465 */     String clientID = this.spec.getClientId();
/* 466 */     if (this.spec.isTopic())
/* 467 */       this.connection = setupTopicConnection(ctx, user, pass, clientID);
/*     */     else {
/* 469 */       this.connection = setupQueueConnection(ctx, user, pass, clientID);
/*     */     }
/* 471 */     log.debug("established connection " + this);
/*     */   }
/*     */ 
/*     */   protected QueueConnection setupQueueConnection(Context ctx, String user, String pass, String clientID)
/*     */     throws Exception
/*     */   {
/* 486 */     String queueFactoryRef = this.adapter.getQueueFactoryRef();
/* 487 */     log.debug("Attempting to lookup queue connection factory " + queueFactoryRef);
/* 488 */     QueueConnectionFactory qcf = (QueueConnectionFactory)Util.lookup(ctx, queueFactoryRef, QueueConnectionFactory.class);
/* 489 */     log.debug("Got queue connection factory " + qcf + " from " + queueFactoryRef);
/* 490 */     log.debug("Attempting to create queue connection with user " + user);
/*     */     QueueConnection result;
/*     */     QueueConnection result;
/* 492 */     if (((qcf instanceof XAQueueConnectionFactory)) && (this.isDeliveryTransacted))
/*     */     {
/* 494 */       XAQueueConnectionFactory xaqcf = (XAQueueConnectionFactory)qcf;
/*     */       QueueConnection result;
/* 495 */       if (user != null)
/* 496 */         result = xaqcf.createXAQueueConnection(user, pass);
/*     */       else
/* 498 */         result = xaqcf.createXAQueueConnection();
/*     */     }
/*     */     else
/*     */     {
/*     */       QueueConnection result;
/* 502 */       if (user != null)
/* 503 */         result = qcf.createQueueConnection(user, pass);
/*     */       else
/* 505 */         result = qcf.createQueueConnection();
/*     */     }
/*     */     try
/*     */     {
/* 509 */       if (clientID != null)
/* 510 */         result.setClientID(clientID);
/* 511 */       result.setExceptionListener(this);
/* 512 */       log.debug("Using queue connection " + result);
/* 513 */       return result;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */       try
/*     */       {
/* 519 */         result.close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 523 */         log.trace("Ignored error closing connection", e);
/*     */       }
/* 525 */       if ((t instanceof Exception))
/* 526 */         throw ((Exception)t); 
/*     */     }
/* 527 */     throw new RuntimeException("Error configuring connection", t);
/*     */   }
/*     */ 
/*     */   protected TopicConnection setupTopicConnection(Context ctx, String user, String pass, String clientID)
/*     */     throws Exception
/*     */   {
/* 543 */     String topicFactoryRef = this.adapter.getTopicFactoryRef();
/* 544 */     log.debug("Attempting to lookup topic connection factory " + topicFactoryRef);
/* 545 */     TopicConnectionFactory tcf = (TopicConnectionFactory)Util.lookup(ctx, topicFactoryRef, TopicConnectionFactory.class);
/* 546 */     log.debug("Got topic connection factory " + tcf + " from " + topicFactoryRef);
/* 547 */     log.debug("Attempting to create topic connection with user " + user);
/*     */     TopicConnection result;
/*     */     TopicConnection result;
/* 549 */     if (((tcf instanceof XATopicConnectionFactory)) && (this.isDeliveryTransacted))
/*     */     {
/* 551 */       XATopicConnectionFactory xatcf = (XATopicConnectionFactory)tcf;
/*     */       TopicConnection result;
/* 552 */       if (user != null)
/* 553 */         result = xatcf.createXATopicConnection(user, pass);
/*     */       else
/* 555 */         result = xatcf.createXATopicConnection();
/*     */     }
/*     */     else
/*     */     {
/*     */       TopicConnection result;
/* 559 */       if (user != null)
/* 560 */         result = tcf.createTopicConnection(user, pass);
/*     */       else
/* 562 */         result = tcf.createTopicConnection();
/*     */     }
/*     */     try
/*     */     {
/* 566 */       if (clientID != null)
/* 567 */         result.setClientID(clientID);
/* 568 */       result.setExceptionListener(this);
/* 569 */       log.debug("Using topic connection " + result);
/* 570 */       return result;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */       try
/*     */       {
/* 576 */         result.close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 580 */         log.trace("Ignored error closing connection", e);
/*     */       }
/* 582 */       if ((t instanceof Exception))
/* 583 */         throw ((Exception)t); 
/*     */     }
/* 584 */     throw new RuntimeException("Error configuring connection", t);
/*     */   }
/*     */ 
/*     */   protected void teardownConnection()
/*     */   {
/*     */     try
/*     */     {
/* 595 */       if (this.connection != null)
/*     */       {
/* 597 */         log.debug("Closing the " + this.connection);
/* 598 */         this.connection.close();
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 603 */       log.debug("Error closing the connection " + this.connection, t);
/*     */     }
/* 605 */     this.connection = null;
/*     */   }
/*     */ 
/*     */   protected void setupSessionPool()
/*     */     throws Exception
/*     */   {
/* 615 */     this.pool = new JmsServerSessionPool(this);
/* 616 */     log.debug("Created session pool " + this.pool);
/*     */ 
/* 618 */     log.debug("Starting session pool " + this.pool);
/* 619 */     this.pool.start();
/* 620 */     log.debug("Started session pool " + this.pool);
/*     */ 
/* 622 */     log.debug("Starting delivery " + this.connection);
/* 623 */     this.connection.start();
/* 624 */     log.debug("Started delivery " + this.connection);
/*     */   }
/*     */ 
/*     */   protected void teardownSessionPool()
/*     */   {
/*     */     try
/*     */     {
/* 634 */       if (this.connection != null)
/*     */       {
/* 636 */         log.debug("Stopping delivery " + this.connection);
/* 637 */         this.connection.stop();
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 642 */       log.debug("Error stopping delivery " + this.connection, t);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 647 */       if (this.pool != null)
/*     */       {
/* 649 */         log.debug("Stopping the session pool " + this.pool);
/* 650 */         this.pool.stop();
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 655 */       log.debug("Error clearing the pool " + this.pool, t);
/*     */     }
/* 657 */     this.pool = null;
/*     */   }
/*     */ 
/*     */   protected void sendNotification(String event, Object userData)
/*     */   {
/* 668 */     if (this.emitter == null) {
/* 669 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 673 */       Notification notif = new Notification(event, this.spec, this.emitter.nextNotificationSequenceNumber());
/* 674 */       notif.setUserData(userData);
/* 675 */       this.emitter.sendNotification(notif);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 679 */       log.warn("Error sending notification: " + event, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/* 130 */       ONMESSAGE = MessageListener.class.getMethod("onMessage", new Class[] { Message.class });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 134 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private class SetupActivation
/*     */     implements Work
/*     */   {
/*     */     private SetupActivation()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/* 692 */         JmsActivation.this.setup();
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 696 */         JmsActivation.this.handleFailure(t);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void release()
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.inflow.JmsActivation
 * JD-Core Version:    0.6.0
 */