/*     */ package org.jboss.resource.adapter.jms;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import javax.jms.ConnectionConsumer;
/*     */ import javax.jms.ConnectionMetaData;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.ExceptionListener;
/*     */ import javax.jms.IllegalStateException;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Queue;
/*     */ import javax.jms.QueueSession;
/*     */ import javax.jms.ServerSessionPool;
/*     */ import javax.jms.Session;
/*     */ import javax.jms.TemporaryQueue;
/*     */ import javax.jms.TemporaryTopic;
/*     */ import javax.jms.Topic;
/*     */ import javax.jms.TopicSession;
/*     */ import javax.naming.Reference;
/*     */ import javax.resource.Referenceable;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionManager;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JmsSessionFactoryImpl
/*     */   implements JmsSessionFactory, Referenceable
/*     */ {
/*  60 */   private static final Logger log = Logger.getLogger(JmsSessionFactoryImpl.class);
/*     */ 
/*  63 */   private boolean closed = false;
/*     */ 
/*  66 */   private boolean trace = log.isTraceEnabled();
/*     */   private Reference reference;
/*     */   private String userName;
/*     */   private String password;
/*     */   private String clientID;
/*     */   private int type;
/*  77 */   private boolean started = false;
/*     */   private JmsManagedConnectionFactory mcf;
/*     */   private ConnectionManager cm;
/*  86 */   private HashSet sessions = new HashSet();
/*     */ 
/*  89 */   private HashSet tempQueues = new HashSet();
/*     */ 
/*  92 */   private HashSet tempTopics = new HashSet();
/*     */ 
/*     */   public JmsSessionFactoryImpl(ManagedConnectionFactory mcf, ConnectionManager cm, int type)
/*     */   {
/*  98 */     this.mcf = ((JmsManagedConnectionFactory)mcf);
/*  99 */     this.cm = cm;
/*     */ 
/* 101 */     if (cm == null)
/*     */     {
/* 103 */       this.cm = new JmsConnectionManager();
/*     */     }
/* 105 */     else this.cm = cm;
/*     */ 
/* 107 */     this.type = type;
/*     */ 
/* 109 */     if (this.trace)
/* 110 */       log.trace("mcf=" + mcf + ", cm=" + cm + ", type=" + type);
/*     */   }
/*     */ 
/*     */   public void setReference(Reference reference)
/*     */   {
/* 115 */     this.reference = reference;
/*     */   }
/*     */ 
/*     */   public Reference getReference()
/*     */   {
/* 120 */     return this.reference;
/*     */   }
/*     */ 
/*     */   public void setUserName(String name)
/*     */   {
/* 127 */     this.userName = name;
/*     */   }
/*     */ 
/*     */   public void setPassword(String password)
/*     */   {
/* 132 */     this.password = password;
/*     */   }
/*     */ 
/*     */   public QueueSession createQueueSession(boolean transacted, int acknowledgeMode)
/*     */     throws JMSException
/*     */   {
/* 141 */     checkClosed();
/* 142 */     if (this.type == 2)
/* 143 */       throw new IllegalStateException("Can not get a queue session from a topic connection");
/* 144 */     return allocateConnection(transacted, acknowledgeMode, this.type);
/*     */   }
/*     */ 
/*     */   public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages)
/*     */     throws JMSException
/*     */   {
/* 154 */     throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
/*     */   }
/*     */ 
/*     */   public TopicSession createTopicSession(boolean transacted, int acknowledgeMode)
/*     */     throws JMSException
/*     */   {
/* 163 */     checkClosed();
/* 164 */     if (this.type == 1)
/* 165 */       throw new IllegalStateException("Can not get a topic session from a queue connection");
/* 166 */     return allocateConnection(transacted, acknowledgeMode, this.type);
/*     */   }
/*     */ 
/*     */   public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages)
/*     */     throws JMSException
/*     */   {
/* 176 */     throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
/*     */   }
/*     */ 
/*     */   public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages)
/*     */     throws JMSException
/*     */   {
/* 187 */     throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
/*     */   }
/*     */ 
/*     */   public String getClientID()
/*     */     throws JMSException
/*     */   {
/* 194 */     checkClosed();
/* 195 */     return this.clientID;
/*     */   }
/*     */ 
/*     */   public void setClientID(String cID) throws JMSException
/*     */   {
/* 200 */     if (this.mcf.isStrict()) {
/* 201 */       throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
/*     */     }
/* 203 */     checkClosed();
/* 204 */     if (this.clientID != null)
/* 205 */       throw new IllegalStateException("Cannot change client id");
/* 206 */     this.clientID = cID;
/*     */   }
/*     */ 
/*     */   public ConnectionMetaData getMetaData() throws JMSException
/*     */   {
/* 211 */     checkClosed();
/* 212 */     return this.mcf.getMetaData();
/*     */   }
/*     */ 
/*     */   public ExceptionListener getExceptionListener() throws JMSException
/*     */   {
/* 217 */     throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
/*     */   }
/*     */ 
/*     */   public void setExceptionListener(ExceptionListener listener)
/*     */     throws JMSException
/*     */   {
/* 223 */     throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
/*     */   }
/*     */ 
/*     */   public void start() throws JMSException
/*     */   {
/* 228 */     checkClosed();
/* 229 */     if (this.trace)
/* 230 */       log.trace("start() " + this);
/*     */     Iterator i;
/* 231 */     synchronized (this.sessions)
/*     */     {
/* 233 */       if (this.started)
/* 234 */         return;
/* 235 */       this.started = true;
/* 236 */       for (i = this.sessions.iterator(); i.hasNext(); )
/*     */       {
/* 238 */         JmsSession session = (JmsSession)i.next();
/* 239 */         session.start();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws JMSException
/*     */   {
/* 246 */     if (this.mcf.isStrict())
/* 247 */       throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
/* 248 */     checkClosed();
/* 249 */     if (this.trace)
/* 250 */       log.trace("stop() " + this);
/*     */     Iterator i;
/* 251 */     synchronized (this.sessions)
/*     */     {
/* 253 */       if (!this.started)
/* 254 */         return;
/* 255 */       this.started = true;
/* 256 */       for (i = this.sessions.iterator(); i.hasNext(); )
/*     */       {
/* 258 */         JmsSession session = (JmsSession)i.next();
/* 259 */         session.stop();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void close() throws JMSException
/*     */   {
/* 266 */     if (this.closed)
/* 267 */       return;
/* 268 */     this.closed = true;
/*     */ 
/* 270 */     if (this.trace)
/* 271 */       log.trace("close() " + this);
/*     */     Iterator i;
/* 273 */     synchronized (this.sessions)
/*     */     {
/* 275 */       for (i = this.sessions.iterator(); i.hasNext(); )
/*     */       {
/* 277 */         JmsSession session = (JmsSession)i.next();
/*     */         try
/*     */         {
/* 280 */           session.closeSession();
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 284 */           log.trace("Error closing session", t);
/*     */         }
/* 286 */         i.remove();
/*     */       }
/*     */     }
/*     */     Iterator i;
/* 290 */     synchronized (this.tempQueues)
/*     */     {
/* 292 */       for (i = this.tempQueues.iterator(); i.hasNext(); )
/*     */       {
/* 294 */         TemporaryQueue temp = (TemporaryQueue)i.next();
/*     */         try
/*     */         {
/* 297 */           if (this.trace)
/* 298 */             log.trace("Closing temporary queue " + temp + " for " + this);
/* 299 */           temp.delete();
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 303 */           log.trace("Error deleting temporary queue", t);
/*     */         }
/* 305 */         i.remove();
/*     */       }
/*     */     }
/*     */     Iterator i;
/* 309 */     synchronized (this.tempTopics)
/*     */     {
/* 311 */       for (i = this.tempTopics.iterator(); i.hasNext(); )
/*     */       {
/* 313 */         TemporaryTopic temp = (TemporaryTopic)i.next();
/*     */         try
/*     */         {
/* 316 */           if (this.trace)
/* 317 */             log.trace("Closing temporary topic " + temp + " for " + this);
/* 318 */           temp.delete();
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 322 */           log.trace("Error deleting temporary queue", t);
/*     */         }
/* 324 */         i.remove();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void closeSession(JmsSession session) throws JMSException
/*     */   {
/* 331 */     synchronized (this.sessions)
/*     */     {
/* 333 */       this.sessions.remove(session);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addTemporaryQueue(TemporaryQueue temp)
/*     */   {
/* 339 */     synchronized (this.tempQueues)
/*     */     {
/* 341 */       this.tempQueues.add(temp);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addTemporaryTopic(TemporaryTopic temp)
/*     */   {
/* 347 */     synchronized (this.tempTopics)
/*     */     {
/* 349 */       this.tempTopics.add(temp);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ConnectionConsumer createConnectionConsumer(Destination destination, ServerSessionPool pool, int maxMessages)
/*     */     throws JMSException
/*     */   {
/* 357 */     throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
/*     */   }
/*     */ 
/*     */   public ConnectionConsumer createConnectionConsumer(Destination destination, String name, ServerSessionPool pool, int maxMessages) throws JMSException
/*     */   {
/* 362 */     throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
/*     */   }
/*     */ 
/*     */   public Session createSession(boolean transacted, int acknowledgeMode)
/*     */     throws JMSException
/*     */   {
/* 368 */     checkClosed();
/* 369 */     return allocateConnection(transacted, acknowledgeMode, this.type);
/*     */   }
/*     */ 
/*     */   protected JmsSession allocateConnection(boolean transacted, int acknowledgeMode, int sessionType) throws JMSException {
/*     */     JMSException je;
/*     */     try {
/* 376 */       synchronized (this.sessions)
/*     */       {
/* 378 */         if ((this.mcf.isStrict()) && (!this.sessions.isEmpty()))
/* 379 */           throw new IllegalStateException("Only allowed one session per connection. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
/* 380 */         if (transacted)
/* 381 */           acknowledgeMode = 0;
/* 382 */         JmsConnectionRequestInfo info = new JmsConnectionRequestInfo(transacted, acknowledgeMode, sessionType);
/* 383 */         info.setUserName(this.userName);
/* 384 */         info.setPassword(this.password);
/* 385 */         info.setClientID(this.clientID);
/*     */ 
/* 387 */         if (this.trace)
/* 388 */           log.trace("Allocating session for " + this + " with request info=" + info);
/* 389 */         JmsSession session = (JmsSession)this.cm.allocateConnection(this.mcf, info);
/* 390 */         if (this.trace)
/* 391 */           log.trace("Allocated  " + this + " session=" + session);
/* 392 */         session.setJmsSessionFactory(this);
/* 393 */         if (this.started)
/* 394 */           session.start();
/* 395 */         this.sessions.add(session);
/* 396 */         return session;
/*     */       }
/*     */     }
/*     */     catch (ResourceException e)
/*     */     {
/* 401 */       log.error("could not create session", e);
/*     */ 
/* 403 */       je = new JMSException("Could not create a session: " + e);
/*     */ 
/* 405 */       je.setLinkedException(e);
/* 406 */     }throw je;
/*     */   }
/*     */ 
/*     */   protected void checkClosed()
/*     */     throws IllegalStateException
/*     */   {
/* 412 */     if (this.closed)
/* 413 */       throw new IllegalStateException("The connection is closed");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsSessionFactoryImpl
 * JD-Core Version:    0.6.0
 */